/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla;

import net.darkhax.wawla.config.WawlaConfiguration;
import net.darkhax.wawla.engine.InfoEngine;
import net.darkhax.wawla.engine.WailaEngine;
import net.darkhax.wawla.plugins.FeatureManager;
import net.darkhax.wawla.plugins.InfoProvider;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="wawla", name="What are We Looking at", version="2.5.269", guiFactory="", acceptableRemoteVersions="*", certificateFingerprint="d476d1b22b218a10d845928d1665d45fce301b27", acceptedMinecraftVersions="[1.12.2]")
public class Wawla {
    public static WawlaConfiguration config;
    public static InfoEngine engine;
    public static final Logger LOG;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new WawlaConfiguration("wawla");
        FeatureManager.init(event.getAsmData());
        config.init(FeatureManager.classes);
        config.sync();
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (Loader.isModLoaded((String)"waila")) {
            boolean isHwyla = false;
            try {
                Class.forName("mcp.mobius.waila.api.WailaPlugin");
                isHwyla = true;
            }
            catch (ClassNotFoundException e) {
                isHwyla = false;
            }
            engine = new WailaEngine(isHwyla);
        }
        if (engine == null) {
            LOG.warn("No info engine detected! No info will be displayed!");
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onItemTooltip(ItemTooltipEvent event) {
        if (event.getEntityPlayer() != null && event.getEntityPlayer().field_70170_p != null && event.getItemStack() != null) {
            for (InfoProvider provider : FeatureManager.itemProviders) {
                provider.addItemInfo(event.getToolTip(), event.getItemStack(), event.getFlags(), event.getEntityPlayer());
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onOverlayRendered(RenderGameOverlayEvent.Text event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74330_P && event.getLeft() != null && engine != null) {
            event.getLeft().add("[Wawla] Info Engine: " + engine.getName());
        }
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        LOG.warn("Invalid fingerprint detected! The file " + event.getSource().getName() + " may have been tampered with. This version will NOT be supported by the author!");
    }

    static {
        LOG = LogManager.getLogger((String)"WAWLA");
    }
}

