/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.advancements.instances;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import java.util.List;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class ConstellationInstance
extends AbstractCriterionInstance {
    private boolean constellationMajor = false;
    private boolean constellationWeak = false;
    private boolean constellationMinor = false;
    private List<String> constellationNames = Lists.newArrayList();

    private ConstellationInstance(ResourceLocation id) {
        super(id);
    }

    public boolean test(IConstellation discovered) {
        if (this.constellationMajor && !(discovered instanceof IMajorConstellation)) {
            return false;
        }
        if (this.constellationWeak && (!(discovered instanceof IWeakConstellation) || discovered instanceof IMajorConstellation)) {
            return false;
        }
        if (this.constellationMinor && !(discovered instanceof IMinorConstellation)) {
            return false;
        }
        return this.constellationNames.isEmpty() || this.constellationNames.contains(discovered.getUnlocalizedName());
    }

    public static ConstellationInstance deserialize(ResourceLocation id, JsonObject json) {
        ConstellationInstance ci = new ConstellationInstance(id);
        ci.constellationMajor = JsonUtils.func_151209_a((JsonObject)json, (String)"major", (boolean)false);
        ci.constellationWeak = JsonUtils.func_151209_a((JsonObject)json, (String)"weak", (boolean)false);
        ci.constellationMinor = JsonUtils.func_151209_a((JsonObject)json, (String)"minor", (boolean)false);
        for (JsonElement je : JsonUtils.func_151213_a((JsonObject)json, (String)"constellations", (JsonArray)new JsonArray())) {
            IConstellation cst;
            if (!je.isJsonPrimitive() || je.getAsJsonPrimitive().isString() || (cst = ConstellationRegistry.getConstellationByName(je.getAsString())) == null) continue;
            ci.constellationNames.add(cst.getUnlocalizedName());
        }
        return ci;
    }
}

