/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base.patreon.base;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.texture.TextureSpritePlane;
import hellfirepvp.astralsorcery.client.util.resource.SpriteQuery;
import hellfirepvp.astralsorcery.client.util.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffectHelper;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PtEffectFixedSprite
extends PatreonEffectHelper.PatreonEffect {
    private Object activeSprite;
    private SpriteQuery spriteQuery;
    private Function<EntityPlayer, Vector3> positionFunction = Vector3::atEntityCenter;

    public PtEffectFixedSprite(PatreonEffectHelper.FlareColor chosenColor, SpriteQuery spriteQuery) {
        super(chosenColor);
        this.spriteQuery = spriteQuery;
    }

    private Vector3 getPosition(EntityPlayer player) {
        return this.positionFunction.apply(player);
    }

    public PtEffectFixedSprite setPositionFunction(Function<EntityPlayer, Vector3> positionFunction) {
        this.positionFunction = positionFunction;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void doEffect(EntityPlayer player) {
        SpriteSheetResource res = this.spriteQuery.resolveSprite();
        if (res != null) {
            this.makeSprite(res, player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private TextureSpritePlane makeSprite(SpriteSheetResource resource, EntityPlayer owningPlayer) {
        TextureSpritePlane spr = (TextureSpritePlane)this.activeSprite;
        if (spr == null || spr.canRemove() || spr.isRemoved()) {
            spr = EffectHandler.getInstance().textureSpritePlane(resource, Vector3.RotAxis.Y_AXIS.clone());
            spr.setPosFunc((fx, position, motionToBeMoved) -> this.getPosition(owningPlayer));
            spr.setNoRotation(45.0f).setAlphaMultiplier(1.0f);
            spr.setRefreshFunc(() -> !owningPlayer.field_70128_L && Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.field_73011_w != null);
            spr.setScale(10.0f);
            this.activeSprite = spr;
        }
        return spr;
    }
}

