/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base.patreon.flare;

import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffectHelper;
import hellfirepvp.astralsorcery.common.base.patreon.base.PtEffectFixedSprite;
import hellfirepvp.astralsorcery.common.base.patreon.flare.PatreonPartialEntity;
import hellfirepvp.astralsorcery.common.data.DataPatreonFlares;
import hellfirepvp.astralsorcery.common.data.SyncDataHolder;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.EnumSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class PatreonFlareManagerClient
implements ITickHandler {
    public static PatreonFlareManagerClient INSTANCE = new PatreonFlareManagerClient();

    private PatreonFlareManagerClient() {
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        WorldClient clWorld = Minecraft.func_71410_x().field_71441_e;
        EntityPlayerSP thisPlayer = Minecraft.func_71410_x().field_71439_g;
        if (clWorld == null || thisPlayer == null) {
            return;
        }
        int clDim = clWorld.field_73011_w.getDimension();
        Vector3 thisPlayerPos = Vector3.atEntityCenter((Entity)thisPlayer);
        DataPatreonFlares dataFlares = (DataPatreonFlares)SyncDataHolder.getDataClient("PatreonFlares");
        for (PatreonPartialEntity flare : dataFlares.getEntities(Side.CLIENT)) {
            if (flare.getLastTickedDim() == null || clDim != flare.getLastTickedDim()) continue;
            if (flare.getPos().distanceSquared(thisPlayerPos) <= (double)Config.maxEffectRenderDistanceSq) {
                flare.tickInRenderDistance();
            }
            flare.update((World)clWorld);
        }
        for (EntityPlayer pl : clWorld.field_73010_i) {
            PatreonEffectHelper.PatreonEffect eff = PatreonEffectHelper.getEffect(Side.CLIENT, pl.func_110124_au());
            if (eff == null || !(eff instanceof PtEffectFixedSprite)) continue;
            ((PtEffectFixedSprite)eff).doEffect(pl);
        }
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.CLIENT);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "Patreon Flare Manager (Client)";
    }
}

