/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes;

import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.item.gem.ItemPerkGem;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface GemSlotPerk {
    public static final String SOCKET_DATA_KEY = "socketedItem";

    default public boolean hasItem(EntityPlayer player, Side side) {
        return this.hasItem(player, side, null);
    }

    default public boolean hasItem(EntityPlayer player, Side side, @Nullable NBTTagCompound data) {
        return !this.getContainedItem(player, side, data).func_190926_b();
    }

    default public ItemStack getContainedItem(EntityPlayer player, Side side) {
        return this.getContainedItem(player, side, null);
    }

    default public ItemStack getContainedItem(EntityPlayer player, Side side, @Nullable NBTTagCompound dataOvr) {
        NBTTagCompound data;
        if (!(this instanceof AbstractPerk)) {
            throw new UnsupportedOperationException("Cannot do perk-specific socketing logic on something that's not a perk!");
        }
        PlayerProgress prog = ResearchManager.getProgress(player, side);
        if (prog == null || !prog.hasPerkUnlocked((AbstractPerk)((Object)this))) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound nBTTagCompound = data = dataOvr != null ? dataOvr : ((AbstractPerk)((Object)this)).getPerkData(player, side);
        if (data == null) {
            return ItemStack.field_190927_a;
        }
        return NBTHelper.getStack(data, SOCKET_DATA_KEY);
    }

    default public boolean setContainedItem(EntityPlayer player, Side side, ItemStack stack) {
        return this.setContainedItem(player, side, null, stack);
    }

    default public boolean setContainedItem(EntityPlayer player, Side side, @Nullable NBTTagCompound dataOvr, ItemStack stack) {
        NBTTagCompound data;
        if (!(this instanceof AbstractPerk)) {
            throw new UnsupportedOperationException("Cannot do perk-specific socketing logic on something that's not a perk!");
        }
        PlayerProgress prog = ResearchManager.getProgress(player, side);
        if (prog == null || !prog.hasPerkUnlocked((AbstractPerk)((Object)this))) {
            return false;
        }
        boolean updateData = dataOvr == null;
        NBTTagCompound nBTTagCompound = data = dataOvr != null ? dataOvr : ((AbstractPerk)((Object)this)).getPerkData(player, side);
        if (data == null) {
            return false;
        }
        NBTTagCompound prev = data.func_74737_b();
        if (stack.func_190926_b()) {
            data.func_82580_o(SOCKET_DATA_KEY);
        } else {
            NBTHelper.setStack(data, SOCKET_DATA_KEY, stack);
        }
        if (updateData) {
            ResearchManager.setPerkData(player, (AbstractPerk)((Object)this), prev, data);
        }
        return true;
    }

    default public void dropItemToPlayer(EntityPlayer player) {
        this.dropItemToPlayer(player, null);
    }

    default public void dropItemToPlayer(EntityPlayer player, @Nullable NBTTagCompound data) {
        boolean updateData;
        if (!(this instanceof AbstractPerk)) {
            throw new UnsupportedOperationException("Cannot do perk-specific socketing logic on something that's not a perk!");
        }
        if (player.func_130014_f_().field_72995_K) {
            return;
        }
        boolean bl = updateData = data == null;
        if (updateData) {
            data = ((AbstractPerk)((Object)this)).getPerkData(player, Side.SERVER);
        }
        if (data == null) {
            return;
        }
        NBTTagCompound prev = data.func_74737_b();
        ItemStack contained = this.getContainedItem(player, Side.SERVER, data);
        if (!contained.func_190926_b() && !player.func_191521_c(contained)) {
            ItemUtils.dropItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, contained);
        }
        this.setContainedItem(player, Side.SERVER, data, ItemStack.field_190927_a);
        if (updateData) {
            ResearchManager.setPerkData(player, (AbstractPerk)((Object)this), prev, data);
        }
    }

    @SideOnly(value=Side.CLIENT)
    default public void addTooltipInfo(Collection<String> tooltip) {
        if (!(this instanceof AbstractPerk)) {
            return;
        }
        PlayerProgress prog = ResearchManager.getProgress((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Side.CLIENT);
        if (prog == null) {
            return;
        }
        ItemStack contained = this.getContainedItem((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Side.CLIENT);
        if (contained.func_190926_b()) {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"perk.info.gem.empty", (Object[])new Object[0]));
            if (prog.hasPerkEffect((AbstractPerk)((Object)this))) {
                boolean has;
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"perk.info.gem.content.empty", (Object[])new Object[0]));
                boolean bl = has = !ItemUtils.findItemsIndexedInPlayerInventory((EntityPlayer)Minecraft.func_71410_x().field_71439_g, s -> !s.func_190926_b() && s.func_77973_b() instanceof ItemPerkGem && !ItemPerkGem.getModifiers(s).isEmpty()).isEmpty();
                if (!has) {
                    tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"perk.info.gem.content.empty.none", (Object[])new Object[0]));
                }
            }
        } else {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"perk.info.gem.content.item", (Object[])new Object[]{contained.func_77953_t().field_77937_e + contained.func_82833_r()}));
            if (prog.hasPerkEffect((AbstractPerk)((Object)this))) {
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"perk.info.gem.remove", (Object[])new Object[0]));
            }
        }
    }
}

