/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.KeyPerk;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.enchantment.dynamic.DynamicEnchantment;
import hellfirepvp.astralsorcery.common.event.DynamicEnchantmentEvent;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class KeyAddEnchantment
extends KeyPerk {
    private List<DynamicEnchantment> enchantments = Lists.newArrayList();

    public KeyAddEnchantment(String name, int x, int y) {
        super(name, x, y);
    }

    public KeyAddEnchantment addEnchantment(Enchantment ench, int level) {
        return this.addEnchantment(DynamicEnchantment.Type.ADD_TO_SPECIFIC, ench, level);
    }

    public KeyAddEnchantment addEnchantment(DynamicEnchantment.Type type, Enchantment ench, int level) {
        this.enchantments.add(new DynamicEnchantment(type, ench, level));
        return this;
    }

    @SubscribeEvent
    public void onEnchantmentAdd(DynamicEnchantmentEvent.Add event) {
        Side side;
        PlayerProgress prog;
        EntityPlayer player = event.getResolvedPlayer();
        if (player != null && (prog = ResearchManager.getProgress(player, side = player.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER)) != null && prog.hasPerkEffect(this)) {
            List<DynamicEnchantment> listedEnchantments = event.getEnchantmentsToApply();
            for (DynamicEnchantment ench : this.enchantments) {
                DynamicEnchantment added = MiscUtils.iterativeSearch(listedEnchantments, e -> (e.getEnchantment() == null ? ench.getEnchantment() == null : e.getEnchantment().equals(ench.getEnchantment())) && e.getType().equals((Object)ench.getType()));
                if (added != null) {
                    added.setLevelAddition(added.getLevelAddition() + ench.getLevelAddition());
                    continue;
                }
                listedEnchantments.add(ench);
            }
        }
    }
}

