/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree.root;

import hellfirepvp.astralsorcery.common.constellation.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.root.RootPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.types.IPlayerTickPerk;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.util.PlayerActivityManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraftforge.fml.relauncher.Side;

public class VicioRootPerk
extends RootPerk
implements IPlayerTickPerk {
    private Map<StatBase, Map<UUID, Integer>> moveTrackMap = new HashMap<StatBase, Map<UUID, Integer>>();

    public VicioRootPerk(int x, int y) {
        super("vicio", Constellations.vicio, x, y);
    }

    @Override
    public void removePerkLogic(EntityPlayer player, Side side) {
        super.removePerkLogic(player, side);
        if (side == Side.SERVER) {
            this.moveTrackMap.computeIfAbsent(StatList.field_188100_j, s -> new HashMap()).remove(player.func_110124_au());
            this.moveTrackMap.computeIfAbsent(StatList.field_188102_l, s -> new HashMap()).remove(player.func_110124_au());
            this.moveTrackMap.computeIfAbsent(StatList.field_188104_p, s -> new HashMap()).remove(player.func_110124_au());
        }
    }

    @Override
    public void clearCaches(Side side) {
        super.clearCaches(side);
        if (side == Side.SERVER) {
            this.moveTrackMap.clear();
        }
    }

    @Override
    public void onPlayerTick(EntityPlayer player, Side side) {
        if (side == Side.SERVER && player instanceof EntityPlayerMP) {
            UUID uuid = player.func_110124_au();
            StatisticsManagerServer manager = ((EntityPlayerMP)player).func_147099_x();
            int walked = manager.func_77444_a(StatList.field_188100_j);
            int sprint = manager.func_77444_a(StatList.field_188102_l);
            int flown = manager.func_77444_a(StatList.field_188104_p);
            int lastWalked = this.moveTrackMap.computeIfAbsent(StatList.field_188100_j, s -> new HashMap()).computeIfAbsent(uuid, u -> walked);
            int lastSprint = this.moveTrackMap.computeIfAbsent(StatList.field_188102_l, s -> new HashMap()).computeIfAbsent(uuid, u -> sprint);
            int lastFly = this.moveTrackMap.computeIfAbsent(StatList.field_188104_p, s -> new HashMap()).computeIfAbsent(uuid, u -> flown);
            float added = 0.0f;
            if (walked > lastWalked) {
                if ((added += Math.min((float)(walked - lastWalked), 500.0f)) >= 500.0f) {
                    added = 500.0f;
                }
                this.moveTrackMap.get(StatList.field_188100_j).put(uuid, walked);
            }
            if (sprint > lastSprint) {
                if ((added += Math.min((float)(sprint - lastSprint), 500.0f)) >= 500.0f) {
                    added = 500.0f;
                }
                added *= 1.2f;
                this.moveTrackMap.get(StatList.field_188102_l).put(uuid, sprint);
            }
            if (flown > lastFly) {
                added += Math.min((float)(flown - lastFly), 500.0f);
                added *= 0.4f;
                this.moveTrackMap.get(StatList.field_188104_p).put(uuid, flown);
            }
            if (!PlayerActivityManager.INSTANCE.isPlayerActiveServer(player)) {
                return;
            }
            if (added > 0.0f) {
                PlayerProgress prog = ResearchManager.getProgress(player, side);
                added *= 0.01f;
                added *= this.expMultiplier;
                added = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, "astralsorcery.perkeffect", added);
                added = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, "astralsorcery.expgain", added);
                added = AttributeEvent.postProcessModded(player, "astralsorcery.expgain", added);
                ResearchManager.modifyExp(player, added);
            }
        }
    }
}

