/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.client;

import hellfirepvp.astralsorcery.client.gui.GuiJournalPerkTree;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTree;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.ClientReplyPacket;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktUnlockPerk
implements IMessage,
IMessageHandler<PktUnlockPerk, PktUnlockPerk>,
ClientReplyPacket {
    private AbstractPerk perk;
    private boolean serverAccept = false;

    public PktUnlockPerk() {
    }

    public PktUnlockPerk(boolean serverAccepted, AbstractPerk perk) {
        this.serverAccept = serverAccepted;
        this.perk = perk;
    }

    public void fromBytes(ByteBuf buf) {
        this.serverAccept = buf.readBoolean();
        AbstractPerk perk = PerkTree.PERK_TREE.getPerk(new ResourceLocation(ByteBufUtils.readString(buf)));
        if (perk != null) {
            this.perk = perk;
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.serverAccept);
        ByteBufUtils.writeString(buf, this.perk.getRegistryName().toString());
    }

    public PktUnlockPerk onMessage(PktUnlockPerk message, MessageContext ctx) {
        if (ctx.side == Side.SERVER) {
            MinecraftServer ms = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (ms != null) {
                ms.func_152344_a(() -> {
                    EntityPlayerMP pl = ctx.getServerHandler().field_147369_b;
                    if (pl != null && message.perk != null) {
                        AbstractPerk perk = message.perk;
                        PlayerProgress prog = ResearchManager.getProgress((EntityPlayer)pl, ctx.side);
                        if (prog != null && !prog.hasPerkUnlocked(perk) && perk.mayUnlockPerk(prog, (EntityPlayer)pl) && ResearchManager.applyPerk((EntityPlayer)pl, message.perk)) {
                            PacketChannel.CHANNEL.sendTo((IMessage)new PktUnlockPerk(true, message.perk), pl);
                        }
                    }
                });
            }
        } else {
            this.recUnlockResultClient(message);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void recUnlockResultClient(PktUnlockPerk message) {
        if (message.serverAccept) {
            AbstractPerk perk = message.perk;
            GuiScreen current = Minecraft.func_71410_x().field_71462_r;
            if (current != null && current instanceof GuiJournalPerkTree) {
                Minecraft.func_71410_x().func_152344_a(() -> ((GuiJournalPerkTree)current).playUnlockAnimation(perk));
            }
        }
    }
}

