/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.registry;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkConverter;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.AttributeModifierPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.AttributeTypeRegistry;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeType;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.AttributeAllElementalResist;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.AttributeArrowSpeed;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.AttributeBreakSpeed;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.AttributeCritChance;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.AttributeCritMultiplier;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.AttributeDodge;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.AttributeEnchantmentEffectiveness;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.AttributeLifeLeech;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.AttributeLifeRecovery;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.AttributePotionDuration;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.AttributeProjectileAttackDamage;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.AttributeThorns;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.AttributeTypeArmor;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.AttributeTypeArmorToughness;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.AttributeTypeAttackSpeed;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.AttributeTypeMaxHealth;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.AttributeTypeMaxReach;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.AttributeTypeMeleeAttackDamage;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.AttributeTypeMovementSpeed;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.AttributeTypePerkEffect;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.AttributeTypeSwimSpeed;
import hellfirepvp.astralsorcery.common.constellation.perk.reader.AttributeReader;
import hellfirepvp.astralsorcery.common.constellation.perk.reader.AttributeReaderRegistry;
import hellfirepvp.astralsorcery.common.constellation.perk.reader.impl.AddedPercentageAttributeReader;
import hellfirepvp.astralsorcery.common.constellation.perk.reader.impl.BreakSpeedAttributeReader;
import hellfirepvp.astralsorcery.common.constellation.perk.reader.impl.PercentageAttributeReader;
import hellfirepvp.astralsorcery.common.constellation.perk.reader.impl.VanillaAttributeReader;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTree;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTreePoint;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.constellation.PerkAlcara;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.constellation.PerkGelu;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.constellation.PerkUlteria;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.constellation.PerkVorux;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.CoreRootPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.GemSlotMajorPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.KeyPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.MajorPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.PerkTreeConnector;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyAddEnchantment;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyAreaOfEffect;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyBleed;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyChainMining;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyCheatDeath;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyCleanseBadPotions;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyCullAttack;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyDamageArmor;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyDamageEffect;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyDigTypes;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyDisarm;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyGrowable;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyLastBreath;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyLightningArc;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyMagnetDrops;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyMantleFlight;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyMending;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyNoArmor;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyNoKnockBack;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyProjectileDistance;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyProjectileProximity;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyRampage;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyReach;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyReducedFood;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeySpawnLights;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyStepAssist;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyStoneEnrichment;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key.KeyVoidTrash;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.root.AevitasRootPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.root.ArmaraRootPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.root.DiscidiaRootPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.root.EvorsioRootPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.root.VicioRootPerk;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.event.APIRegistryEvent;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;

public class RegistryPerks {
    private static AttributeModifierPerk perkRootMajorDamage;
    private static AttributeModifierPerk perkRootMajorHealth;
    private static AttributeModifierPerk perkRootMajorMovespeed;
    private static AttributeModifierPerk perkRootMajorArmor;
    private static AttributeModifierPerk perkRootMajorHarvest;

    public static void initPerkTree() {
        RegistryPerks.initializeAttributeTypes();
        RegistryPerks.initializeAttributeInterpreters();
        RegistryPerks.initializeRoot();
        RegistryPerks.initializeAevitasRoot();
        RegistryPerks.initializeVicioRoot();
        RegistryPerks.initializeArmaraRoot();
        RegistryPerks.initializeDiscidiaRoot();
        RegistryPerks.initializeEvorsioRoot();
        RegistryPerks.initializeRootPerkWheel();
        RegistryPerks.initializePerkInteriorTravelWheel();
        RegistryPerks.initializePerkCore();
        RegistryPerks.initializeAevitasBranch();
        RegistryPerks.initializeVicioBranch();
        RegistryPerks.initializeArmaraBranch();
        RegistryPerks.initializeDiscidiaBranch();
        RegistryPerks.initializeEvorsioBranch();
        RegistryPerks.initializePerkExteriorTravelWheel();
        RegistryPerks.initializeAevitasKeyPerks();
        RegistryPerks.initializeEvorsioKeyPerks();
        RegistryPerks.initializeDiscidiaKeyPerks();
        RegistryPerks.initializeArmaraKeyPerks();
        RegistryPerks.initializeVicioKeyPerks();
        RegistryPerks.initializePerkEffectPerks();
        RegistryPerks.initializeOuterAevitasPerks();
        RegistryPerks.initializeOuterEvorsioPerks();
        RegistryPerks.initializeOuterDiscidiaPerks();
        RegistryPerks.initializeOuterArmaraPerks();
        RegistryPerks.initializeOuterVicioPerks();
        RegistryPerks.initializeMinorConstellationPerks();
        RegistryPerks.initializeTreeConnectorPerks();
        MinecraftForge.EVENT_BUS.post((Event)new APIRegistryEvent.PerkRegister());
    }

    public static void postProcessPerks() {
        List<AbstractPerk> copyPerks = PerkTree.PERK_TREE.getPerkPoints().stream().map(PerkTreePoint::getPerk).collect(Collectors.toList());
        if (Mods.CRAFTTWEAKER.isPresent()) {
            RegistryPerks.applyCraftTweakerModifications(copyPerks);
        }
        for (AbstractPerk perk : copyPerks) {
            APIRegistryEvent.PerkPostRemove remove = new APIRegistryEvent.PerkPostRemove(perk);
            MinecraftForge.EVENT_BUS.post((Event)remove);
            if (!remove.isRemoved()) continue;
            PerkTree.PERK_TREE.removePerk(perk);
        }
        PerkTree.PERK_TREE.freeze();
    }

    @Optional.Method(modid="crafttweaker")
    private static void applyCraftTweakerModifications(List<AbstractPerk> perks) {
        perks.forEach(AbstractPerk::adjustMultipliers);
    }

    private static void initializeMinorConstellationPerks() {
        AttributeModifierPerk perkGelu1 = new AttributeModifierPerk("gelu_inc_perkexp", 23, 18);
        perkGelu1.addModifier(0.06f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.expgain");
        AttributeModifierPerk perkGelu2 = (AttributeModifierPerk)new AttributeModifierPerk("gelu_inc_perkexp_1", 25, 16).setNameOverride(perkGelu1);
        perkGelu2.addModifier(0.06f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.expgain");
        PerkGelu gelu = new PerkGelu(26, 19);
        PerkTree.PERK_TREE.registerPerk(perkGelu1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_def_3"));
        PerkTree.PERK_TREE.registerPerk(perkGelu2).connect(perkGelu1);
        PerkTree.PERK_TREE.registerPerk(gelu).connect(perkGelu2);
        perkGelu1.setRequireDiscoveredConstellation(Constellations.gelu);
        perkGelu2.setRequireDiscoveredConstellation(Constellations.gelu);
        gelu.setRequireDiscoveredConstellation(Constellations.gelu);
        AttributeModifierPerk perkUlteria1 = new AttributeModifierPerk("ulteria_more_perkexp", -28, 15);
        perkUlteria1.addModifier(1.05f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.expgain");
        AttributeModifierPerk perkUlteria2 = (AttributeModifierPerk)new AttributeModifierPerk("ulteria_more_perkexp_1", -26, 17).setNameOverride(perkUlteria1);
        perkUlteria2.addModifier(1.05f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.expgain");
        PerkUlteria ulteria = new PerkUlteria(-29, 18);
        PerkTree.PERK_TREE.registerPerk(perkUlteria1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_life_2"));
        PerkTree.PERK_TREE.registerPerk(perkUlteria2).connect(perkUlteria1);
        PerkTree.PERK_TREE.registerPerk(ulteria).connect(perkUlteria2);
        perkUlteria1.setRequireDiscoveredConstellation(Constellations.ulteria);
        perkUlteria2.setRequireDiscoveredConstellation(Constellations.ulteria);
        ulteria.setRequireDiscoveredConstellation(Constellations.ulteria);
        AttributeModifierPerk perkVorux1 = new AttributeModifierPerk("vorux_inc_perkeff", 14, -27);
        perkVorux1.addModifier(0.04f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkVorux2 = (AttributeModifierPerk)new AttributeModifierPerk("vorux_inc_perkeff_1", 12, -29).setNameOverride(perkVorux1);
        perkVorux2.addModifier(0.04f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        PerkVorux vorux = new PerkVorux(15, -30);
        PerkTree.PERK_TREE.registerPerk(perkVorux1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_dmg_2"));
        PerkTree.PERK_TREE.registerPerk(perkVorux2).connect(perkVorux1);
        PerkTree.PERK_TREE.registerPerk(vorux).connect(perkVorux2);
        perkVorux1.setRequireDiscoveredConstellation(Constellations.vorux);
        perkVorux2.setRequireDiscoveredConstellation(Constellations.vorux);
        vorux.setRequireDiscoveredConstellation(Constellations.vorux);
        AttributeModifierPerk perkAlcara1 = new AttributeModifierPerk("alcara_more_perkeff", -25, -17);
        perkAlcara1.addModifier(1.04f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkAlcara2 = (AttributeModifierPerk)new AttributeModifierPerk("alcara_more_perkeff_1", -27, -15).setNameOverride(perkAlcara1);
        perkAlcara2.addModifier(1.04f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.perkeffect");
        PerkAlcara alcara = new PerkAlcara(-28, -18);
        PerkTree.PERK_TREE.registerPerk(perkAlcara1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_mine_2"));
        PerkTree.PERK_TREE.registerPerk(perkAlcara2).connect(perkAlcara1);
        PerkTree.PERK_TREE.registerPerk(alcara).connect(perkAlcara2);
        perkAlcara1.setRequireDiscoveredConstellation(Constellations.alcara);
        perkAlcara2.setRequireDiscoveredConstellation(Constellations.alcara);
        alcara.setRequireDiscoveredConstellation(Constellations.alcara);
    }

    private static void initializeOuterVicioPerks() {
        float addedIncMsReach = 0.02f;
        AttributeModifierPerk perkVR1 = new AttributeModifierPerk("outer_s_inc_trv", 13, 23);
        perkVR1.addModifier(addedIncMsReach, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.movespeed");
        perkVR1.addModifier(addedIncMsReach, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.reach");
        AttributeModifierPerk perkVR2 = (AttributeModifierPerk)new AttributeModifierPerk("outer_s_inc_trv_1", 7, 26).setNameOverride(perkVR1);
        perkVR2.addModifier(addedIncMsReach, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.movespeed");
        perkVR2.addModifier(addedIncMsReach, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.reach");
        AttributeModifierPerk perkVR3 = (AttributeModifierPerk)new AttributeModifierPerk("outer_s_inc_trv_2", 1, 29).setNameOverride(perkVR1);
        perkVR3.addModifier(addedIncMsReach, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.movespeed");
        perkVR3.addModifier(addedIncMsReach, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.reach");
        AttributeModifierPerk perkVR4 = (AttributeModifierPerk)new AttributeModifierPerk("outer_s_inc_trv_3", -7, 27).setNameOverride(perkVR1);
        perkVR4.addModifier(addedIncMsReach, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.movespeed");
        perkVR4.addModifier(addedIncMsReach, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.reach");
        AttributeModifierPerk perkVR5 = (AttributeModifierPerk)new AttributeModifierPerk("outer_s_inc_trv_4", -12, 24).setNameOverride(perkVR1);
        perkVR5.addModifier(addedIncMsReach, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.movespeed");
        perkVR5.addModifier(addedIncMsReach, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.reach");
        PerkTree.PERK_TREE.registerPerk(perkVR1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_def_4"));
        PerkTree.PERK_TREE.registerPerk(perkVR2).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_12")).connect(perkVR1);
        PerkTree.PERK_TREE.registerPerk(perkVR3).connect(perkVR2);
        PerkTree.PERK_TREE.registerPerk(perkVR4).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_13")).connect(perkVR3);
        PerkTree.PERK_TREE.registerPerk(perkVR5).connect(perkVR4).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_life"));
        AttributeModifierPerk lssArmorLife1 = new AttributeModifierPerk("flight_life_armor", 4, 30);
        lssArmorLife1.addModifier(0.8f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.maxhealth");
        lssArmorLife1.addModifier(0.8f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.armor");
        AttributeModifierPerk lssArmorLife2 = (AttributeModifierPerk)new AttributeModifierPerk("flight_life_armor_1", 5, 31).setNameOverride(lssArmorLife1);
        lssArmorLife2.addModifier(0.8f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.maxhealth");
        lssArmorLife2.addModifier(0.8f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.armor");
        AttributeModifierPerk lssArmorLife3 = (AttributeModifierPerk)new AttributeModifierPerk("flight_life_armor_2", 4, 32).setNameOverride(lssArmorLife1);
        lssArmorLife3.addModifier(0.8f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.maxhealth");
        lssArmorLife3.addModifier(0.8f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.armor");
        AttributeModifierPerk lssDodgeMs = new AttributeModifierPerk("flight_ms_dodge", 5, 33);
        lssDodgeMs.addModifier(0.7f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.dodge");
        lssDodgeMs.addModifier(0.7f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.movespeed");
        KeyMantleFlight mantleFlight = new KeyMantleFlight("key_mantle_flight", 4, 34);
        PerkTree.PERK_TREE.registerPerk(lssArmorLife1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_trv_2"));
        PerkTree.PERK_TREE.registerPerk(lssArmorLife2).connect(lssArmorLife1);
        PerkTree.PERK_TREE.registerPerk(lssArmorLife3).connect(lssArmorLife2);
        PerkTree.PERK_TREE.registerPerk(lssDodgeMs).connect(lssArmorLife3);
        PerkTree.PERK_TREE.registerPerk(mantleFlight).connect(lssDodgeMs);
        AttributeModifierPerk atsReach1 = new AttributeModifierPerk("magnet_ats_reach", -10, 23);
        atsReach1.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.attackspeed");
        atsReach1.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.reach");
        AttributeModifierPerk atsReach2 = (AttributeModifierPerk)new AttributeModifierPerk("magnet_ats_reach_1", -9, 24).setNameOverride(atsReach1);
        atsReach2.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.attackspeed");
        atsReach2.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.reach");
        KeyMagnetDrops magnetDrops = new KeyMagnetDrops("key_magnet_drops", -8, 23);
        PerkTree.PERK_TREE.registerPerk(atsReach1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_trv_4"));
        PerkTree.PERK_TREE.registerPerk(atsReach2).connect(atsReach1);
        PerkTree.PERK_TREE.registerPerk(magnetDrops).connect(atsReach2);
    }

    private static void initializeOuterArmaraPerks() {
        float addedIncArmorEle = 0.02f;
        AttributeModifierPerk perkDef1 = new AttributeModifierPerk("outer_s_inc_def", 26, -5);
        perkDef1.addModifier(addedIncArmorEle, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.armor");
        perkDef1.addModifier(addedIncArmorEle, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.allres");
        AttributeModifierPerk perkDef2 = (AttributeModifierPerk)new AttributeModifierPerk("outer_s_inc_def_1", 24, 1).setNameOverride(perkDef1);
        perkDef2.addModifier(addedIncArmorEle, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.armor");
        perkDef2.addModifier(addedIncArmorEle, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.allres");
        AttributeModifierPerk perkDef3 = (AttributeModifierPerk)new AttributeModifierPerk("outer_s_inc_def_2", 26, 9).setNameOverride(perkDef1);
        perkDef3.addModifier(addedIncArmorEle, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.armor");
        perkDef3.addModifier(addedIncArmorEle, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.allres");
        AttributeModifierPerk perkDef4 = (AttributeModifierPerk)new AttributeModifierPerk("outer_s_inc_def_3", 22, 15).setNameOverride(perkDef1);
        perkDef4.addModifier(addedIncArmorEle, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.armor");
        perkDef4.addModifier(addedIncArmorEle, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.allres");
        AttributeModifierPerk perkDef5 = (AttributeModifierPerk)new AttributeModifierPerk("outer_s_inc_def_4", 20, 20).setNameOverride(perkDef1);
        perkDef5.addModifier(addedIncArmorEle, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.armor");
        perkDef5.addModifier(addedIncArmorEle, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.allres");
        PerkTree.PERK_TREE.registerPerk(perkDef1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_dmg_5"));
        PerkTree.PERK_TREE.registerPerk(perkDef2).connect(perkDef1);
        PerkTree.PERK_TREE.registerPerk(perkDef3).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_7")).connect(perkDef2);
        PerkTree.PERK_TREE.registerPerk(perkDef4).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_9")).connect(perkDef3);
        PerkTree.PERK_TREE.registerPerk(perkDef5).connect(perkDef4);
        AttributeModifierPerk perkPerkEffSlot1 = new AttributeModifierPerk("def_gem_path", 15, 20);
        perkPerkEffSlot1.addModifier(1.02f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkPerkEffSlot2 = (AttributeModifierPerk)new AttributeModifierPerk("def_gem_path_1", 14, 21).setNameOverride(perkPerkEffSlot1);
        perkPerkEffSlot2.addModifier(1.02f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.perkeffect");
        GemSlotMajorPerk perkDefGemSlot = new GemSlotMajorPerk("def_gem_slot", 13, 20);
        PerkTree.PERK_TREE.registerPerk(perkPerkEffSlot1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_10"));
        PerkTree.PERK_TREE.registerPerk(perkPerkEffSlot2).connect(perkPerkEffSlot1);
        PerkTree.PERK_TREE.registerPerk(perkDefGemSlot).connect(perkPerkEffSlot2);
        AttributeModifierPerk perkIncLRedA1 = new AttributeModifierPerk("unwav_life_armor", 27, 11);
        perkIncLRedA1.addModifier(0.08f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.maxhealth");
        perkIncLRedA1.addModifier(0.75f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.armor");
        AttributeModifierPerk perkIncLRedA2 = (AttributeModifierPerk)new AttributeModifierPerk("unwav_life_armor_1", 28, 12).setNameOverride(perkIncLRedA1);
        perkIncLRedA2.addModifier(0.08f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.maxhealth");
        perkIncLRedA2.addModifier(0.75f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.armor");
        KeyNoKnockBack noKnockBack = new KeyNoKnockBack("key_no_knockback", 29, 11);
        PerkTree.PERK_TREE.registerPerk(perkIncLRedA1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_def_2"));
        PerkTree.PERK_TREE.registerPerk(perkIncLRedA2).connect(perkIncLRedA1);
        PerkTree.PERK_TREE.registerPerk(noKnockBack).connect(perkIncLRedA2);
        AttributeModifierPerk perkIncArmor1 = new AttributeModifierPerk("bol_red_inc_armor", 26, 2);
        perkIncArmor1.addModifier(0.06f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.armor");
        AttributeModifierPerk perkIncArmor2 = (AttributeModifierPerk)new AttributeModifierPerk("bol_red_inc_armor_1", 27, 3).setNameOverride(perkIncArmor1);
        perkIncArmor2.addModifier(0.06f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.armor");
        AttributeModifierPerk perkIncArmor3 = (AttributeModifierPerk)new AttributeModifierPerk("bol_red_inc_armor_2", 28, 2).setNameOverride(perkIncArmor1);
        perkIncArmor3.addModifier(0.06f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.armor");
        KeyDamageArmor keyDamageArmor = new KeyDamageArmor("key_damage_armor", 29, 3, 0.05f);
        PerkTree.PERK_TREE.registerPerk(perkIncArmor1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_def_1"));
        PerkTree.PERK_TREE.registerPerk(perkIncArmor2).connect(perkIncArmor1);
        PerkTree.PERK_TREE.registerPerk(perkIncArmor3).connect(perkIncArmor2);
        PerkTree.PERK_TREE.registerPerk(keyDamageArmor).connect(perkIncArmor3);
    }

    private static void initializeOuterDiscidiaPerks() {
        float addedIncDmg = 0.02f;
        AttributeModifierPerk perkDmg1 = new AttributeModifierPerk("outer_s_inc_dmg", -5, -27);
        perkDmg1.addModifier(addedIncDmg, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.meleeattackdamage");
        perkDmg1.addModifier(addedIncDmg, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.projectileattackdamage");
        AttributeModifierPerk perkDmg2 = (AttributeModifierPerk)new AttributeModifierPerk("outer_s_inc_dmg_1", 3, -28).setNameOverride(perkDmg1);
        perkDmg2.addModifier(addedIncDmg, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.meleeattackdamage");
        perkDmg2.addModifier(addedIncDmg, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.projectileattackdamage");
        AttributeModifierPerk perkDmg3 = (AttributeModifierPerk)new AttributeModifierPerk("outer_s_inc_dmg_2", 11, -25).setNameOverride(perkDmg1);
        perkDmg3.addModifier(addedIncDmg, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.meleeattackdamage");
        perkDmg3.addModifier(addedIncDmg, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.projectileattackdamage");
        AttributeModifierPerk perkDmg4 = (AttributeModifierPerk)new AttributeModifierPerk("outer_s_inc_dmg_3", 19, -23).setNameOverride(perkDmg1);
        perkDmg4.addModifier(addedIncDmg, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.meleeattackdamage");
        perkDmg4.addModifier(addedIncDmg, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.projectileattackdamage");
        AttributeModifierPerk perkDmg5 = (AttributeModifierPerk)new AttributeModifierPerk("outer_s_inc_dmg_4", 23, -17).setNameOverride(perkDmg1);
        perkDmg5.addModifier(addedIncDmg, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.meleeattackdamage");
        perkDmg5.addModifier(addedIncDmg, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.projectileattackdamage");
        AttributeModifierPerk perkDmg6 = (AttributeModifierPerk)new AttributeModifierPerk("outer_s_inc_dmg_5", 25, -11).setNameOverride(perkDmg1);
        perkDmg6.addModifier(addedIncDmg, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.meleeattackdamage");
        perkDmg6.addModifier(addedIncDmg, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.projectileattackdamage");
        PerkTree.PERK_TREE.registerPerk(perkDmg1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_mine_4"));
        PerkTree.PERK_TREE.registerPerk(perkDmg2).connect(perkDmg1);
        PerkTree.PERK_TREE.registerPerk(perkDmg3).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_3")).connect(perkDmg2);
        PerkTree.PERK_TREE.registerPerk(perkDmg4).connect(perkDmg3);
        PerkTree.PERK_TREE.registerPerk(perkDmg5).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_4")).connect(perkDmg4);
        PerkTree.PERK_TREE.registerPerk(perkDmg6).connect(perkDmg5);
        AttributeModifierPerk perkPerkEffSlot1 = new AttributeModifierPerk("dsc_gem_path", 18, -19);
        perkPerkEffSlot1.addModifier(1.02f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkPerkEffSlot2 = (AttributeModifierPerk)new AttributeModifierPerk("dsc_gem_path_1", 17, -21).setNameOverride(perkPerkEffSlot1);
        perkPerkEffSlot2.addModifier(1.02f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.perkeffect");
        GemSlotMajorPerk perkDscGemSlot = new GemSlotMajorPerk("dsc_gem_slot", 15, -22);
        PerkTree.PERK_TREE.registerPerk(perkPerkEffSlot1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_dmg_3"));
        PerkTree.PERK_TREE.registerPerk(perkPerkEffSlot2).connect(perkPerkEffSlot1);
        PerkTree.PERK_TREE.registerPerk(perkDscGemSlot).connect(perkPerkEffSlot2);
        AttributeModifierPerk perkIncAts1 = new AttributeModifierPerk("inc_ats_ailm", 9, -24);
        perkIncAts1.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.attackspeed");
        AttributeModifierPerk perkIncAts2 = (AttributeModifierPerk)new AttributeModifierPerk("inc_ats_ailm_1", 8, -23).setNameOverride(perkIncAts1);
        perkIncAts2.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.attackspeed");
        KeyDamageEffect keyAilments = new KeyDamageEffect("key_ailments", 7, -24);
        PerkTree.PERK_TREE.registerPerk(perkIncAts1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_dmg_2"));
        PerkTree.PERK_TREE.registerPerk(perkIncAts2).connect(perkIncAts1);
        PerkTree.PERK_TREE.registerPerk(keyAilments).connect(perkIncAts2);
        AttributeModifierPerk perkIncMs1 = new AttributeModifierPerk("inc_cull_ms", 23, -10);
        perkIncMs1.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.movespeed");
        AttributeModifierPerk perkIncMs2 = (AttributeModifierPerk)new AttributeModifierPerk("inc_cull_ms_1", 22, -11).setNameOverride(perkIncMs1);
        perkIncMs2.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.movespeed");
        AttributeModifierPerk perkIncCrit = new AttributeModifierPerk("inc_cull_crit", 21, -10);
        perkIncCrit.addModifier(0.08f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.critchance");
        KeyCullAttack keyCull = new KeyCullAttack("key_cull_attack", 20, -11);
        PerkTree.PERK_TREE.registerPerk(perkIncMs1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_dmg_5"));
        PerkTree.PERK_TREE.registerPerk(perkIncMs2).connect(perkIncMs1);
        PerkTree.PERK_TREE.registerPerk(perkIncCrit).connect(perkIncMs2);
        PerkTree.PERK_TREE.registerPerk(keyCull).connect(perkIncCrit);
        AttributeModifierPerk perkCrJ1 = new AttributeModifierPerk("crit_inc_chance_proj", 2, -25);
        perkCrJ1.addModifier(2.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.critchance");
        perkCrJ1.addModifier(0.2f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.projectileattackdamage");
        AttributeModifierPerk perkCrJ2 = (AttributeModifierPerk)new AttributeModifierPerk("crit_inc_chance_proj_1", 1, -24).setNameOverride(perkCrJ1);
        perkCrJ2.addModifier(2.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.critchance");
        perkCrJ2.addModifier(0.2f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.projectileattackdamage");
        MajorPerk perkProjMul = new MajorPerk("major_crit_proj", 2, -23);
        perkProjMul.addModifier(0.15f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.critmulti");
        perkProjMul.addModifier(0.3f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.projectileattackdamage");
        PerkTree.PERK_TREE.registerPerk(perkCrJ1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_dmg_1"));
        PerkTree.PERK_TREE.registerPerk(perkCrJ2).connect(perkCrJ1);
        PerkTree.PERK_TREE.registerPerk(perkProjMul).connect(perkCrJ2);
        AttributeModifierPerk perkCrM1 = new AttributeModifierPerk("crit_inc_chance_melee", 25, -18);
        perkCrM1.addModifier(3.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.critchance");
        perkCrM1.addModifier(0.1f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.meleeattackdamage");
        AttributeModifierPerk perkCrM2 = (AttributeModifierPerk)new AttributeModifierPerk("crit_inc_chance_melee_1", 26, -19).setNameOverride(perkCrM1);
        perkCrM2.addModifier(3.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.critchance");
        perkCrM2.addModifier(0.1f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.meleeattackdamage");
        MajorPerk perkMeleeMul = new MajorPerk("major_crit_melee", 27, -18);
        perkMeleeMul.addModifier(0.25f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.critmulti");
        perkMeleeMul.addModifier(0.2f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.meleeattackdamage");
        PerkTree.PERK_TREE.registerPerk(perkCrM1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_dmg_4"));
        PerkTree.PERK_TREE.registerPerk(perkCrM2).connect(perkCrM1);
        PerkTree.PERK_TREE.registerPerk(perkMeleeMul).connect(perkCrM2);
    }

    private static void initializeOuterEvorsioPerks() {
        float addedIncMining = 0.02f;
        AttributeModifierPerk perkMine1 = new AttributeModifierPerk("outer_s_inc_mine", -29, -3);
        perkMine1.addModifier(addedIncMining, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.harvestspeed");
        AttributeModifierPerk perkMine2 = (AttributeModifierPerk)new AttributeModifierPerk("outer_s_inc_mine_1", -27, -9).setNameOverride(perkMine1);
        perkMine2.addModifier(addedIncMining, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.harvestspeed");
        AttributeModifierPerk perkMine3 = (AttributeModifierPerk)new AttributeModifierPerk("outer_s_inc_mine_2", -23, -15).setNameOverride(perkMine1);
        perkMine3.addModifier(addedIncMining, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.harvestspeed");
        AttributeModifierPerk perkMine4 = (AttributeModifierPerk)new AttributeModifierPerk("outer_s_inc_mine_3", -18, -19).setNameOverride(perkMine1);
        perkMine4.addModifier(addedIncMining, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.harvestspeed");
        AttributeModifierPerk perkMine5 = (AttributeModifierPerk)new AttributeModifierPerk("outer_s_inc_mine_4", -12, -24).setNameOverride(perkMine1);
        perkMine5.addModifier(addedIncMining, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.harvestspeed");
        PerkTree.PERK_TREE.registerPerk(perkMine1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_life_4"));
        PerkTree.PERK_TREE.registerPerk(perkMine2).connect(perkMine1);
        PerkTree.PERK_TREE.registerPerk(perkMine3).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_20")).connect(perkMine2);
        PerkTree.PERK_TREE.registerPerk(perkMine4).connect(perkMine3);
        PerkTree.PERK_TREE.registerPerk(perkMine5).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4")).connect(perkMine4);
        AttributeModifierPerk perkPerkEffSlot1 = new AttributeModifierPerk("ev_gem_path", -19, -16);
        perkPerkEffSlot1.addModifier(1.02f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkPerkEffSlot2 = (AttributeModifierPerk)new AttributeModifierPerk("ev_gem_path_1", -18, -15).setNameOverride(perkPerkEffSlot1);
        perkPerkEffSlot2.addModifier(1.02f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.perkeffect");
        GemSlotMajorPerk perkEvGemSlot = new GemSlotMajorPerk("ev_gem_slot", -17, -16);
        PerkTree.PERK_TREE.registerPerk(perkPerkEffSlot1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_mine_3"));
        PerkTree.PERK_TREE.registerPerk(perkPerkEffSlot2).connect(perkPerkEffSlot1);
        PerkTree.PERK_TREE.registerPerk(perkEvGemSlot).connect(perkPerkEffSlot2);
        AttributeModifierPerk perkReach1 = new AttributeModifierPerk("inc_reach_sweep", -20, -20);
        perkReach1.addModifier(0.03f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.reach");
        AttributeModifierPerk perkReach2 = (AttributeModifierPerk)new AttributeModifierPerk("inc_reach_sweep_1", -19, -21).setNameOverride(perkReach1);
        perkReach2.addModifier(0.03f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.reach");
        AttributeModifierPerk perkReach3 = (AttributeModifierPerk)new AttributeModifierPerk("inc_reach_sweep_2", -20, -22).setNameOverride(perkReach1);
        perkReach3.addModifier(0.03f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.reach");
        KeyAreaOfEffect aoeSweep = new KeyAreaOfEffect("key_sweep_range", -19, -23);
        PerkTree.PERK_TREE.registerPerk(perkReach1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_mine_3"));
        PerkTree.PERK_TREE.registerPerk(perkReach2).connect(perkReach1);
        PerkTree.PERK_TREE.registerPerk(perkReach3).connect(perkReach2);
        PerkTree.PERK_TREE.registerPerk(aoeSweep).connect(perkReach3);
        AttributeModifierPerk perkLessMine1 = new AttributeModifierPerk("less_hrv_speed", -31, -4);
        perkLessMine1.addModifier(0.8f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.harvestspeed");
        AttributeModifierPerk perkLessMine2 = (AttributeModifierPerk)new AttributeModifierPerk("less_hrv_speed_1", -32, -5).setNameOverride(perkLessMine1);
        perkLessMine2.addModifier(0.8f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.harvestspeed");
        KeyAddEnchantment addLuck = new KeyAddEnchantment("key_add_fortune", -31, -6).addEnchantment(Enchantments.field_185308_t, 1);
        PerkTree.PERK_TREE.registerPerk(perkLessMine1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_mine"));
        PerkTree.PERK_TREE.registerPerk(perkLessMine2).connect(perkLessMine1);
        PerkTree.PERK_TREE.registerPerk(addLuck).connect(perkLessMine2);
    }

    private static void initializeOuterAevitasPerks() {
        float addedIncLife = 0.02f;
        AttributeModifierPerk perkLife1 = new AttributeModifierPerk("outer_s_inc_life", -17, 22);
        perkLife1.addModifier(addedIncLife, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.maxhealth");
        AttributeModifierPerk perkLife2 = (AttributeModifierPerk)new AttributeModifierPerk("outer_s_inc_life_1", -20, 18).setNameOverride(perkLife1);
        perkLife2.addModifier(addedIncLife, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.maxhealth");
        AttributeModifierPerk perkLife3 = (AttributeModifierPerk)new AttributeModifierPerk("outer_s_inc_life_2", -25, 14).setNameOverride(perkLife1);
        perkLife3.addModifier(addedIncLife, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.maxhealth");
        AttributeModifierPerk perkLife4 = (AttributeModifierPerk)new AttributeModifierPerk("outer_s_inc_life_3", -26, 8).setNameOverride(perkLife1);
        perkLife4.addModifier(addedIncLife, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.maxhealth");
        AttributeModifierPerk perkLife5 = (AttributeModifierPerk)new AttributeModifierPerk("outer_s_inc_life_4", -28, 2).setNameOverride(perkLife1);
        perkLife5.addModifier(addedIncLife, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.maxhealth");
        PerkTree.PERK_TREE.registerPerk(perkLife1);
        PerkTree.PERK_TREE.registerPerk(perkLife2).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_16")).connect(perkLife1);
        PerkTree.PERK_TREE.registerPerk(perkLife3).connect(perkLife2);
        PerkTree.PERK_TREE.registerPerk(perkLife4).connect(perkLife3).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_17"));
        PerkTree.PERK_TREE.registerPerk(perkLife5).connect(perkLife4);
        AttributeModifierPerk perkPerkEffSlot1 = new AttributeModifierPerk("life_gem_path", -16, 15);
        perkPerkEffSlot1.addModifier(1.02f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkPerkEffSlot2 = (AttributeModifierPerk)new AttributeModifierPerk("life_gem_path_1", -17, 17).setNameOverride(perkPerkEffSlot1);
        perkPerkEffSlot2.addModifier(1.02f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.perkeffect");
        GemSlotMajorPerk perkLifeGemSlot = new GemSlotMajorPerk("life_gem_slot", -16, 19);
        PerkTree.PERK_TREE.registerPerk(perkPerkEffSlot1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_15"));
        PerkTree.PERK_TREE.registerPerk(perkPerkEffSlot2).connect(perkPerkEffSlot1);
        PerkTree.PERK_TREE.registerPerk(perkLifeGemSlot).connect(perkPerkEffSlot2);
        AttributeModifierPerk perkEffectMine1 = new AttributeModifierPerk("inc_mine_perk", -16, 25);
        perkEffectMine1.addModifier(0.06f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.harvestspeed");
        AttributeModifierPerk perkEffectMine2 = (AttributeModifierPerk)new AttributeModifierPerk("inc_mine_perk_1", -17, 26).setNameOverride(perkEffectMine1);
        perkEffectMine2.addModifier(0.06f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.harvestspeed");
        KeyVoidTrash voidTrash = new KeyVoidTrash("key_void_trash", -16, 27);
        PerkTree.PERK_TREE.registerPerk(perkEffectMine1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_life"));
        PerkTree.PERK_TREE.registerPerk(perkEffectMine2).connect(perkEffectMine1);
        PerkTree.PERK_TREE.registerPerk(voidTrash).connect(perkEffectMine2);
        AttributeModifierPerk perkIncRec1 = new AttributeModifierPerk("inc_life_rec", -28, 9);
        perkIncRec1.addModifier(0.12f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.liferecovery");
        AttributeModifierPerk perkIncRec2 = (AttributeModifierPerk)new AttributeModifierPerk("inc_life_rec_1", -29, 8).setNameOverride(perkIncRec1);
        perkIncRec2.addModifier(0.12f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.liferecovery");
        KeyCleanseBadPotions cureBadEffects = new KeyCleanseBadPotions("key_rem_badeffects", -30, 9);
        PerkTree.PERK_TREE.registerPerk(perkIncRec1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_life_3"));
        PerkTree.PERK_TREE.registerPerk(perkIncRec2).connect(perkIncRec1);
        PerkTree.PERK_TREE.registerPerk(cureBadEffects).connect(perkIncRec2);
    }

    private static void initializePerkEffectPerks() {
        float addedIncPerkEffect = 0.15f;
        float addedIncPerkExp = 0.2f;
        MajorPerk majorPerkEffect1 = new MajorPerk("major_perk_eff_nt", 9, 9);
        majorPerkEffect1.addModifier(addedIncPerkEffect, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        MajorPerk majorPerkEffect2 = (MajorPerk)new MajorPerk("major_perk_eff_nt_1", 10, -4).setNameOverride(majorPerkEffect1);
        majorPerkEffect2.addModifier(addedIncPerkEffect, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        MajorPerk majorPerkEffect3 = (MajorPerk)new MajorPerk("major_perk_eff_nt_2", -3, -11).setNameOverride(majorPerkEffect1);
        majorPerkEffect3.addModifier(addedIncPerkEffect, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        MajorPerk majorPerkEffect4 = (MajorPerk)new MajorPerk("major_perk_eff_nt_3", -11, 0).setNameOverride(majorPerkEffect1);
        majorPerkEffect4.addModifier(addedIncPerkEffect, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        MajorPerk majorPerkEffect5 = (MajorPerk)new MajorPerk("major_perk_eff_nt_4", -5, 11).setNameOverride(majorPerkEffect1);
        majorPerkEffect5.addModifier(addedIncPerkEffect, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        PerkTree.PERK_TREE.registerPerk(majorPerkEffect1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_7"));
        PerkTree.PERK_TREE.registerPerk(majorPerkEffect2).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_4"));
        PerkTree.PERK_TREE.registerPerk(majorPerkEffect3).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_1"));
        PerkTree.PERK_TREE.registerPerk(majorPerkEffect4).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_13"));
        PerkTree.PERK_TREE.registerPerk(majorPerkEffect5).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_10"));
        MajorPerk majorPerkExp1 = new MajorPerk("major_perk_exp_nt", 5, 11);
        majorPerkExp1.addModifier(addedIncPerkExp, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.expgain");
        MajorPerk majorPerkExp2 = (MajorPerk)new MajorPerk("major_perk_exp_nt_1", 12, 0).setNameOverride(majorPerkExp1);
        majorPerkExp2.addModifier(addedIncPerkExp, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.expgain");
        MajorPerk majorPerkExp3 = (MajorPerk)new MajorPerk("major_perk_exp_nt_2", 2, -11).setNameOverride(majorPerkExp1);
        majorPerkExp3.addModifier(addedIncPerkExp, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.expgain");
        MajorPerk majorPerkExp4 = (MajorPerk)new MajorPerk("major_perk_exp_nt_3", -10, -5).setNameOverride(majorPerkExp1);
        majorPerkExp4.addModifier(addedIncPerkExp, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.expgain");
        MajorPerk majorPerkExp5 = (MajorPerk)new MajorPerk("major_perk_exp_nt_4", -9, 9).setNameOverride(majorPerkExp1);
        majorPerkExp5.addModifier(addedIncPerkExp, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.expgain");
        PerkTree.PERK_TREE.registerPerk(majorPerkExp1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_7"));
        PerkTree.PERK_TREE.registerPerk(majorPerkExp2).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_4"));
        PerkTree.PERK_TREE.registerPerk(majorPerkExp3).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_1"));
        PerkTree.PERK_TREE.registerPerk(majorPerkExp4).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_13"));
        PerkTree.PERK_TREE.registerPerk(majorPerkExp5).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_10"));
        MajorPerk perkEE1 = new MajorPerk("major_inc_encheffect", -2, -3);
        perkEE1.addModifier(0.15f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.dynenchantmenteffect");
        MajorPerk perkEE2 = (MajorPerk)new MajorPerk("major_inc_encheffect_1", -3, 1).setNameOverride(perkEE1);
        perkEE2.addModifier(0.15f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.dynenchantmenteffect");
        PerkTree.PERK_TREE.registerPerk(perkEE1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t2_14")).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t2_2"));
        PerkTree.PERK_TREE.registerPerk(perkEE2).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t2_11")).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t2_14"));
    }

    private static void initializeVicioKeyPerks() {
        AttributeModifierPerk perkSwimSpeed1 = new AttributeModifierPerk("key_path_swim_conversion", -2, 23);
        perkSwimSpeed1.addModifier(0.1f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.swimspeed");
        AttributeModifierPerk perkSwimSpeed2 = (AttributeModifierPerk)new AttributeModifierPerk("key_path_swim_conversion_1", -3, 24).setNameOverride(perkSwimSpeed1);
        perkSwimSpeed2.addModifier(0.1f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.swimspeed");
        AttributeModifierPerk perkSwimSpeed3 = (AttributeModifierPerk)new AttributeModifierPerk("key_path_swim_conversion_2", -2, 25).setNameOverride(perkSwimSpeed1);
        perkSwimSpeed3.addModifier(0.1f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.swimspeed");
        KeyPerk swimSpeedConversion = new KeyPerk("key_swim_conversion", -3, 26);
        swimSpeedConversion.addConverter(new PerkConverter(){

            @Override
            @Nonnull
            public PerkAttributeModifier convertModifier(EntityPlayer player, PlayerProgress progress, PerkAttributeModifier modifier, @Nullable AbstractPerk owningPerk) {
                return modifier;
            }

            @Override
            @Nonnull
            public Collection<PerkAttributeModifier> gainExtraModifiers(EntityPlayer player, PlayerProgress progress, PerkAttributeModifier modifier, @Nullable AbstractPerk owningPerk) {
                ArrayList modifiers = Lists.newArrayList();
                if (modifier.getAttributeType().equals("astralsorcery.movespeed")) {
                    switch (modifier.getMode()) {
                        case ADDITION: 
                        case ADDED_MULTIPLY: {
                            PerkAttributeModifier mod = modifier.gainAsExtraModifier(this, "astralsorcery.swimspeed", modifier.getMode(), modifier.getValue(player, progress) / 2.0f);
                            if (mod == null) break;
                            modifiers.add(mod);
                            break;
                        }
                        case STACKING_MULTIPLY: {
                            float val = modifier.getValue(player, progress) - 1.0f;
                            PerkAttributeModifier mod = modifier.gainAsExtraModifier(this, "astralsorcery.swimspeed", modifier.getMode(), (val /= 2.0f) + 1.0f);
                            if (mod == null) break;
                            modifiers.add(mod);
                            break;
                        }
                    }
                }
                return modifiers;
            }
        });
        PerkTree.PERK_TREE.registerPerk(perkSwimSpeed1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("med_add_ats_dodge"));
        PerkTree.PERK_TREE.registerPerk(perkSwimSpeed2).connect(perkSwimSpeed1);
        PerkTree.PERK_TREE.registerPerk(perkSwimSpeed3).connect(perkSwimSpeed2);
        PerkTree.PERK_TREE.registerPerk(swimSpeedConversion).connect(perkSwimSpeed3);
        AttributeModifierPerk incAttackSpeed1 = new AttributeModifierPerk("major_ats_inc_ats", 9, 14);
        incAttackSpeed1.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.attackspeed");
        AttributeModifierPerk incAttackSpeed2 = (AttributeModifierPerk)new AttributeModifierPerk("major_ats_inc_ats_1", 8, 15).setNameOverride(incAttackSpeed1);
        incAttackSpeed2.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.attackspeed");
        MajorPerk perkZeal = new MajorPerk("major_increased_ats_zeal", 7, 14);
        perkZeal.addModifier(0.15f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.attackspeed");
        PerkTree.PERK_TREE.registerPerk(incAttackSpeed1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_7"));
        PerkTree.PERK_TREE.registerPerk(incAttackSpeed2).connect(incAttackSpeed1);
        PerkTree.PERK_TREE.registerPerk(perkZeal).connect(incAttackSpeed2);
        AttributeModifierPerk incReachStepAssist = new AttributeModifierPerk("key_stepassist_path_reach", -7, 15);
        incReachStepAssist.addModifier(0.1f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.reach");
        AttributeModifierPerk incMovespeedStepAssist1 = new AttributeModifierPerk("key_stepassist_path_movespeed", -6, 18);
        incMovespeedStepAssist1.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.movespeed");
        AttributeModifierPerk incMovespeedStepAssist2 = (AttributeModifierPerk)new AttributeModifierPerk("key_stepassist_path_movespeed_1", -7, 17).setNameOverride(incMovespeedStepAssist1);
        incMovespeedStepAssist2.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.movespeed");
        KeyStepAssist stepAssistKey = new KeyStepAssist("key_step_assist", -6, 16);
        PerkTree.PERK_TREE.registerPerk(incReachStepAssist).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_10"));
        PerkTree.PERK_TREE.registerPerk(stepAssistKey).connect(incReachStepAssist);
        PerkTree.PERK_TREE.registerPerk(incMovespeedStepAssist2).connect(stepAssistKey);
        PerkTree.PERK_TREE.registerPerk(incMovespeedStepAssist1).connect(incMovespeedStepAssist2).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_13"));
        AttributeModifierPerk lightsMs1 = new AttributeModifierPerk("key_lights_path_ms", 6, 17);
        lightsMs1.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.movespeed");
        AttributeModifierPerk lightsMs2 = (AttributeModifierPerk)new AttributeModifierPerk("key_lights_path_ms_1", 7, 16).setNameOverride(lightsMs1);
        lightsMs2.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.movespeed");
        KeySpawnLights spawnLightsKey = new KeySpawnLights("key_spawn_lights", 6, 15);
        PerkTree.PERK_TREE.registerPerk(lightsMs1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_12"));
        PerkTree.PERK_TREE.registerPerk(lightsMs2).connect(lightsMs1);
        PerkTree.PERK_TREE.registerPerk(spawnLightsKey).connect(lightsMs2);
        AttributeModifierPerk redFoodPathDodge1 = new AttributeModifierPerk("key_redfood_path_dodge", 3, 22);
        redFoodPathDodge1.addModifier(0.1f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.dodge");
        AttributeModifierPerk redFoodPathDodge2 = (AttributeModifierPerk)new AttributeModifierPerk("key_redfood_path_dodge_1", 2, 23).setNameOverride(redFoodPathDodge1);
        redFoodPathDodge2.addModifier(0.1f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.dodge");
        AttributeModifierPerk redFoodPathDodge3 = (AttributeModifierPerk)new AttributeModifierPerk("key_redfood_path_dodge_2", 3, 24).setNameOverride(redFoodPathDodge1);
        redFoodPathDodge3.addModifier(0.1f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.dodge");
        KeyReducedFood reducedFoodKey = new KeyReducedFood("key_reduced_food", 4, 23);
        PerkTree.PERK_TREE.registerPerk(redFoodPathDodge1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_12"));
        PerkTree.PERK_TREE.registerPerk(redFoodPathDodge2).connect(redFoodPathDodge1);
        PerkTree.PERK_TREE.registerPerk(redFoodPathDodge3).connect(redFoodPathDodge2);
        PerkTree.PERK_TREE.registerPerk(reducedFoodKey).connect(redFoodPathDodge3);
    }

    private static void initializeArmaraKeyPerks() {
        AttributeModifierPerk perkALC1 = new AttributeModifierPerk("key_alc_inc_armor", 15, -4);
        perkALC1.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.armor");
        AttributeModifierPerk perkALC2 = (AttributeModifierPerk)new AttributeModifierPerk("key_alc_inc_armor_1", 16, -3).setNameOverride(perkALC1);
        perkALC2.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.armor");
        KeyPerk keyArmorConversion = new KeyPerk("key_armor_life_conversion", 17, -4);
        keyArmorConversion.addConverter(new PerkConverter(){

            @Override
            @Nonnull
            public PerkAttributeModifier convertModifier(EntityPlayer player, PlayerProgress progress, PerkAttributeModifier modifier, @Nullable AbstractPerk owningPerk) {
                if (modifier.getAttributeType().equals("astralsorcery.armor")) {
                    return modifier.convertModifier("astralsorcery.maxhealth", modifier.getMode(), modifier.getValue(player, progress));
                }
                return modifier;
            }

            @Override
            @Nonnull
            public Collection<PerkAttributeModifier> gainExtraModifiers(EntityPlayer player, PlayerProgress progress, PerkAttributeModifier modifier, @Nullable AbstractPerk owningPerk) {
                ArrayList modifiers = Lists.newArrayList();
                if (modifier.getAttributeType().equals("astralsorcery.armor")) {
                    PerkAttributeModifier mod = modifier.gainAsExtraModifier(this, "astralsorcery.armor", PerkAttributeModifier.Mode.STACKING_MULTIPLY, 0.0f);
                    if (mod != null) {
                        modifiers.add(mod);
                    }
                    if ((mod = modifier.gainAsExtraModifier(this, "astralsorcery.armortoughness", PerkAttributeModifier.Mode.STACKING_MULTIPLY, 0.0f)) != null) {
                        modifiers.add(mod);
                    }
                }
                return modifiers;
            }
        });
        PerkTree.PERK_TREE.registerPerk(perkALC1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_4"));
        PerkTree.PERK_TREE.registerPerk(perkALC2).connect(perkALC1);
        PerkTree.PERK_TREE.registerPerk(keyArmorConversion).connect(perkALC2);
        AttributeModifierPerk perkTh1 = new AttributeModifierPerk("thorns_inc_dmg", 16, 1);
        perkTh1.addModifier(5.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.thorns");
        AttributeModifierPerk perkTh2 = new AttributeModifierPerk("thorns_inc_dmg_gr", 17, 0);
        perkTh2.addModifier(10.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.thorns");
        MajorPerk perkRangedThorns = new MajorPerk("thorns_ranged", 16, -1);
        perkRangedThorns.addModifier(1.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.rangedthorns");
        perkRangedThorns.addModifier(10.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.thorns");
        PerkTree.PERK_TREE.registerPerk(perkTh1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_5"));
        PerkTree.PERK_TREE.registerPerk(perkTh2).connect(perkTh1);
        PerkTree.PERK_TREE.registerPerk(perkRangedThorns).connect(perkTh2);
        AttributeModifierPerk perkPhEle1 = new AttributeModifierPerk("key_phoenix_path", 16, 16);
        perkPhEle1.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.allres");
        AttributeModifierPerk perkPhEle2 = (AttributeModifierPerk)new AttributeModifierPerk("key_phoenix_path_1", 17, 15).setNameOverride(perkPhEle1);
        perkPhEle2.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.allres");
        AttributeModifierPerk perkPhEle3 = (AttributeModifierPerk)new AttributeModifierPerk("key_phoenix_path_2", 18, 16).setNameOverride(perkPhEle1);
        perkPhEle3.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.allres");
        KeyCheatDeath cheatDeathKey = new KeyCheatDeath("key_cheat_death", 17, 17);
        PerkTree.PERK_TREE.registerPerk(perkPhEle1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_10"));
        PerkTree.PERK_TREE.registerPerk(perkPhEle2).connect(perkPhEle1);
        PerkTree.PERK_TREE.registerPerk(perkPhEle3).connect(perkPhEle2);
        PerkTree.PERK_TREE.registerPerk(cheatDeathKey).connect(perkPhEle3);
        AttributeModifierPerk perkArmor1 = new AttributeModifierPerk("inc_added_armor", 21, 5);
        perkArmor1.addModifier(1.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.armor");
        AttributeModifierPerk perkArmor2 = (AttributeModifierPerk)new AttributeModifierPerk("inc_added_armor_1", 22, 4).setNameOverride(perkArmor1);
        perkArmor2.addModifier(1.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.armor");
        AttributeModifierPerk perkArmor3 = (AttributeModifierPerk)new AttributeModifierPerk("inc_added_armor_2", 23, 5).setNameOverride(perkArmor1);
        perkArmor3.addModifier(1.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.armor");
        MajorPerk perkArmor4 = new MajorPerk("major_flat_armor", 22, 6);
        perkArmor4.addModifier(6.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.armor");
        perkArmor4.addModifier(2.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.armortoughness");
        PerkTree.PERK_TREE.registerPerk(perkArmor1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_7"));
        PerkTree.PERK_TREE.registerPerk(perkArmor2).connect(perkArmor1);
        PerkTree.PERK_TREE.registerPerk(perkArmor3).connect(perkArmor2);
        PerkTree.PERK_TREE.registerPerk(perkArmor4).connect(perkArmor3);
        AttributeModifierPerk perkNoArmorP1 = new AttributeModifierPerk("key_no_armor_armor", 12, 15);
        perkNoArmorP1.addModifier(0.1f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.armor");
        AttributeModifierPerk perkNoArmorP2 = new AttributeModifierPerk("key_no_armor_resist", 11, 14);
        perkNoArmorP2.addModifier(0.1f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.allres");
        KeyNoArmor noArmorKey = new KeyNoArmor("key_no_armor", 12, 13);
        PerkTree.PERK_TREE.registerPerk(perkNoArmorP1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_9"));
        PerkTree.PERK_TREE.registerPerk(perkNoArmorP2).connect(perkNoArmorP1);
        PerkTree.PERK_TREE.registerPerk(noArmorKey).connect(perkNoArmorP2);
    }

    private static void initializeDiscidiaKeyPerks() {
        KeyBleed bleedKey = new KeyBleed("key_bleed", 15, -6);
        AttributeModifierPerk perkBl1 = new AttributeModifierPerk("key_bleed_inc_duration", 16, -7);
        perkBl1.addModifier(0.3f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.bleedduration");
        AttributeModifierPerk perkBl2 = new AttributeModifierPerk("key_bleed_inc_duration_greater", 15, -8);
        perkBl2.addModifier(0.4f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.bleedduration");
        PerkTree.PERK_TREE.registerPerk(bleedKey).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_3"));
        PerkTree.PERK_TREE.registerPerk(perkBl1).connect(bleedKey);
        PerkTree.PERK_TREE.registerPerk(perkBl2).connect(perkBl1);
        AttributeModifierPerk perkDst1 = new AttributeModifierPerk("key_dst_less_dmg", 17, -15);
        perkDst1.addModifier(0.9f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.projectileattackdamage");
        AttributeModifierPerk perkDst2 = (AttributeModifierPerk)new AttributeModifierPerk("key_dst_less_dmg_2", 18, -16).setNameOverride(perkDst1);
        perkDst2.addModifier(0.9f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.projectileattackdamage");
        KeyProjectileProximity projectileProximityKey = new KeyProjectileProximity("key_projectile_proximity", 17, -17);
        PerkTree.PERK_TREE.registerPerk(perkDst1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("med_reach_arrowspeed"));
        PerkTree.PERK_TREE.registerPerk(perkDst2).connect(perkDst1);
        PerkTree.PERK_TREE.registerPerk(projectileProximityKey).connect(perkDst2);
        AttributeModifierPerk perkDst3 = (AttributeModifierPerk)new AttributeModifierPerk("key_dst_less_dmg_3", 13, -19).setNameOverride(perkDst1);
        perkDst3.addModifier(0.9f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.projectileattackdamage");
        AttributeModifierPerk perkDst4 = (AttributeModifierPerk)new AttributeModifierPerk("key_dst_less_dmg_4", 14, -20).setNameOverride(perkDst1);
        perkDst4.addModifier(0.9f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.projectileattackdamage");
        KeyProjectileDistance projectileDistanceKey = new KeyProjectileDistance("key_projectile_distance", 15, -19);
        PerkTree.PERK_TREE.registerPerk(perkDst3).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("med_reach_arrowspeed"));
        PerkTree.PERK_TREE.registerPerk(perkDst4).connect(perkDst3);
        PerkTree.PERK_TREE.registerPerk(projectileDistanceKey).connect(perkDst4);
        AttributeModifierPerk perkRPCrit = new AttributeModifierPerk("key_rampage_path_node_crit", 4, -18);
        perkRPCrit.addModifier(3.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.critchance");
        AttributeModifierPerk perkRPDmg = new AttributeModifierPerk("key_rampage_path_node_dmg", 3, -15);
        perkRPDmg.addModifier(0.08f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.meleeattackdamage");
        perkRPDmg.addModifier(0.08f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.projectileattackdamage");
        AttributeModifierPerk perkRPDmg2 = (AttributeModifierPerk)new AttributeModifierPerk("key_rampage_path_node_dmg_1", 4, -16).setNameOverride(perkRPDmg);
        perkRPDmg2.addModifier(0.08f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.meleeattackdamage");
        perkRPDmg2.addModifier(0.08f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.projectileattackdamage");
        KeyRampage rampageKey = new KeyRampage("key_rampage", 3, -17);
        PerkTree.PERK_TREE.registerPerk(perkRPCrit).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_2"));
        PerkTree.PERK_TREE.registerPerk(rampageKey).connect(perkRPCrit);
        PerkTree.PERK_TREE.registerPerk(perkRPDmg2).connect(rampageKey);
        PerkTree.PERK_TREE.registerPerk(perkRPDmg).connect(perkRPDmg2).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_1"));
        AttributeModifierPerk perkLL1 = new AttributeModifierPerk("inc_leech_vamp", -1, -15);
        perkLL1.addModifier(3.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.lifeleech");
        AttributeModifierPerk perkLL2 = (AttributeModifierPerk)new AttributeModifierPerk("inc_leech_vamp_1", -2, -16).setNameOverride(perkLL1);
        perkLL2.addModifier(3.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.lifeleech");
        MajorPerk perkVampirism = new MajorPerk("major_leech_vamp", -1, -17);
        perkVampirism.addModifier(5.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.lifeleech");
        perkVampirism.addModifier(2.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.maxhealth");
        PerkTree.PERK_TREE.registerPerk(perkLL1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_1"));
        PerkTree.PERK_TREE.registerPerk(perkLL2).connect(perkLL1);
        PerkTree.PERK_TREE.registerPerk(perkVampirism).connect(perkLL2);
        AttributeModifierPerk perkFD1 = new AttributeModifierPerk("ds_inc_potion_duration", 21, -6);
        perkFD1.addModifier(0.15f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.potionduration");
        AttributeModifierPerk perkFD2 = (AttributeModifierPerk)new AttributeModifierPerk("ds_inc_potion_duration_1", 22, -5).setNameOverride(perkFD1);
        perkFD2.addModifier(0.15f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.potionduration");
        MajorPerk perkFD3 = new MajorPerk("major_ds_inc_potion_duration", 23, -6);
        perkFD3.addModifier(0.3f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.potionduration");
        perkFD3.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.movespeed");
        PerkTree.PERK_TREE.registerPerk(perkFD1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_5"));
        PerkTree.PERK_TREE.registerPerk(perkFD2).connect(perkFD1);
        PerkTree.PERK_TREE.registerPerk(perkFD3).connect(perkFD2);
    }

    private static void initializeEvorsioKeyPerks() {
        AttributeModifierPerk perkLL1 = new AttributeModifierPerk("key_lastbreath_path_node", -7, -17);
        perkLL1.addModifier(0.08f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.harvestspeed");
        AttributeModifierPerk perkLL2 = (AttributeModifierPerk)new AttributeModifierPerk("key_lastbreath_path_node_1", -6, -16).setNameOverride(perkLL1);
        perkLL2.addModifier(0.08f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.harvestspeed");
        KeyLastBreath lastBreathKey = new KeyLastBreath("key_lastbreath", -5, -17);
        PerkTree.PERK_TREE.registerPerk(perkLL1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4"));
        PerkTree.PERK_TREE.registerPerk(perkLL2).connect(perkLL1);
        PerkTree.PERK_TREE.registerPerk(lastBreathKey).connect(perkLL2);
        AttributeModifierPerk perkDTM1 = new AttributeModifierPerk("key_digtypes_path_node_inc", -15, -8);
        perkDTM1.addModifier(0.06f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.harvestspeed");
        AttributeModifierPerk perkDTM2 = (AttributeModifierPerk)new AttributeModifierPerk("key_digtypes_path_node_inc_1", -14, -7).setNameOverride(perkDTM1);
        perkDTM2.addModifier(0.06f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.harvestspeed");
        AttributeModifierPerk perkDTM3 = new AttributeModifierPerk("key_digtypes_path_add", -14, -5);
        perkDTM3.addModifier(1.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.harvestspeed");
        KeyDigTypes digTypesKey = new KeyDigTypes("key_digtypes", -15, -6);
        PerkTree.PERK_TREE.registerPerk(perkDTM3).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_13"));
        PerkTree.PERK_TREE.registerPerk(digTypesKey).connect(perkDTM3);
        PerkTree.PERK_TREE.registerPerk(perkDTM2).connect(digTypesKey);
        PerkTree.PERK_TREE.registerPerk(perkDTM1).connect(perkDTM2).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_20"));
        AttributeModifierPerk perkAD1 = new AttributeModifierPerk("key_disarm_path_node", -16, -2);
        perkAD1.addModifier(1.05f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.meleeattackdamage");
        AttributeModifierPerk perkAD2 = (AttributeModifierPerk)new AttributeModifierPerk("key_disarm_path_node_1", -17, -1).setNameOverride(perkAD1);
        perkAD2.addModifier(1.05f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.meleeattackdamage");
        AttributeModifierPerk perkAD3 = (AttributeModifierPerk)new AttributeModifierPerk("key_disarm_path_node_2", -18, -2).setNameOverride(perkAD1);
        perkAD3.addModifier(1.05f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.meleeattackdamage");
        KeyDisarm disarmKey = new KeyDisarm("key_disarm", -17, -3);
        PerkTree.PERK_TREE.registerPerk(perkAD1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_13"));
        PerkTree.PERK_TREE.registerPerk(perkAD2).connect(perkAD1);
        PerkTree.PERK_TREE.registerPerk(perkAD3).connect(perkAD2).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_18"));
        PerkTree.PERK_TREE.registerPerk(disarmKey).connect(perkAD3);
        AttributeModifierPerk perkACH1 = new AttributeModifierPerk("key_arc_chains", -5, -24);
        perkACH1.addModifier(1.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.archops");
        MajorPerk perkACH2 = new MajorPerk("key_arc_chains_major", -6, -23);
        perkACH2.addModifier(2.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.archops");
        AttributeModifierPerk perkACH3 = (AttributeModifierPerk)new AttributeModifierPerk("key_arc_chains_1", -5, -22).setNameOverride(perkACH1);
        perkACH3.addModifier(1.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.archops");
        KeyLightningArc arcKey = new KeyLightningArc("key_lightning_arc", -2, -23);
        PerkTree.PERK_TREE.registerPerk(arcKey).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_1"));
        PerkTree.PERK_TREE.registerPerk(perkACH1).connect(arcKey);
        PerkTree.PERK_TREE.registerPerk(perkACH2).connect(perkACH1);
        PerkTree.PERK_TREE.registerPerk(perkACH3).connect(perkACH2);
        AttributeModifierPerk perkChainL1 = new AttributeModifierPerk("key_chain_mining_length", -21, -9);
        perkChainL1.addModifier(1.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.chainlength");
        AttributeModifierPerk perkChainL2 = (AttributeModifierPerk)new AttributeModifierPerk("key_chain_mining_length_1", -22, -10).setNameOverride(perkChainL1);
        perkChainL2.addModifier(1.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.chainlength");
        MajorPerk perkChainL3 = new MajorPerk("key_chain_mining_length_greater", -23, -12);
        perkChainL3.addModifier(3.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.chainlength");
        AttributeModifierPerk perkChanceL1 = new AttributeModifierPerk("key_chain_mining_chance", -22, -6);
        perkChanceL1.addModifier(0.15f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.chainchance");
        AttributeModifierPerk perkChanceL2 = (AttributeModifierPerk)new AttributeModifierPerk("key_chain_mining_chance_1", -23, -5).setNameOverride(perkChanceL1);
        perkChanceL2.addModifier(0.15f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.chainchance");
        MajorPerk perkChanceL3 = new MajorPerk("key_chain_mining_chance_greater", -24, -3);
        perkChanceL3.addModifier(1.0f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.chainchance");
        MajorPerk perkDoubleL1 = new MajorPerk("key_chain_mining_double", -24, -8);
        perkDoubleL1.addModifier(0.5f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.chainchancing");
        KeyChainMining chainMiningKey = new KeyChainMining("key_chain_mining", -20, -7);
        PerkTree.PERK_TREE.registerPerk(chainMiningKey).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_19"));
        PerkTree.PERK_TREE.registerPerk(perkChanceL1).connect(chainMiningKey);
        PerkTree.PERK_TREE.registerPerk(perkChanceL2).connect(perkChanceL1);
        PerkTree.PERK_TREE.registerPerk(perkChanceL3).connect(perkChanceL2);
        PerkTree.PERK_TREE.registerPerk(perkChainL1).connect(chainMiningKey);
        PerkTree.PERK_TREE.registerPerk(perkChainL2).connect(perkChainL1);
        PerkTree.PERK_TREE.registerPerk(perkChainL3).connect(perkChainL2);
        PerkTree.PERK_TREE.registerPerk(perkDoubleL1).connect(perkChainL2).connect(perkChanceL2);
        AttributeModifierPerk perkFD1 = new AttributeModifierPerk("ev_inc_potion_duration", -15, -16);
        perkFD1.addModifier(0.1f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.potionduration");
        AttributeModifierPerk perkFD2 = (AttributeModifierPerk)new AttributeModifierPerk("ev_inc_potion_duration_1", -14, -17).setNameOverride(perkFD1);
        perkFD2.addModifier(0.1f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.potionduration");
        MajorPerk perkFD3 = new MajorPerk("major_ev_inc_potion_duration", -15, -18);
        perkFD3.addModifier(0.4f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.potionduration");
        perkFD3.addModifier(0.75f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.maxhealth");
        PerkTree.PERK_TREE.registerPerk(perkFD1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("med_added_hrv_speed"));
        PerkTree.PERK_TREE.registerPerk(perkFD2).connect(perkFD1);
        PerkTree.PERK_TREE.registerPerk(perkFD3).connect(perkFD2);
    }

    private static void initializeAevitasKeyPerks() {
        AttributeModifierPerk perkReachP1 = new AttributeModifierPerk("key_reach_path_node", -12, 11);
        perkReachP1.addModifier(0.08f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.reach");
        AttributeModifierPerk perkReachP2 = (AttributeModifierPerk)new AttributeModifierPerk("key_reach_path_node_1", -11, 12).setNameOverride(perkReachP1);
        perkReachP2.addModifier(0.08f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.reach");
        KeyReach reachKey = new KeyReach("key_reach", -12, 13);
        reachKey.addModifier(1.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.reach");
        reachKey.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.harvestspeed");
        PerkTree.PERK_TREE.registerPerk(perkReachP1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_16"));
        PerkTree.PERK_TREE.registerPerk(perkReachP2).connect(perkReachP1);
        PerkTree.PERK_TREE.registerPerk(reachKey).connect(perkReachP2);
        AttributeModifierPerk perkSEP1 = new AttributeModifierPerk("key_enrich_path_node", -18, 13);
        perkSEP1.addModifier(0.04f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.harvestspeed");
        AttributeModifierPerk perkSEP2 = (AttributeModifierPerk)new AttributeModifierPerk("key_enrich_path_node_1", -19, 12).setNameOverride(perkSEP1);
        perkSEP2.addModifier(0.04f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.harvestspeed");
        AttributeModifierPerk perkSEP3 = (AttributeModifierPerk)new AttributeModifierPerk("key_enrich_path_node_2", -20, 13).setNameOverride(perkSEP1);
        perkSEP3.addModifier(0.04f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.harvestspeed");
        KeyStoneEnrichment stoneEnrichmentKey = new KeyStoneEnrichment("key_stone_enrichment", -19, 14);
        PerkTree.PERK_TREE.registerPerk(perkSEP1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_16"));
        PerkTree.PERK_TREE.registerPerk(perkSEP2).connect(perkSEP1);
        PerkTree.PERK_TREE.registerPerk(perkSEP3).connect(perkSEP2);
        PerkTree.PERK_TREE.registerPerk(stoneEnrichmentKey).connect(perkSEP3);
        AttributeModifierPerk perkMD1 = new AttributeModifierPerk("key_mending_path_node", -21, 3);
        perkMD1.addModifier(2.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.dodge");
        AttributeModifierPerk perkMD2 = new AttributeModifierPerk("key_mending_path_node_1", -22, 4);
        perkMD2.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.dodge");
        AttributeModifierPerk perkMD3 = (AttributeModifierPerk)new AttributeModifierPerk("key_mending_path_node_2", -23, 3).setNameOverride(perkMD2);
        perkMD3.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.dodge");
        KeyMending mendingKey = new KeyMending("key_mending", -22, 2);
        PerkTree.PERK_TREE.registerPerk(perkMD1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_17"));
        PerkTree.PERK_TREE.registerPerk(perkMD2).connect(perkMD1);
        PerkTree.PERK_TREE.registerPerk(perkMD3).connect(perkMD2);
        PerkTree.PERK_TREE.registerPerk(mendingKey).connect(perkMD3);
        AttributeModifierPerk perkGP1 = new AttributeModifierPerk("key_growables_path_node", -9, 15);
        perkGP1.addModifier(0.15f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.liferecovery");
        AttributeModifierPerk perkGP2 = (AttributeModifierPerk)new AttributeModifierPerk("key_growables_path_node_1", -10, 14).setNameOverride(perkGP1);
        perkGP2.addModifier(0.15f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.liferecovery");
        AttributeModifierPerk perkGP3 = (AttributeModifierPerk)new AttributeModifierPerk("key_growables_path_node_2", -11, 15).setNameOverride(perkGP1);
        perkGP3.addModifier(0.15f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.liferecovery");
        KeyGrowable growableKey = new KeyGrowable("key_growables", -10, 16);
        PerkTree.PERK_TREE.registerPerk(perkGP1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_10"));
        PerkTree.PERK_TREE.registerPerk(perkGP2).connect(perkGP1);
        PerkTree.PERK_TREE.registerPerk(perkGP3).connect(perkGP2).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t4_15"));
        PerkTree.PERK_TREE.registerPerk(growableKey).connect(perkGP3);
    }

    private static void initializeTreeConnectorPerks() {
        float more_ch = 0.15f;
        AttributeModifierPerk perkEvorsioCh1 = new AttributeModifierPerk("threshold_evorsio", -13, -27);
        perkEvorsioCh1.addModifier(more_ch, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.expgain");
        AttributeModifierPerk perkEvorsioCh2 = (AttributeModifierPerk)new AttributeModifierPerk("threshold_evorsio_1", -15, -30).setNameOverride(perkEvorsioCh1);
        perkEvorsioCh2.addModifier(more_ch, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.expgain");
        AttributeModifierPerk perkEvorsioCh3 = (AttributeModifierPerk)new AttributeModifierPerk("threshold_evorsio_2", -11, -30).setNameOverride(perkEvorsioCh1);
        perkEvorsioCh3.addModifier(more_ch, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.expgain");
        PerkTreeConnector thresholdEvorsio = new PerkTreeConnector("epi_evorsio", -13, -29);
        PerkTree.PERK_TREE.registerPerk(perkEvorsioCh1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_mine_4"));
        PerkTree.PERK_TREE.registerPerk(perkEvorsioCh2).connect(perkEvorsioCh1);
        PerkTree.PERK_TREE.registerPerk(perkEvorsioCh3).connect(perkEvorsioCh2).connect(perkEvorsioCh1);
        PerkTree.PERK_TREE.registerPerk(thresholdEvorsio).connect(perkEvorsioCh1).connect(perkEvorsioCh2).connect(perkEvorsioCh3);
        AttributeModifierPerk perkArmaraCh1 = new AttributeModifierPerk("threshold_armara", 29, -4);
        perkArmaraCh1.addModifier(more_ch, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.expgain");
        AttributeModifierPerk perkArmaraCh2 = (AttributeModifierPerk)new AttributeModifierPerk("threshold_armara_1", 32, -2).setNameOverride(perkArmaraCh1);
        perkArmaraCh2.addModifier(more_ch, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.expgain");
        AttributeModifierPerk perkArmaraCh3 = (AttributeModifierPerk)new AttributeModifierPerk("threshold_armara_2", 32, -6).setNameOverride(perkArmaraCh1);
        perkArmaraCh3.addModifier(more_ch, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.expgain");
        PerkTreeConnector thresholdArmara = new PerkTreeConnector("epi_armara", 31, -4);
        PerkTree.PERK_TREE.registerPerk(perkArmaraCh1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_def"));
        PerkTree.PERK_TREE.registerPerk(perkArmaraCh2).connect(perkArmaraCh1);
        PerkTree.PERK_TREE.registerPerk(perkArmaraCh3).connect(perkArmaraCh2).connect(perkArmaraCh1);
        PerkTree.PERK_TREE.registerPerk(thresholdArmara).connect(perkArmaraCh1).connect(perkArmaraCh2).connect(perkArmaraCh3);
        AttributeModifierPerk perkVicioCh1 = new AttributeModifierPerk("threshold_vicio", -6, 30);
        perkVicioCh1.addModifier(more_ch, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.expgain");
        AttributeModifierPerk perkVicioCh2 = (AttributeModifierPerk)new AttributeModifierPerk("threshold_vicio_1", -4, 33).setNameOverride(perkVicioCh1);
        perkVicioCh2.addModifier(more_ch, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.expgain");
        AttributeModifierPerk perkVicioCh3 = (AttributeModifierPerk)new AttributeModifierPerk("threshold_vicio_2", -8, 33).setNameOverride(perkVicioCh1);
        perkVicioCh3.addModifier(more_ch, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.expgain");
        PerkTreeConnector thresholdVicio = new PerkTreeConnector("epi_vicio", -6, 32);
        PerkTree.PERK_TREE.registerPerk(perkVicioCh1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("outer_s_inc_trv_3"));
        PerkTree.PERK_TREE.registerPerk(perkVicioCh2).connect(perkVicioCh1);
        PerkTree.PERK_TREE.registerPerk(perkVicioCh3).connect(perkVicioCh2).connect(perkVicioCh1);
        PerkTree.PERK_TREE.registerPerk(thresholdVicio).connect(perkVicioCh1).connect(perkVicioCh2).connect(perkVicioCh3);
    }

    private static void initializePerkExteriorTravelWheel() {
        float inc_t4 = 0.03f;
        AttributeModifierPerk perkEff1 = new AttributeModifierPerk("base_inc_perkeffect_t4", -10, -18);
        perkEff1.addModifier(inc_t4, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEff2 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t4_1", -3, -20).setNameOverride(perkEff1);
        perkEff2.addModifier(inc_t4, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEff3 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t4_2", 5, -21).setNameOverride(perkEff1);
        perkEff3.addModifier(inc_t4, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEff4 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t4_3", 9, -18).setNameOverride(perkEff1);
        perkEff4.addModifier(inc_t4, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        PerkTree.PERK_TREE.registerPerk(perkEff1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("med_added_hrv_speed")).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3"));
        PerkTree.PERK_TREE.registerPerk(perkEff2).connect(perkEff1);
        PerkTree.PERK_TREE.registerPerk(perkEff3).connect(perkEff2);
        PerkTree.PERK_TREE.registerPerk(perkEff4).connect(perkEff3).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("med_reach_arrowspeed")).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_2"));
        AttributeModifierPerk perkEff5 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t4_4", 17, -12).setNameOverride(perkEff1);
        perkEff5.addModifier(inc_t4, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEff6 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t4_5", 19, -7).setNameOverride(perkEff1);
        perkEff6.addModifier(inc_t4, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEff7 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t4_6", 18, -1).setNameOverride(perkEff1);
        perkEff7.addModifier(inc_t4, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEff8 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t4_7", 19, 6).setNameOverride(perkEff1);
        perkEff8.addModifier(inc_t4, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        PerkTree.PERK_TREE.registerPerk(perkEff5).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("med_reach_arrowspeed")).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_3"));
        PerkTree.PERK_TREE.registerPerk(perkEff6).connect(perkEff5);
        PerkTree.PERK_TREE.registerPerk(perkEff7).connect(perkEff6);
        PerkTree.PERK_TREE.registerPerk(perkEff8).connect(perkEff7).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("med_more_res")).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_5"));
        AttributeModifierPerk perkEff9 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t4_9", 15, 13).setNameOverride(perkEff1);
        perkEff9.addModifier(inc_t4, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEff10 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t4_10", 14, 17).setNameOverride(perkEff1);
        perkEff10.addModifier(inc_t4, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEff11 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t4_11", 9, 18).setNameOverride(perkEff1);
        perkEff11.addModifier(inc_t4, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEff12 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t4_12", 5, 19).setNameOverride(perkEff1);
        perkEff12.addModifier(inc_t4, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        PerkTree.PERK_TREE.registerPerk(perkEff9).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("med_more_res")).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_6"));
        PerkTree.PERK_TREE.registerPerk(perkEff10).connect(perkEff9);
        PerkTree.PERK_TREE.registerPerk(perkEff11).connect(perkEff10);
        PerkTree.PERK_TREE.registerPerk(perkEff12).connect(perkEff11).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("med_add_ats_dodge")).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_8"));
        AttributeModifierPerk perkEff13 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t4_13", -5, 20).setNameOverride(perkEff1);
        perkEff13.addModifier(inc_t4, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEff14 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t4_14", -9, 19).setNameOverride(perkEff1);
        perkEff14.addModifier(inc_t4, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEff15 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t4_15", -14, 17).setNameOverride(perkEff1);
        perkEff15.addModifier(inc_t4, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEff16 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t4_16", -16, 12).setNameOverride(perkEff1);
        perkEff16.addModifier(inc_t4, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        PerkTree.PERK_TREE.registerPerk(perkEff13).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("med_add_ats_dodge")).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_9"));
        PerkTree.PERK_TREE.registerPerk(perkEff14).connect(perkEff13);
        PerkTree.PERK_TREE.registerPerk(perkEff15).connect(perkEff14);
        PerkTree.PERK_TREE.registerPerk(perkEff16).connect(perkEff15).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("med_add_life")).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_11"));
        AttributeModifierPerk perkEff17 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t4_17", -19, 4).setNameOverride(perkEff1);
        perkEff17.addModifier(inc_t4, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEff18 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t4_18", -20, -1).setNameOverride(perkEff1);
        perkEff18.addModifier(inc_t4, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEff19 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t4_19", -18, -6).setNameOverride(perkEff1);
        perkEff19.addModifier(inc_t4, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEff20 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t4_20", -16, -10).setNameOverride(perkEff1);
        perkEff20.addModifier(inc_t4, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        PerkTree.PERK_TREE.registerPerk(perkEff17).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("med_add_life")).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_12"));
        PerkTree.PERK_TREE.registerPerk(perkEff18).connect(perkEff17);
        PerkTree.PERK_TREE.registerPerk(perkEff19).connect(perkEff18);
        PerkTree.PERK_TREE.registerPerk(perkEff20).connect(perkEff19).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("med_added_hrv_speed")).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_14"));
    }

    private static void initializeEvorsioBranch() {
        AttributeModifierPerk perkM1 = new AttributeModifierPerk("med_inc_hrv_speed", -11, -11);
        perkM1.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.harvestspeed");
        AttributeModifierPerk perkM2 = (AttributeModifierPerk)new AttributeModifierPerk("med_inc_hrv_speed_1", -13, -11).setNameOverride(perkM1);
        perkM2.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.harvestspeed");
        MajorPerk perkHrvAts = new MajorPerk("not_evo_hrv_ats", -12, -10);
        perkHrvAts.addModifier(1.1f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.harvestspeed");
        perkHrvAts.addModifier(1.1f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.attackspeed");
        AttributeModifierPerk perkS1 = (AttributeModifierPerk)new AttributeModifierPerk("med_inc_hrv_speed_2", -10, -13).setNameOverride(perkM1);
        perkS1.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.harvestspeed");
        AttributeModifierPerk perkS2 = (AttributeModifierPerk)new AttributeModifierPerk("med_inc_hrv_speed_3", -12, -13).setNameOverride(perkM1);
        perkS2.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.harvestspeed");
        MajorPerk perkHrvReach = new MajorPerk("not_evo_hrv_reach", -11, -14);
        perkHrvReach.addModifier(0.08f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.harvestspeed");
        perkHrvReach.addModifier(0.15f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.reach");
        MajorPerk perkAddedHrvSpeed = new MajorPerk("med_added_hrv_speed", -14, -14);
        perkAddedHrvSpeed.addModifier(1.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.harvestspeed");
        perkAddedHrvSpeed.addModifier(0.15f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.reach");
        PerkTree.PERK_TREE.registerPerk(perkM1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("major_inc_harvest"));
        PerkTree.PERK_TREE.registerPerk(perkHrvAts).connect(perkM1);
        PerkTree.PERK_TREE.registerPerk(perkM2).connect(perkHrvAts);
        PerkTree.PERK_TREE.registerPerk(perkS1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("major_inc_harvest"));
        PerkTree.PERK_TREE.registerPerk(perkHrvReach).connect(perkS1);
        PerkTree.PERK_TREE.registerPerk(perkS2).connect(perkHrvReach);
        PerkTree.PERK_TREE.registerPerk(perkAddedHrvSpeed).connect(perkS2).connect(perkM2);
    }

    private static void initializeDiscidiaBranch() {
        AttributeModifierPerk perkP1 = new AttributeModifierPerk("med_inc_proj_damage", 11, -12);
        perkP1.addModifier(0.1f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.projectileattackdamage");
        AttributeModifierPerk perkP2 = (AttributeModifierPerk)new AttributeModifierPerk("med_inc_proj_damage_1", 13, -12).setNameOverride(perkP1);
        perkP2.addModifier(0.1f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.projectileattackdamage");
        MajorPerk perkProjCrit = new MajorPerk("not_dsc_proj_crit", 12, -11);
        perkProjCrit.addModifier(1.05f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.projectileattackdamage");
        perkProjCrit.addModifier(2.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.critchance");
        AttributeModifierPerk perkM1 = new AttributeModifierPerk("med_inc_melee_damage", 10, -14);
        perkM1.addModifier(0.1f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.meleeattackdamage");
        AttributeModifierPerk perkM2 = (AttributeModifierPerk)new AttributeModifierPerk("med_inc_melee_damage_1", 12, -14).setNameOverride(perkM1);
        perkM2.addModifier(0.1f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.meleeattackdamage");
        MajorPerk perkMeleeMulti = new MajorPerk("not_dsc_melee_multi", 11, -15);
        perkMeleeMulti.addModifier(1.05f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.meleeattackdamage");
        perkMeleeMulti.addModifier(0.3f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.critmulti");
        MajorPerk perkReachProjSpeed = new MajorPerk("med_reach_arrowspeed", 14, -16);
        perkReachProjSpeed.addModifier(1.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.reach");
        perkReachProjSpeed.addModifier(1.15f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.projectilespeed");
        PerkTree.PERK_TREE.registerPerk(perkP1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("major_inc_damage"));
        PerkTree.PERK_TREE.registerPerk(perkProjCrit).connect(perkP1);
        PerkTree.PERK_TREE.registerPerk(perkP2).connect(perkProjCrit);
        PerkTree.PERK_TREE.registerPerk(perkM1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("major_inc_damage"));
        PerkTree.PERK_TREE.registerPerk(perkMeleeMulti).connect(perkM1);
        PerkTree.PERK_TREE.registerPerk(perkM2).connect(perkMeleeMulti);
        PerkTree.PERK_TREE.registerPerk(perkReachProjSpeed).connect(perkP2).connect(perkM2);
    }

    private static void initializeArmaraBranch() {
        AttributeModifierPerk perkAr1 = new AttributeModifierPerk("med_inc_armor", 14, 8);
        perkAr1.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.armor");
        AttributeModifierPerk perkAr2 = (AttributeModifierPerk)new AttributeModifierPerk("med_inc_armor_1", 14, 10).setNameOverride(perkAr1);
        perkAr2.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.armor");
        MajorPerk perkArmorDodge = new MajorPerk("not_arm_armor_dodge", 13, 9);
        perkArmorDodge.addModifier(1.05f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.armor");
        perkArmorDodge.addModifier(3.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.dodge");
        AttributeModifierPerk perkRes1 = new AttributeModifierPerk("med_inc_resist", 16, 7);
        perkRes1.addModifier(0.06f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.allres");
        AttributeModifierPerk perkRes2 = (AttributeModifierPerk)new AttributeModifierPerk("med_inc_resist_1", 16, 9).setNameOverride(perkRes1);
        perkRes2.addModifier(0.06f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.allres");
        MajorPerk perkResistLife = new MajorPerk("not_arm_res_life", 17, 8);
        perkResistLife.addModifier(0.1f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.allres");
        perkResistLife.addModifier(1.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.maxhealth");
        MajorPerk perkResArmor = new MajorPerk("med_more_res", 18, 11);
        perkResArmor.addModifier(1.06f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.allres");
        perkResArmor.addModifier(1.06f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.armor");
        PerkTree.PERK_TREE.registerPerk(perkAr1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("major_inc_armor"));
        PerkTree.PERK_TREE.registerPerk(perkArmorDodge).connect(perkAr1);
        PerkTree.PERK_TREE.registerPerk(perkAr2).connect(perkArmorDodge);
        PerkTree.PERK_TREE.registerPerk(perkRes1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("major_inc_armor"));
        PerkTree.PERK_TREE.registerPerk(perkResistLife).connect(perkRes1);
        PerkTree.PERK_TREE.registerPerk(perkRes2).connect(perkResistLife);
        PerkTree.PERK_TREE.registerPerk(perkResArmor).connect(perkAr2).connect(perkRes2);
    }

    private static void initializeVicioBranch() {
        AttributeModifierPerk perkM1 = new AttributeModifierPerk("med_inc_ms", 1, 16);
        perkM1.addModifier(0.04f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.movespeed");
        AttributeModifierPerk perkM2 = (AttributeModifierPerk)new AttributeModifierPerk("med_inc_ms_1", 1, 18).setNameOverride(perkM1);
        perkM2.addModifier(0.04f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.movespeed");
        MajorPerk perkDodgeMs = new MajorPerk("not_vic_dodge_ms", 2, 17);
        perkDodgeMs.addModifier(0.04f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.movespeed");
        perkDodgeMs.addModifier(0.1f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.dodge");
        AttributeModifierPerk perkM3 = (AttributeModifierPerk)new AttributeModifierPerk("mec_inc_ms_2", -1, 17).setNameOverride(perkM1);
        perkM3.addModifier(0.04f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.movespeed");
        AttributeModifierPerk perkM4 = (AttributeModifierPerk)new AttributeModifierPerk("mec_inc_ms_3", -1, 19).setNameOverride(perkM1);
        perkM4.addModifier(0.04f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.movespeed");
        MajorPerk perkAtsMs = new MajorPerk("not_vic_ats", -2, 18);
        perkAtsMs.addModifier(0.15f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.attackspeed");
        MajorPerk perkAddAts = new MajorPerk("med_add_ats_dodge", 0, 21);
        perkAddAts.addModifier(1.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.attackspeed");
        perkAddAts.addModifier(5.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.dodge");
        PerkTree.PERK_TREE.registerPerk(perkM1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("major_inc_ms_fs"));
        PerkTree.PERK_TREE.registerPerk(perkDodgeMs).connect(perkM1);
        PerkTree.PERK_TREE.registerPerk(perkM2).connect(perkDodgeMs);
        PerkTree.PERK_TREE.registerPerk(perkM3).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("major_inc_ms_fs"));
        PerkTree.PERK_TREE.registerPerk(perkAtsMs).connect(perkM3);
        PerkTree.PERK_TREE.registerPerk(perkM4).connect(perkAtsMs);
        PerkTree.PERK_TREE.registerPerk(perkAddAts).connect(perkM2).connect(perkM4);
    }

    private static void initializeAevitasBranch() {
        AttributeModifierPerk perkL1 = new AttributeModifierPerk("med_inc_life", -15, 6);
        perkL1.addModifier(0.04f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.maxhealth");
        AttributeModifierPerk perkL2 = (AttributeModifierPerk)new AttributeModifierPerk("med_inc_life_1", -17, 6).setNameOverride(perkL1);
        perkL2.addModifier(0.04f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.maxhealth");
        MajorPerk perkArmorLife = new MajorPerk("not_aev_armor_life", -16, 5);
        perkArmorLife.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.maxhealth");
        perkArmorLife.addModifier(0.1f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.armor");
        AttributeModifierPerk perkL3 = (AttributeModifierPerk)new AttributeModifierPerk("med_inc_life_2", -14, 8).setNameOverride(perkL1);
        perkL3.addModifier(0.04f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.maxhealth");
        AttributeModifierPerk perkL4 = (AttributeModifierPerk)new AttributeModifierPerk("med_inc_life_3", -16, 8).setNameOverride(perkL1);
        perkL4.addModifier(0.04f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.maxhealth");
        MajorPerk perkAllResLife = new MajorPerk("not_aev_res_life", -15, 9);
        perkAllResLife.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.maxhealth");
        perkAllResLife.addModifier(0.1f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.allres");
        MajorPerk perkAddLife = new MajorPerk("med_add_life", -18, 9);
        perkAddLife.addModifier(2.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.maxhealth");
        PerkTree.PERK_TREE.registerPerk(perkL1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("major_inc_life"));
        PerkTree.PERK_TREE.registerPerk(perkArmorLife).connect(perkL1);
        PerkTree.PERK_TREE.registerPerk(perkL2).connect(perkArmorLife);
        PerkTree.PERK_TREE.registerPerk(perkL3).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("major_inc_life"));
        PerkTree.PERK_TREE.registerPerk(perkAllResLife).connect(perkL3);
        PerkTree.PERK_TREE.registerPerk(perkL4).connect(perkAllResLife);
        PerkTree.PERK_TREE.registerPerk(perkAddLife).connect(perkL2).connect(perkL4);
    }

    private static void initializePerkCore() {
        float inc_t1 = 0.07f;
        AttributeModifierPerk perkEff1 = new AttributeModifierPerk("base_inc_perkeffect_t1", 1, -2);
        perkEff1.addModifier(inc_t1, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEff2 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t1_1", 2, 1).setNameOverride(perkEff1);
        perkEff2.addModifier(inc_t1, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEff3 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t1_2", -1, 2).setNameOverride(perkEff1);
        perkEff3.addModifier(inc_t1, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEff4 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t1_3", -2, -1).setNameOverride(perkEff1);
        perkEff4.addModifier(inc_t1, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        CoreRootPerk core = new CoreRootPerk();
        PerkTree.PERK_TREE.registerPerk(perkEff1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t2_2"));
        PerkTree.PERK_TREE.registerPerk(perkEff2).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t2_5")).connect(perkEff1);
        PerkTree.PERK_TREE.registerPerk(perkEff3).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t2_8")).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t2_11")).connect(perkEff2);
        PerkTree.PERK_TREE.registerPerk(perkEff4).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t2_14")).connect(perkEff3).connect(perkEff1);
        PerkTree.PERK_TREE.registerPerk(core).connect(perkEff1).connect(perkEff3);
    }

    private static void initializePerkInteriorTravelWheel() {
        float inc_t2 = 0.05f;
        AttributeModifierPerk perkEffectEvDis1 = new AttributeModifierPerk("base_inc_perkeffect_t2", -1, -10);
        perkEffectEvDis1.addModifier(inc_t2, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectEvDis2 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t2_1", 1, -8).setNameOverride(perkEffectEvDis1);
        perkEffectEvDis2.addModifier(inc_t2, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectEvDis3 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t2_2", 0, -5).setNameOverride(perkEffectEvDis1);
        perkEffectEvDis3.addModifier(inc_t2, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectDisArm1 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t2_3", 10, -2).setNameOverride(perkEffectEvDis1);
        perkEffectDisArm1.addModifier(inc_t2, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectDisArm2 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t2_4", 7, -3).setNameOverride(perkEffectEvDis1);
        perkEffectDisArm2.addModifier(inc_t2, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectDisArm3 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t2_5", 4, -1).setNameOverride(perkEffectEvDis1);
        perkEffectDisArm3.addModifier(inc_t2, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectArmVic1 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t2_6", 6, 9).setNameOverride(perkEffectEvDis1);
        perkEffectArmVic1.addModifier(inc_t2, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectArmVic2 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t2_7", 4, 6).setNameOverride(perkEffectEvDis1);
        perkEffectArmVic2.addModifier(inc_t2, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectArmVic3 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t2_8", 1, 4).setNameOverride(perkEffectEvDis1);
        perkEffectArmVic3.addModifier(inc_t2, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectVicAev1 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t2_9", -6, 9).setNameOverride(perkEffectEvDis1);
        perkEffectVicAev1.addModifier(inc_t2, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectVicAev2 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t2_10", -5, 5).setNameOverride(perkEffectEvDis1);
        perkEffectVicAev2.addModifier(inc_t2, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectVicAev3 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t2_11", -2, 4).setNameOverride(perkEffectEvDis1);
        perkEffectVicAev3.addModifier(inc_t2, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectAevEv1 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t2_12", -10, -2).setNameOverride(perkEffectEvDis1);
        perkEffectAevEv1.addModifier(inc_t2, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectAevEv2 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t2_13", -7, -1).setNameOverride(perkEffectEvDis1);
        perkEffectAevEv2.addModifier(inc_t2, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectAevEv3 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t2_14", -5, -2).setNameOverride(perkEffectEvDis1);
        perkEffectAevEv3.addModifier(inc_t2, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        PerkTree.PERK_TREE.registerPerk(perkEffectEvDis1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_1"));
        PerkTree.PERK_TREE.registerPerk(perkEffectEvDis2).connect(perkEffectEvDis1);
        PerkTree.PERK_TREE.registerPerk(perkEffectEvDis3).connect(perkEffectEvDis2);
        PerkTree.PERK_TREE.registerPerk(perkEffectDisArm1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_4"));
        PerkTree.PERK_TREE.registerPerk(perkEffectDisArm2).connect(perkEffectDisArm1);
        PerkTree.PERK_TREE.registerPerk(perkEffectDisArm3).connect(perkEffectDisArm2);
        PerkTree.PERK_TREE.registerPerk(perkEffectArmVic1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_7"));
        PerkTree.PERK_TREE.registerPerk(perkEffectArmVic2).connect(perkEffectArmVic1);
        PerkTree.PERK_TREE.registerPerk(perkEffectArmVic3).connect(perkEffectArmVic2);
        PerkTree.PERK_TREE.registerPerk(perkEffectVicAev1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_10"));
        PerkTree.PERK_TREE.registerPerk(perkEffectVicAev2).connect(perkEffectVicAev1);
        PerkTree.PERK_TREE.registerPerk(perkEffectVicAev3).connect(perkEffectVicAev2);
        PerkTree.PERK_TREE.registerPerk(perkEffectAevEv1).connect(PerkTree.PERK_TREE.getAstralSorceryPerk("base_inc_perkeffect_t3_13"));
        PerkTree.PERK_TREE.registerPerk(perkEffectAevEv2).connect(perkEffectAevEv1);
        PerkTree.PERK_TREE.registerPerk(perkEffectAevEv3).connect(perkEffectAevEv2);
    }

    private static void initializeRootPerkWheel() {
        float inc_t3 = 0.04f;
        AttributeModifierPerk perkEffectEvDis1 = new AttributeModifierPerk("base_inc_perkeffect_t3", -5, -12);
        perkEffectEvDis1.addModifier(inc_t3, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectEvDis2 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t3_1", 0, -13).setNameOverride(perkEffectEvDis1);
        perkEffectEvDis2.addModifier(inc_t3, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectEvDis3 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t3_2", 5, -12).setNameOverride(perkEffectEvDis1);
        perkEffectEvDis3.addModifier(inc_t3, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectDisArm1 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t3_3", 11, -7).setNameOverride(perkEffectEvDis1);
        perkEffectDisArm1.addModifier(inc_t3, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectDisArm2 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t3_4", 13, -3).setNameOverride(perkEffectEvDis1);
        perkEffectDisArm2.addModifier(inc_t3, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectDisArm3 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t3_5", 14, 2).setNameOverride(perkEffectEvDis1);
        perkEffectDisArm3.addModifier(inc_t3, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectArmVic1 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t3_6", 11, 9).setNameOverride(perkEffectEvDis1);
        perkEffectArmVic1.addModifier(inc_t3, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectArmVic2 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t3_7", 8, 12).setNameOverride(perkEffectEvDis1);
        perkEffectArmVic2.addModifier(inc_t3, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectArmVic3 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t3_8", 4, 13).setNameOverride(perkEffectEvDis1);
        perkEffectArmVic3.addModifier(inc_t3, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectVicAev1 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t3_9", -3, 13).setNameOverride(perkEffectEvDis1);
        perkEffectVicAev1.addModifier(inc_t3, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectVicAev2 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t3_10", -8, 12).setNameOverride(perkEffectEvDis1);
        perkEffectVicAev2.addModifier(inc_t3, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectVicAev3 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t3_11", -11, 9).setNameOverride(perkEffectEvDis1);
        perkEffectVicAev3.addModifier(inc_t3, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectAevEv1 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t3_12", -14, 2).setNameOverride(perkEffectEvDis1);
        perkEffectAevEv1.addModifier(inc_t3, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectAevEv2 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t3_13", -13, -3).setNameOverride(perkEffectEvDis1);
        perkEffectAevEv2.addModifier(inc_t3, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        AttributeModifierPerk perkEffectAevEv3 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_perkeffect_t3_14", -11, -7).setNameOverride(perkEffectEvDis1);
        perkEffectAevEv3.addModifier(inc_t3, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.perkeffect");
        PerkTree.PERK_TREE.registerPerk(perkEffectEvDis1).connect(perkRootMajorHarvest);
        PerkTree.PERK_TREE.registerPerk(perkEffectEvDis2).connect(perkEffectEvDis1);
        PerkTree.PERK_TREE.registerPerk(perkEffectEvDis3).connect(perkEffectEvDis2).connect(perkRootMajorDamage);
        PerkTree.PERK_TREE.registerPerk(perkEffectDisArm1).connect(perkRootMajorDamage);
        PerkTree.PERK_TREE.registerPerk(perkEffectDisArm2).connect(perkEffectDisArm1);
        PerkTree.PERK_TREE.registerPerk(perkEffectDisArm3).connect(perkEffectDisArm2).connect(perkRootMajorArmor);
        PerkTree.PERK_TREE.registerPerk(perkEffectArmVic1).connect(perkRootMajorArmor);
        PerkTree.PERK_TREE.registerPerk(perkEffectArmVic2).connect(perkEffectArmVic1);
        PerkTree.PERK_TREE.registerPerk(perkEffectArmVic3).connect(perkEffectArmVic2).connect(perkRootMajorMovespeed);
        PerkTree.PERK_TREE.registerPerk(perkEffectVicAev1).connect(perkRootMajorMovespeed);
        PerkTree.PERK_TREE.registerPerk(perkEffectVicAev2).connect(perkEffectVicAev1);
        PerkTree.PERK_TREE.registerPerk(perkEffectVicAev3).connect(perkEffectVicAev2).connect(perkRootMajorHealth);
        PerkTree.PERK_TREE.registerPerk(perkEffectAevEv1).connect(perkRootMajorHealth);
        PerkTree.PERK_TREE.registerPerk(perkEffectAevEv2).connect(perkEffectAevEv1);
        PerkTree.PERK_TREE.registerPerk(perkEffectAevEv3).connect(perkEffectAevEv2).connect(perkRootMajorHarvest);
    }

    private static void initializeEvorsioRoot() {
        AttributeModifierPerk breakRoot1 = new AttributeModifierPerk("base_inc_harvest", -7, -7);
        breakRoot1.addModifier(0.1f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.harvestspeed");
        AttributeModifierPerk breakRoot2 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_harvest_1", -6, -9).setNameOverride(breakRoot1);
        breakRoot2.addModifier(0.1f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.harvestspeed");
        perkRootMajorHarvest = new MajorPerk("major_inc_harvest", -9, -10);
        perkRootMajorHarvest.addModifier(1.05f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.harvestspeed");
        perkRootMajorHarvest.addModifier(0.1f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.meleeattackdamage");
        PerkTree.PointConnector ctHarvest1 = PerkTree.PERK_TREE.registerPerk(breakRoot1);
        PerkTree.PointConnector ctHarvest2 = PerkTree.PERK_TREE.registerPerk(breakRoot2);
        PerkTree.PointConnector ctMajorHarvest = PerkTree.PERK_TREE.registerPerk(perkRootMajorHarvest);
        breakRoot1.setRequireDiscoveredConstellation(Constellations.evorsio);
        breakRoot2.setRequireDiscoveredConstellation(Constellations.evorsio);
        perkRootMajorHarvest.setRequireDiscoveredConstellation(Constellations.evorsio);
        ctHarvest1.connect(PerkTree.PERK_TREE.getRootPerk(Constellations.evorsio));
        ctHarvest2.connect(ctHarvest1);
        ctMajorHarvest.connect(ctHarvest2);
    }

    private static void initializeDiscidiaRoot() {
        AttributeModifierPerk dmgRoot1 = new AttributeModifierPerk("base_inc__melee_damage", 7, -7);
        dmgRoot1.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.meleeattackdamage");
        AttributeModifierPerk dmgRoot2 = new AttributeModifierPerk("base_inc_proj_damage", 6, -9);
        dmgRoot2.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.projectileattackdamage");
        perkRootMajorDamage = new MajorPerk("major_inc_damage", 9, -10);
        perkRootMajorDamage.addModifier(1.05f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.meleeattackdamage");
        perkRootMajorDamage.addModifier(1.05f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.projectileattackdamage");
        perkRootMajorDamage.addModifier(2.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.critchance");
        PerkTree.PointConnector ctDamage1 = PerkTree.PERK_TREE.registerPerk(dmgRoot1);
        PerkTree.PointConnector ctDamage2 = PerkTree.PERK_TREE.registerPerk(dmgRoot2);
        PerkTree.PointConnector ctMajorDamage = PerkTree.PERK_TREE.registerPerk(perkRootMajorDamage);
        dmgRoot1.setRequireDiscoveredConstellation(Constellations.discidia);
        dmgRoot2.setRequireDiscoveredConstellation(Constellations.discidia);
        perkRootMajorDamage.setRequireDiscoveredConstellation(Constellations.discidia);
        ctDamage1.connect(PerkTree.PERK_TREE.getRootPerk(Constellations.discidia));
        ctDamage2.connect(ctDamage1);
        ctMajorDamage.connect(ctDamage2);
    }

    private static void initializeArmaraRoot() {
        AttributeModifierPerk armorRoot1 = new AttributeModifierPerk("base_inc_armor", 9, 3);
        armorRoot1.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.armor");
        AttributeModifierPerk armorRoot2 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_armor_1", 8, 5).setNameOverride(armorRoot1);
        armorRoot2.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.armor");
        perkRootMajorArmor = new MajorPerk("major_inc_armor", 12, 6);
        perkRootMajorArmor.addModifier(1.2f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.armor");
        PerkTree.PointConnector ctArmor1 = PerkTree.PERK_TREE.registerPerk(armorRoot1);
        PerkTree.PointConnector ctArmor2 = PerkTree.PERK_TREE.registerPerk(armorRoot2);
        PerkTree.PointConnector ctMajorArmor = PerkTree.PERK_TREE.registerPerk(perkRootMajorArmor);
        armorRoot1.setRequireDiscoveredConstellation(Constellations.armara);
        armorRoot2.setRequireDiscoveredConstellation(Constellations.armara);
        perkRootMajorArmor.setRequireDiscoveredConstellation(Constellations.armara);
        ctArmor1.connect(PerkTree.PERK_TREE.getRootPerk(Constellations.armara));
        ctArmor2.connect(ctArmor1);
        ctMajorArmor.connect(ctArmor2);
    }

    private static void initializeVicioRoot() {
        AttributeModifierPerk moveRoot1 = new AttributeModifierPerk("base_inc_ms", 1, 10);
        moveRoot1.addModifier(0.03f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.movespeed");
        AttributeModifierPerk moveRoot2 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_ms_1", -1, 11).setNameOverride(moveRoot1);
        moveRoot2.addModifier(0.03f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.movespeed");
        perkRootMajorMovespeed = new MajorPerk("major_inc_ms_fs", 0, 14);
        perkRootMajorMovespeed.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.movespeed");
        perkRootMajorMovespeed.addModifier(5.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.dodge");
        PerkTree.PointConnector ctMove1 = PerkTree.PERK_TREE.registerPerk(moveRoot1);
        PerkTree.PointConnector ctMove2 = PerkTree.PERK_TREE.registerPerk(moveRoot2);
        PerkTree.PointConnector ctMajorMobility = PerkTree.PERK_TREE.registerPerk(perkRootMajorMovespeed);
        moveRoot1.setRequireDiscoveredConstellation(Constellations.vicio);
        moveRoot2.setRequireDiscoveredConstellation(Constellations.vicio);
        perkRootMajorMovespeed.setRequireDiscoveredConstellation(Constellations.vicio);
        ctMove1.connect(PerkTree.PERK_TREE.getRootPerk(Constellations.vicio));
        ctMove2.connect(ctMove1);
        ctMajorMobility.connect(ctMove2);
    }

    private static void initializeAevitasRoot() {
        AttributeModifierPerk lifeRoot1 = new AttributeModifierPerk("base_inc_life", -9, 3);
        lifeRoot1.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.maxhealth");
        AttributeModifierPerk lifeRoot2 = (AttributeModifierPerk)new AttributeModifierPerk("base_inc_life_1", -8, 5).setNameOverride(lifeRoot1);
        lifeRoot2.addModifier(0.05f, PerkAttributeModifier.Mode.ADDED_MULTIPLY, "astralsorcery.maxhealth");
        perkRootMajorHealth = new MajorPerk("major_inc_life", -12, 6);
        perkRootMajorHealth.addModifier(1.15f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.maxhealth");
        lifeRoot1.setRequireDiscoveredConstellation(Constellations.aevitas);
        lifeRoot2.setRequireDiscoveredConstellation(Constellations.aevitas);
        perkRootMajorHealth.setRequireDiscoveredConstellation(Constellations.aevitas);
        PerkTree.PointConnector ctLife1 = PerkTree.PERK_TREE.registerPerk(lifeRoot1);
        PerkTree.PointConnector ctLife2 = PerkTree.PERK_TREE.registerPerk(lifeRoot2);
        PerkTree.PointConnector ctMajorLife = PerkTree.PERK_TREE.registerPerk(perkRootMajorHealth);
        ctLife1.connect(PerkTree.PERK_TREE.getRootPerk(Constellations.aevitas));
        ctLife2.connect(ctLife1);
        ctMajorLife.connect(ctLife2);
    }

    private static void initializeRoot() {
        AevitasRootPerk rootAevitas = new AevitasRootPerk(-6, 2);
        rootAevitas.addModifier(2.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.maxhealth");
        VicioRootPerk rootVicio = new VicioRootPerk(0, 7);
        rootVicio.addModifier(1.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.reach");
        ArmaraRootPerk rootArmara = new ArmaraRootPerk(6, 2);
        rootArmara.addModifier(1.15f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.allres");
        DiscidiaRootPerk rootDiscidia = new DiscidiaRootPerk(4, -5);
        rootDiscidia.addModifier(10.0f, PerkAttributeModifier.Mode.ADDITION, "astralsorcery.critchance");
        EvorsioRootPerk rootEvorsio = new EvorsioRootPerk(-4, -5);
        rootEvorsio.addModifier(1.2f, PerkAttributeModifier.Mode.STACKING_MULTIPLY, "astralsorcery.harvestspeed");
        PerkTree.PERK_TREE.registerRootPerk(rootAevitas);
        PerkTree.PERK_TREE.registerRootPerk(rootVicio);
        PerkTree.PERK_TREE.registerRootPerk(rootArmara);
        PerkTree.PERK_TREE.registerRootPerk(rootDiscidia);
        PerkTree.PERK_TREE.registerRootPerk(rootEvorsio);
    }

    private static void initializeAttributeTypes() {
        AttributeTypeRegistry.registerPerkType(new AttributeTypePerkEffect());
        AttributeTypeRegistry.registerPerkType(new AttributeBreakSpeed());
        AttributeTypeRegistry.registerPerkType(new AttributeCritChance());
        AttributeTypeRegistry.registerPerkType(new AttributeCritMultiplier());
        AttributeTypeRegistry.registerPerkType(new AttributeAllElementalResist());
        AttributeTypeRegistry.registerPerkType(new AttributeDodge());
        AttributeTypeRegistry.registerPerkType(new AttributeProjectileAttackDamage());
        AttributeTypeRegistry.registerPerkType(new AttributeArrowSpeed());
        AttributeTypeRegistry.registerPerkType(new PerkAttributeType("astralsorcery.expgain", true));
        AttributeTypeRegistry.registerPerkType(new AttributeLifeRecovery());
        AttributeTypeRegistry.registerPerkType(new AttributePotionDuration());
        AttributeTypeRegistry.registerPerkType(new PerkAttributeType("astralsorcery.archops"));
        AttributeTypeRegistry.registerPerkType(new PerkAttributeType("astralsorcery.bleedduration"));
        AttributeTypeRegistry.registerPerkType(new PerkAttributeType("astralsorcery.bleedamount"));
        AttributeTypeRegistry.registerPerkType(new PerkAttributeType("astralsorcery.chainlength"));
        AttributeTypeRegistry.registerPerkType(new PerkAttributeType("astralsorcery.chainchance"));
        AttributeTypeRegistry.registerPerkType(new PerkAttributeType("astralsorcery.chainchancing"));
        AttributeTypeRegistry.registerPerkType(new AttributeLifeLeech());
        AttributeTypeRegistry.registerPerkType(new AttributeThorns());
        AttributeTypeRegistry.registerPerkType(new PerkAttributeType("astralsorcery.rangedthorns"));
        AttributeTypeRegistry.registerPerkType(new AttributeEnchantmentEffectiveness());
        AttributeTypeRegistry.registerPerkType(new AttributeTypeMeleeAttackDamage());
        AttributeTypeRegistry.registerPerkType(new AttributeTypeMaxHealth());
        AttributeTypeRegistry.registerPerkType(new AttributeTypeMovementSpeed());
        AttributeTypeRegistry.registerPerkType(new AttributeTypeSwimSpeed());
        AttributeTypeRegistry.registerPerkType(new AttributeTypeArmor());
        AttributeTypeRegistry.registerPerkType(new AttributeTypeArmorToughness());
        AttributeTypeRegistry.registerPerkType(new AttributeTypeAttackSpeed());
        AttributeTypeRegistry.registerPerkType(new AttributeTypeMaxReach());
        AttributeTypeRegistry.limitPerkType("astralsorcery.dodge", 0.0f, 0.75f);
        AttributeTypeRegistry.limitPerkType("astralsorcery.allres", 0.0f, 0.6f);
        AttributeTypeRegistry.limitPerkType("astralsorcery.lifeleech", 0.0f, 0.1f);
        MinecraftForge.EVENT_BUS.post((Event)new APIRegistryEvent.PerkAttributeTypeRegister());
    }

    private static void initializeAttributeInterpreters() {
        AttributeReaderRegistry.registerTypeReader("astralsorcery.meleeattackdamage", new VanillaAttributeReader(SharedMonsterAttributes.field_111264_e).formatAsDecimal());
        AttributeReaderRegistry.registerTypeReader("astralsorcery.maxhealth", new VanillaAttributeReader(SharedMonsterAttributes.field_111267_a));
        AttributeReaderRegistry.registerTypeReader("astralsorcery.movespeed", new VanillaAttributeReader(SharedMonsterAttributes.field_111263_d).formatAsDecimal());
        AttributeReaderRegistry.registerTypeReader("astralsorcery.swimspeed", new VanillaAttributeReader(EntityLivingBase.SWIM_SPEED).formatAsDecimal());
        AttributeReaderRegistry.registerTypeReader("astralsorcery.armor", new VanillaAttributeReader(SharedMonsterAttributes.field_188791_g));
        AttributeReaderRegistry.registerTypeReader("astralsorcery.armortoughness", new VanillaAttributeReader(SharedMonsterAttributes.field_189429_h));
        AttributeReaderRegistry.registerTypeReader("astralsorcery.attackspeed", new VanillaAttributeReader(SharedMonsterAttributes.field_188790_f).formatAsDecimal());
        AttributeReaderRegistry.registerTypeReader("astralsorcery.reach", new VanillaAttributeReader(EntityPlayer.REACH_DISTANCE).formatAsDecimal());
        RegistryPerks.registerDefaultReader("astralsorcery.perkeffect");
        RegistryPerks.registerDefaultReader("astralsorcery.expgain");
        RegistryPerks.registerDefaultReader("astralsorcery.critmulti");
        RegistryPerks.registerDefaultReader("astralsorcery.allres");
        RegistryPerks.registerDefaultReader("astralsorcery.projectileattackdamage");
        RegistryPerks.registerDefaultReader("astralsorcery.projectilespeed");
        RegistryPerks.registerDefaultReader("astralsorcery.liferecovery");
        RegistryPerks.registerDefaultReader("astralsorcery.potionduration");
        RegistryPerks.registerDefaultReader("astralsorcery.dynenchantmenteffect");
        RegistryPerks.registerDefaultReader("astralsorcery.dodge");
        RegistryPerks.registerDefaultReader("astralsorcery.critchance");
        RegistryPerks.registerDefaultReader("astralsorcery.lifeleech");
        RegistryPerks.registerDefaultReader("astralsorcery.thorns");
        RegistryPerks.registerReader("astralsorcery.harvestspeed", BreakSpeedAttributeReader::new);
    }

    private static void registerDefaultReader(String typeStr) {
        PerkAttributeType type = AttributeTypeRegistry.getType(typeStr);
        if (type != null) {
            if (type.isMultiplicative()) {
                RegistryPerks.registerReader(typeStr, PercentageAttributeReader::new);
            } else {
                RegistryPerks.registerReader(typeStr, AddedPercentageAttributeReader::new);
            }
        }
    }

    private static void registerReader(String typeStr, Function<PerkAttributeType, AttributeReader> fct) {
        PerkAttributeType type = AttributeTypeRegistry.getType(typeStr);
        if (type != null) {
            AttributeReaderRegistry.registerTypeReader(typeStr, fct.apply(type));
        }
    }
}

