/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.structure.change;

import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.Collections;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;

public final class BlockStateChangeSet {
    private Map<BlockPos, StateChange> changes = Maps.newHashMap();

    public final void reset() {
        this.changes.clear();
    }

    public void addChange(BlockPos pos, IBlockState oldState, IBlockState newState) {
        StateChange oldChangeSet = this.changes.get(pos);
        if (oldChangeSet != null) {
            this.changes.put(pos, new StateChange(pos, oldChangeSet.oldState, newState));
        } else {
            this.changes.put(pos, new StateChange(pos, oldState, newState));
        }
    }

    public boolean hasChange(BlockPos pos) {
        return this.changes.containsKey(pos);
    }

    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    public Iterable<StateChange> getChanges() {
        return Collections.unmodifiableCollection(this.changes.values());
    }

    public void readFromNBT(NBTTagCompound cmp) {
        this.changes.clear();
        NBTTagList changeList = cmp.func_150295_c("changeList", 10);
        for (int i = 0; i < changeList.func_74745_c(); ++i) {
            NBTTagCompound changeTag = changeList.func_150305_b(i);
            BlockPos pos = NBTHelper.readBlockPosFromNBT(changeTag);
            IBlockState oldState = NBTHelper.getBlockStateFromTag(changeTag.func_74775_l("oldState"), Blocks.field_150350_a.func_176223_P());
            IBlockState newState = NBTHelper.getBlockStateFromTag(changeTag.func_74775_l("newState"), Blocks.field_150350_a.func_176223_P());
            this.changes.put(pos, new StateChange(pos, oldState, newState));
        }
    }

    public void writeToNBT(NBTTagCompound cmp) {
        NBTTagList changes = new NBTTagList();
        for (StateChange change : this.changes.values()) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTHelper.writeBlockPosToNBT(change.pos, tag);
            tag.func_74782_a("oldState", (NBTBase)NBTHelper.getBlockStateNBTTag(change.oldState));
            tag.func_74782_a("newState", (NBTBase)NBTHelper.getBlockStateNBTTag(change.newState));
            changes.func_74742_a((NBTBase)tag);
        }
        cmp.func_74782_a("changeList", (NBTBase)changes);
    }

    public static final class StateChange {
        public final BlockPos pos;
        public final IBlockState oldState;
        public final IBlockState newState;

        private StateChange(BlockPos pos, IBlockState oldState, IBlockState newState) {
            this.pos = pos;
            this.oldState = oldState;
            this.newState = newState;
        }
    }
}

