/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.structure.change;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.data.world.CachedWorldData;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.structure.StructureMatcher;
import hellfirepvp.astralsorcery.common.structure.change.BlockStateChangeSet;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.Collection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ChangeSubscriber<T extends StructureMatcher> {
    private BlockPos requester;
    private T matcher;
    private BlockStateChangeSet changeSet = new BlockStateChangeSet();
    private Boolean isMatching = null;
    private Collection<ChunkPos> affectedChunkCache = null;

    public ChangeSubscriber(BlockPos requester, T matcher) {
        this.requester = requester;
        this.matcher = matcher;
    }

    public BlockPos getRequester() {
        return this.requester;
    }

    public T getMatcher() {
        return this.matcher;
    }

    public Collection<ChunkPos> getObservableChunks() {
        if (this.affectedChunkCache == null) {
            this.affectedChunkCache = Lists.newArrayList(((StructureMatcher)this.getMatcher()).getObservableArea().getAffectedChunks((Vec3i)this.getRequester()));
        }
        return this.affectedChunkCache;
    }

    public boolean observes(BlockPos pos) {
        return ((StructureMatcher)this.getMatcher()).getObservableArea().observes(pos.func_177973_b((Vec3i)this.getRequester()));
    }

    public void addChange(BlockPos pos, IBlockState oldState, IBlockState newState) {
        this.changeSet.addChange(pos.func_177973_b((Vec3i)this.getRequester()), oldState, newState);
    }

    public boolean matches(World world) {
        if (this.isMatching != null && this.changeSet.isEmpty()) {
            return this.isMatching;
        }
        this.isMatching = ((StructureMatcher)this.matcher).notifyChange((IBlockAccess)world, this.requester, this.changeSet);
        this.changeSet.reset();
        ((CachedWorldData)WorldCacheManager.getOrLoadData(world, WorldCacheManager.SaveKey.STRUCTURE_MATCH)).markDirty();
        return this.isMatching;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.affectedChunkCache = null;
        ((StructureMatcher)this.matcher).readFromNBT(tag.func_74775_l("matchData"));
        this.changeSet.readFromNBT(tag.func_74775_l("changeData"));
        this.requester = NBTHelper.readBlockPosFromNBT(tag);
        this.isMatching = tag.func_74764_b("isMatching") ? Boolean.valueOf(tag.func_74767_n("isMatching")) : null;
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagCompound areaData = new NBTTagCompound();
        ((StructureMatcher)this.matcher).writeToNBT(areaData);
        tag.func_74782_a("matchData", (NBTBase)areaData);
        NBTTagCompound changeData = new NBTTagCompound();
        this.changeSet.writeToNBT(changeData);
        tag.func_74782_a("changeData", (NBTBase)changeData);
        NBTHelper.writeBlockPosToNBT(this.requester, tag);
        if (this.isMatching != null) {
            tag.func_74757_a("isMatching", this.isMatching.booleanValue());
        }
    }
}

