/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RaytraceAssist {
    private static final Map<Block, List<Integer>> passable = new HashMap<Block, List<Integer>>();
    private static final double STEP_WIDTH = 0.05;
    private static final Vector3 CENTRALIZE = new Vector3(0.5, 0.5, 0.5);
    private final Vector3 start;
    private final Vector3 target;
    private final BlockPos startPos;
    private final BlockPos targetPos;
    private boolean collectEntities = false;
    private List<Integer> collected = new LinkedList<Integer>();
    private AxisAlignedBB collectBox = null;
    private boolean includeEnd = false;
    private BlockPos hit = null;

    public RaytraceAssist(BlockPos start, BlockPos target) {
        this(new Vector3(start).add(CENTRALIZE), new Vector3(target).add(CENTRALIZE));
    }

    public RaytraceAssist(Vector3 start, Vector3 target) {
        this.start = start.clone();
        this.target = target.clone();
        this.startPos = this.start.toBlockPos();
        this.targetPos = this.target.toBlockPos();
    }

    public RaytraceAssist includeEndPoint() {
        this.includeEnd = true;
        return this;
    }

    public void setCollectEntities(double additionalCollectRadius) {
        this.collectEntities = true;
        this.collectBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.collectBox = this.collectBox.func_186662_g(additionalCollectRadius);
    }

    public boolean isClear(World world) {
        Vector3 aim = this.start.vectorFromHereTo(this.target);
        Vector3 stepAim = aim.clone().normalize().multiply(0.05);
        double distance = aim.length();
        Vector3 prevVec = this.start.clone();
        for (double distancePart = 0.05; distancePart <= distance; distancePart += 0.05) {
            IBlockState state;
            Vector3 stepVec = prevVec.clone().add(stepAim);
            BlockPos at = stepVec.toBlockPos();
            if (this.collectEntities) {
                List entities = world.func_72872_a(Entity.class, this.collectBox.func_72317_d(stepVec.getX(), stepVec.getY(), stepVec.getZ()));
                for (Entity b : entities) {
                    if (this.collected.contains(b.func_145782_y())) continue;
                    this.collected.add(b.func_145782_y());
                }
            }
            if (MiscUtils.isChunkLoaded(world, new ChunkPos(at)) && !this.isStartEnd(at) && !world.func_175623_d(at) && !this.isAllowed(state = world.func_180495_p(at))) {
                this.hit = at;
                return false;
            }
            prevVec = stepVec;
        }
        return true;
    }

    public BlockPos blockHit() {
        return this.hit;
    }

    public List<Entity> collectedEntities(World world) {
        LinkedList<Entity> entities = new LinkedList<Entity>();
        for (Integer id : this.collected) {
            Entity e = world.func_73045_a(id.intValue());
            if (e == null || e.field_70128_L) continue;
            entities.add(e);
        }
        return entities;
    }

    private boolean isAllowed(IBlockState state) {
        Block b = state.func_177230_c();
        List<Integer> accepted = passable.get(b);
        if (accepted != null) {
            if (accepted.size() == 1 && accepted.get(0) == -1) {
                return true;
            }
            if (accepted.contains(b.func_176201_c(state))) {
                return true;
            }
        }
        return false;
    }

    private boolean isStartEnd(BlockPos hit) {
        return hit.equals((Object)this.startPos) || !this.includeEnd && hit.equals((Object)this.targetPos);
    }

    public static void addPassable(Block b, Integer ... stateMetas) {
        ArrayList<Integer> passStates = new ArrayList<Integer>();
        if (stateMetas == null || stateMetas.length == 0) {
            passStates.add(-1);
        } else {
            Collections.addAll(passStates, stateMetas);
        }
        passable.put(b, passStates);
    }

    @SideOnly(value=Side.CLIENT)
    public static void playDebug(PktParticleEvent event) {
        Vector3 pos = event.getVec();
        EntityFXFacingParticle p = EffectHelper.genericFlareParticle(pos.getX(), pos.getY(), pos.getZ());
        p.gravity(0.004).scale(0.05f);
    }

    static {
        RaytraceAssist.addPassable(Blocks.field_150359_w, new Integer[0]);
        RaytraceAssist.addPassable(Blocks.field_150410_aZ, new Integer[0]);
        RaytraceAssist.addPassable((Block)Blocks.field_150399_cn, new Integer[0]);
        RaytraceAssist.addPassable((Block)Blocks.field_150397_co, new Integer[0]);
    }
}

