/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world.structure;

import hellfirepvp.astralsorcery.common.data.world.data.StructureGenBuffer;
import hellfirepvp.astralsorcery.common.lib.MultiBlockArrays;
import hellfirepvp.astralsorcery.common.world.structure.WorldGenAttributeStructure;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;

public class StructureDesertShrine
extends WorldGenAttributeStructure {
    private int heightThreshold = 3;

    public StructureDesertShrine() {
        super(0, "desertStructure", () -> MultiBlockArrays.desertShrine, StructureGenBuffer.StructureType.DESERT, false, BiomeDictionary.Type.SANDY);
        this.idealDistance = 1024.0f;
    }

    @Override
    public void generate(BlockPos pos, World world, Random rand) {
        this.generateAsSubmergedStructure(world, pos);
        this.getBuffer(world).markStructureGeneration(pos, this.getStructureType());
    }

    @Override
    public boolean fulfillsSpecificConditions(BlockPos pos, World world, Random random) {
        if (!this.isApplicableWorld(world)) {
            return false;
        }
        if (!this.isDesertBiome(world, pos)) {
            return false;
        }
        if (!this.canSpawnShrineCorner(world, pos.func_177982_a(-4, 0, 4))) {
            return false;
        }
        if (!this.canSpawnShrineCorner(world, pos.func_177982_a(4, 0, -4))) {
            return false;
        }
        if (!this.canSpawnShrineCorner(world, pos.func_177982_a(4, 0, 4))) {
            return false;
        }
        return this.canSpawnShrineCorner(world, pos.func_177982_a(-4, 0, -4));
    }

    @Override
    public BlockPos getGenerationPosition(int chX, int chZ, World world, Random rand) {
        int rX = chX * 16 + rand.nextInt(16) + 8;
        int rZ = chZ * 16 + rand.nextInt(16) + 8;
        int rY = world.func_175672_r(new BlockPos(rX, 0, rZ)).func_177956_o();
        return new BlockPos(rX, rY, rZ);
    }

    private boolean canSpawnShrineCorner(World world, BlockPos pos) {
        int dY = world.func_175672_r(pos).func_177956_o();
        return dY >= this.cfgEntry.getMinY() && dY <= this.cfgEntry.getMaxY() && Math.abs(dY - pos.func_177956_o()) <= this.heightThreshold && this.isDesertBiome(world, pos);
    }

    private boolean isApplicableWorld(World world) {
        if (this.cfgEntry.shouldIgnoreDimensionSpecifications()) {
            return true;
        }
        Integer dimId = world.field_73011_w.getDimension();
        if (this.cfgEntry.getApplicableDimensions().isEmpty()) {
            return false;
        }
        for (Integer dim : this.cfgEntry.getApplicableDimensions()) {
            if (!dim.equals(dimId)) continue;
            return true;
        }
        return false;
    }

    private boolean isDesertBiome(World world, BlockPos pos) {
        if (this.cfgEntry.shouldIgnoreBiomeSpecifications()) {
            return true;
        }
        Biome b = world.func_180494_b(pos);
        Set types = BiomeDictionary.getTypes((Biome)b);
        if (types.isEmpty()) {
            return false;
        }
        boolean applicable = false;
        for (BiomeDictionary.Type t : types) {
            if (!this.cfgEntry.getTypes().contains(t)) continue;
            applicable = true;
        }
        return applicable;
    }

    @Override
    protected void loadAdditionalConfigEntries(Configuration cfg) {
        super.loadAdditionalConfigEntries(cfg);
        this.heightThreshold = cfg.getInt("heightThreshold", this.cfgEntry.getConfigurationSection(), this.heightThreshold, 1, 32, "Defines how high/low the surface in comparison to the structure can be to be seen as 'sufficiently flat' for the structure to spawn at the given position.");
    }
}

