/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedbackpacks.init;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

public class ModConfig {
    private static final String[] DEFAULT_ITEM_BLACKLIST = new String[]{"ironbackpacks:backpack", "compactstorage:backpack", "quantumstorage:quantum_bag", "thebetweenlands:lurker_skin_pouch"};
    private static final String[] DEFAULT_ORE_DICT_BLACKLIST = new String[]{"backpack"};
    public static Configuration config;
    public static boolean allowDyeBackpacks;
    public static boolean enderBackpackEnabled;
    public static boolean renderWearingBackpacks;
    public static int maxBackpackTier;
    public static int minDeathKeepTier;
    public static List<ResourceLocation> blacklistedItems;
    public static List<String> blacklistedOreDictNames;

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("improvedbackpacks")) {
            ModConfig.syncConfig();
        }
    }

    public static void init(File file) {
        config = new Configuration(file);
        ModConfig.syncConfig();
    }

    public static void syncConfig() {
        String category = "Backpacks";
        allowDyeBackpacks = config.getBoolean("can_dye", category, true, "Is it possible to dye backpacks");
        enderBackpackEnabled = config.getBoolean("ender_backpack_enabled", category, true, "Is Ender Backpack enabled");
        renderWearingBackpacks = config.getBoolean("render_wearing_backpacks", category, true, "Whether to render wearing backpacks");
        maxBackpackTier = config.getInt("max_tier", category, 5, 0, 5, "The max tier possible to upgrade backpack. Set to 0 to disable upgrades.");
        minDeathKeepTier = config.getInt("min_keep_on_death_tier", category, -1, -1, 5, "Starting with this tier backpacks will be kept on death. Set to -1 to disable keep backpacks after death.");
        blacklistedItems = Arrays.stream(config.getStringList("blacklisted_items", category, DEFAULT_ITEM_BLACKLIST, "List of items that player will be unable to put in a backpack")).map(ResourceLocation::new).collect(Collectors.toList());
        blacklistedOreDictNames = Arrays.stream(config.getStringList("blacklisted_ore_dict_names", category, DEFAULT_ORE_DICT_BLACKLIST, "List of ore dictionary names that player will be unable to put in a backpack")).collect(Collectors.toList());
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static boolean isItemBlockedByConfig(ItemStack stack) {
        if (blacklistedItems.contains(stack.func_77973_b().getRegistryName())) {
            return true;
        }
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!blacklistedOreDictNames.contains(OreDictionary.getOreName((int)id))) continue;
            return true;
        }
        return false;
    }
}

