/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedbackpacks.init;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import ru.poopycoders.improvedbackpacks.ImprovedBackpacks;
import ru.poopycoders.improvedbackpacks.items.ItemBackpack;
import ru.poopycoders.improvedbackpacks.items.ItemBackpackUpgrade;
import ru.poopycoders.improvedbackpacks.items.ItemEnderBackpack;
import ru.poopycoders.improvedbackpacks.utils.IMetaSerializable;

public class ModItems {
    public static ItemBackpack BACKPACK = new ItemBackpack();
    public static ItemBackpackUpgrade UPGRADE = new ItemBackpackUpgrade();
    public static Item BOUND_LEATHER = new Item().func_77637_a((CreativeTabs)ImprovedBackpacks.creativeTab);
    public static Item TANNED_LEATHER = new Item().func_77637_a((CreativeTabs)ImprovedBackpacks.creativeTab);
    public static Item BLANK_UPGRADE = new Item().func_77637_a((CreativeTabs)ImprovedBackpacks.creativeTab);
    public static ItemEnderBackpack ENDER_BACKPACK = new ItemEnderBackpack();

    public static void init() {
        ModItems.registerItem((Item)BACKPACK, "backpack");
        OreDictionary.registerOre((String)"backpack", (Item)BACKPACK);
        ModItems.registerItem(BOUND_LEATHER, "bound_leather");
        ModItems.registerItem(TANNED_LEATHER, "tanned_leather");
        ModItems.registerItem(BLANK_UPGRADE, "blank_upgrade");
        ModItems.registerItem(UPGRADE, "upgrade");
        ModItems.registerItem((Item)ENDER_BACKPACK, "ender_backpack");
    }

    private static void registerItem(Item item, String name) {
        ForgeRegistries.ITEMS.register(item.func_77655_b(name).setRegistryName(new ResourceLocation("improvedbackpacks", name)));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenders() {
        ModItems.registerItemRender((Item)BACKPACK);
        ModItems.registerItemRender(BOUND_LEATHER);
        ModItems.registerItemRender(TANNED_LEATHER);
        ModItems.registerItemRender(BLANK_UPGRADE);
        ModItems.registerItemRender((Item)ENDER_BACKPACK);
        ModItems.registerItemRenderWithMeta(UPGRADE, ItemBackpackUpgrade.EnumUpgradeType.values());
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemColors() {
        Minecraft.func_71410_x().getItemColors().func_186730_a((backpack, tintIndex) -> {
            if (tintIndex == 0) {
                return ItemBackpack.getColor0(backpack);
            }
            return -1;
        }, new Item[]{BACKPACK});
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerItemRenderWithMeta(Item item, IMetaSerializable[] types) {
        ResourceLocation[] resourceLocations = new ResourceLocation[types.length];
        for (IMetaSerializable type : types) {
            ModItems.registerItemRender(item, type.getMeta(), item.getRegistryName() + "_" + type.func_176610_l());
            resourceLocations[type.getMeta()] = new ResourceLocation(item.getRegistryName() + "_" + type.func_176610_l());
        }
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])resourceLocations);
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerItemRender(Item item, int meta, String fileName) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(fileName, "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerItemRender(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }
}

