/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import java.security.InvalidParameterException;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.api.ToolManager;
import reborncore.common.blocks.BlockWrenchEventHandler;
import reborncore.common.blocks.PropertyString;
import reborncore.common.items.WrenchHelper;
import reborncore.common.multiblock.BlockMultiblockBase;
import reborncore.common.util.ArrayUtils;
import techreborn.init.ModBlocks;
import techreborn.tiles.TileMachineCasing;
import techreborn.utils.TechRebornCreativeTab;

public class BlockMachineCasing
extends BlockMultiblockBase {
    public static final String[] types = new String[]{"standard", "reinforced", "advanced"};
    public static final PropertyString TYPE = new PropertyString("type", types);
    private static final List<String> typesList = Lists.newArrayList((Object[])ArrayUtils.arrayToLowercase((String[])types));

    public BlockMachineCasing() {
        super(Material.field_151573_f);
        this.func_149647_a(TechRebornCreativeTab.instance);
        this.func_149711_c(2.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)"standard")));
        for (int i = 0; i < types.length; ++i) {
            ShootingStar.registerModel((ModelCompound)new ModelCompound("techreborn", (Block)this, i, "machines/structure", new IProperty[0]).setInvVariant("type=" + types[i]));
        }
        BlockWrenchEventHandler.wrenableBlocks.add(this);
    }

    public static ItemStack getStackByName(String name, int count) {
        name = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equalsIgnoreCase(name)) continue;
            return new ItemStack(ModBlocks.MACHINE_CASINGS, count, i);
        }
        throw new InvalidParameterException("The machine casing " + name + " could not be found.");
    }

    public static ItemStack getStackByName(String name) {
        return BlockMachineCasing.getStackByName(name, 1);
    }

    public int getHeatFromState(IBlockState state) {
        switch (this.func_176201_c(state)) {
            case 0: {
                return 40;
            }
            case 1: {
                return 68;
            }
            case 2: {
                return 95;
            }
        }
        return 0;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(EnumHand.MAIN_HAND);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity == null) {
            return false;
        }
        if (!stack.func_190926_b() && ToolManager.INSTANCE.canHandleTool(stack) && WrenchHelper.handleWrench((ItemStack)stack, (World)worldIn, (BlockPos)pos, (EntityPlayer)playerIn, (EnumFacing)side)) {
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    public IBlockState func_176203_a(int meta) {
        if (meta > types.length) {
            meta = 0;
        }
        return this.func_176194_O().func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)((Object)typesList.get(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return typesList.indexOf(state.func_177229_b((IProperty)TYPE));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        for (int meta = 0; meta < types.length; ++meta) {
            list.add((Object)new ItemStack((Block)this, 1, meta));
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileMachineCasing();
    }
}

