/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.tier1;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import org.apache.commons.lang3.tuple.Pair;
import reborncore.api.IToolDrop;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.init.ModBlocks;
import techreborn.init.ModSounds;

@RebornRegistry(modID="techreborn")
public class TileAutoCraftingTable
extends TilePowerAcceptor
implements IToolDrop,
IInventoryProvider,
IContainerProvider {
    @ConfigRegistry(config="machines", category="autocrafter", key="AutoCrafterInput", comment="AutoCrafting Table Max Input (Value in EU)")
    public static int maxInput = 32;
    @ConfigRegistry(config="machines", category="autocrafter", key="AutoCrafterMaxEnergy", comment="AutoCrafting Table Max Energy (Value in EU)")
    public static int maxEnergy = 10000;
    public Inventory inventory = new Inventory(11, "TileAutoCraftingTable", 64, (TileEntity)this);
    public int progress;
    public int maxProgress = 120;
    public int euTick = 10;
    InventoryCrafting inventoryCrafting = null;
    IRecipe lastCustomRecipe = null;
    IRecipe lastRecipe = null;
    public boolean locked = true;

    @Nullable
    public IRecipe getIRecipe() {
        InventoryCrafting crafting = this.getCraftingInventory();
        if (!crafting.func_191420_l()) {
            if (this.lastRecipe != null && this.lastRecipe.func_77569_a(crafting, this.field_145850_b)) {
                return this.lastRecipe;
            }
            for (IRecipe testRecipe : CraftingManager.field_193380_a) {
                if (!testRecipe.func_77569_a(crafting, this.field_145850_b)) continue;
                this.lastRecipe = testRecipe;
                return testRecipe;
            }
        }
        return null;
    }

    public InventoryCrafting getCraftingInventory() {
        if (this.inventoryCrafting == null) {
            this.inventoryCrafting = new InventoryCrafting(new Container(){

                public boolean func_75145_c(EntityPlayer playerIn) {
                    return false;
                }
            }, 3, 3);
        }
        for (int i = 0; i < 9; ++i) {
            this.inventoryCrafting.func_70299_a(i, this.inventory.func_70301_a(i));
        }
        return this.inventoryCrafting;
    }

    public boolean canMake(IRecipe recipe) {
        if (recipe != null && recipe.func_194133_a(3, 3)) {
            boolean missingOutput = false;
            int[] stacksInSlots = new int[9];
            for (int i = 0; i < 9; ++i) {
                stacksInSlots[i] = this.inventory.func_70301_a(i).func_190916_E();
            }
            for (Ingredient ingredient : recipe.func_192400_c()) {
                if (ingredient == Ingredient.field_193370_a) continue;
                boolean foundIngredient = false;
                for (int i = 0; i < 9; ++i) {
                    int requiredSize;
                    ItemStack stack = this.inventory.func_70301_a(i);
                    int n = requiredSize = this.locked ? 1 : 0;
                    if (stack.func_77976_d() == 1) {
                        requiredSize = 0;
                    }
                    if (stacksInSlots[i] <= requiredSize || !ingredient.apply(stack) || stack.func_77973_b().func_77668_q() != null && !this.hasRoomForExtraItem(stack.func_77973_b().getContainerItem(stack))) continue;
                    foundIngredient = true;
                    int n2 = i;
                    stacksInSlots[n2] = stacksInSlots[n2] - 1;
                    break;
                }
                if (foundIngredient) continue;
                missingOutput = true;
            }
            return !missingOutput && this.hasOutputSpace(recipe.func_77571_b(), 9);
        }
        return false;
    }

    boolean hasRoomForExtraItem(ItemStack stack) {
        ItemStack extraOutputSlot = this.func_70301_a(10);
        if (extraOutputSlot.func_190926_b()) {
            return true;
        }
        return this.hasOutputSpace(stack, 10);
    }

    public boolean hasOutputSpace(ItemStack output, int slot) {
        ItemStack stack = this.inventory.func_70301_a(slot);
        if (stack.func_190926_b()) {
            return true;
        }
        return ItemUtils.isItemEqual((ItemStack)stack, (ItemStack)output, (boolean)true, (boolean)true) && stack.func_77976_d() > stack.func_190916_E() + output.func_190916_E();
    }

    public boolean make(IRecipe recipe) {
        if (recipe == null || !this.canMake(recipe)) {
            return false;
        }
        block0: for (int i = 0; i < recipe.func_192400_c().size(); ++i) {
            ItemStack bestSlot;
            Ingredient ingredient = (Ingredient)recipe.func_192400_c().get(i);
            if (ingredient.apply(bestSlot = this.inventory.func_70301_a(i))) {
                this.handleContainerItem(bestSlot);
                bestSlot.func_190918_g(1);
                continue;
            }
            for (int j = 0; j < 9; ++j) {
                ItemStack stack = this.inventory.func_70301_a(j);
                if (!ingredient.apply(stack)) continue;
                this.handleContainerItem(stack);
                stack.func_190918_g(1);
                continue block0;
            }
        }
        ItemStack output = this.inventory.func_70301_a(9);
        ItemStack ouputStack = recipe.func_77572_b(this.getCraftingInventory());
        if (output.func_190926_b()) {
            this.inventory.func_70299_a(9, ouputStack.func_77946_l());
        } else {
            output.func_190917_f(recipe.func_77571_b().func_190916_E());
        }
        return true;
    }

    private void handleContainerItem(ItemStack stack) {
        if (stack.func_77973_b().hasContainerItem(stack)) {
            ItemStack containerItem = stack.func_77973_b().getContainerItem(stack);
            ItemStack extraOutputSlot = this.func_70301_a(10);
            if (this.hasOutputSpace(containerItem, 10)) {
                if (extraOutputSlot.func_190926_b()) {
                    this.func_70299_a(10, containerItem.func_77946_l());
                } else if (ItemUtils.isItemEqual((ItemStack)extraOutputSlot, (ItemStack)containerItem, (boolean)true, (boolean)true) && extraOutputSlot.func_77976_d() < extraOutputSlot.func_190916_E() + containerItem.func_190916_E()) {
                    extraOutputSlot.func_190917_f(1);
                }
            }
        }
    }

    public boolean hasIngredient(Ingredient ingredient) {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (!ingredient.apply(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isItemValidForRecipeSlot(IRecipe recipe, ItemStack stack, int slotID) {
        if (recipe == null) {
            return true;
        }
        int bestSlot = this.findBestSlotForStack(recipe, stack);
        if (bestSlot != -1) {
            return bestSlot == slotID;
        }
        return true;
    }

    public int findBestSlotForStack(IRecipe recipe, ItemStack stack) {
        if (recipe == null) {
            return -1;
        }
        ArrayList<Integer> possibleSlots = new ArrayList<Integer>();
        for (int i = 0; i < recipe.func_192400_c().size(); ++i) {
            ItemStack stackInSlot = this.inventory.func_70301_a(i);
            Ingredient ingredient = (Ingredient)recipe.func_192400_c().get(i);
            if (ingredient == Ingredient.field_193370_a || !ingredient.apply(stack)) continue;
            if (stackInSlot.func_190926_b()) {
                possibleSlots.add(i);
                continue;
            }
            if (stackInSlot.func_77973_b() != stack.func_77973_b() || stackInSlot.func_77952_i() != stack.func_77952_i() || stackInSlot.func_77976_d() < stackInSlot.func_190916_E() + stack.func_190916_E()) continue;
            possibleSlots.add(i);
        }
        Pair smallestCount = null;
        for (Integer slot : possibleSlots) {
            ItemStack slotStack = this.inventory.func_70301_a(slot.intValue());
            if (slotStack.func_190926_b()) {
                return slot;
            }
            if (smallestCount == null) {
                smallestCount = Pair.of((Object)slot, (Object)slotStack.func_190916_E());
                continue;
            }
            if ((Integer)smallestCount.getRight() < slotStack.func_190916_E()) continue;
            smallestCount = Pair.of((Object)slot, (Object)slotStack.func_190916_E());
        }
        if (smallestCount != null) {
            return (Integer)smallestCount.getLeft();
        }
        return -1;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getMaxProgress() {
        if (this.maxProgress == 0) {
            this.maxProgress = 1;
        }
        return this.maxProgress;
    }

    public void setMaxProgress(int maxProgress) {
        this.maxProgress = maxProgress;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        IRecipe recipe = this.getIRecipe();
        if (recipe != null) {
            if (this.progress >= this.maxProgress) {
                if (this.make(recipe)) {
                    this.progress = 0;
                }
            } else if (this.canMake(recipe)) {
                if (this.canUseEnergy(this.euTick)) {
                    ++this.progress;
                    if (this.progress == 1) {
                        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), ModSounds.AUTO_CRAFTING, SoundCategory.BLOCKS, 0.3f, 0.8f);
                    }
                    this.useEnergy(this.euTick);
                }
            } else {
                this.progress = 0;
            }
        }
        if (recipe == null) {
            this.progress = 0;
        }
    }

    public int getLockedInt() {
        return this.locked ? 1 : 0;
    }

    public void setLockedInt(int lockedInt) {
        this.locked = lockedInt == 1;
    }

    public double getBaseMaxPower() {
        return maxEnergy;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return maxInput;
    }

    public boolean canAcceptEnergy(EnumFacing enumFacing) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing enumFacing) {
        return false;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74757_a("locked", this.locked);
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        if (tag.func_74764_b("locked")) {
            this.locked = tag.func_74767_n("locked");
        }
        super.func_145839_a(tag);
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        int bestSlot = this.findBestSlotForStack(this.getIRecipe(), stack);
        if (bestSlot != -1) {
            return index == bestSlot;
        }
        return super.func_94041_b(index, stack);
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        if (index > 8) {
            return false;
        }
        int bestSlot = this.findBestSlotForStack(this.getIRecipe(), stack);
        if (bestSlot != -1) {
            return index == bestSlot;
        }
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index > 8;
    }

    public EnumFacing getFacingEnum() {
        return EnumFacing.NORTH;
    }

    public ItemStack getToolDrop(EntityPlayer playerIn) {
        return new ItemStack(ModBlocks.AUTO_CRAFTING_TABLE, 1);
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("autocraftingtable").player(player.field_71071_by).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 28, 25).slot(1, 46, 25).slot(2, 64, 25).slot(3, 28, 43).slot(4, 46, 43).slot(5, 64, 43).slot(6, 28, 61).slot(7, 46, 61).slot(8, 64, 61).outputSlot(9, 145, 42).outputSlot(10, 145, 70).syncEnergyValue().syncIntegerValue(this::getProgress, this::setProgress).syncIntegerValue(this::getMaxProgress, this::setMaxProgress).syncIntegerValue(this::getLockedInt, this::setLockedInt).addInventory().create((TileLegacyMachineBase)this);
    }

    public boolean hasSlotConfig() {
        return false;
    }
}

