/*
 * Decompiled with CFR 0.152.
 */
package csokicraft.forge.modernmods.modernconv;

import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.MjAPI;
import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import com.raoulvdberge.refinedstorage.capability.CapabilityNetworkNodeProxy;
import csokicraft.forge.modernmods.modernconv.EnergyIOCapability;
import csokicraft.forge.modernmods.modernconv.compat.ModernConvRatios;
import csokicraft.forge.modernmods.modernconv.compat.ModernProxyCapabilityFE;
import csokicraft.forge.modernmods.modernconv.compat.ModernProxyCapabilityMJ;
import csokicraft.forge.modernmods.modernconv.compat.ModernProxyCapabilityTesla;
import csokicraft.forge.modernmods.modernconv.compat.ModernProxyRefStorage;
import csokicraft.forge.modernmods.moderncraft.api.IModernWrenchable;
import csokicraft.forge.modernmods.moderncraft.api.ModernMachineRegistry;
import csokicraft.forge.modernmods.moderncraft.api.capability.IModernEnergyCapability;
import csokicraft.forge.modernmods.moderncraft.api.capability.ModernCapabilities;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="ic2"), @Optional.Interface(iface="cofh.redstoneflux.api.IEnergyProvider", modid="redstoneflux"), @Optional.Interface(iface="cofh.redstoneflux.api.IEnergyReceiver", modid="redstoneflux")})
public class TileEntityEnergyIO
extends TileEntity
implements IModernWrenchable,
ITickable,
IEnergySink,
IEnergySource,
IEnergyProvider,
IEnergyReceiver {
    protected boolean importMode = false;
    protected boolean load = true;
    protected IModernEnergyCapability cap = new EnergyIOCapability(100000, this);
    private int tier = 0;

    public TileEntityEnergyIO() {
        ModernMachineRegistry.inst.getNetFor(this.cap);
    }

    public void func_73660_a() {
        if (this.load) {
            if (ModernConvRatios.CompatMods.IC2.isLoaded()) {
                this.addIC2();
            }
            this.load = false;
        }
        if (!this.func_145831_w().field_72995_K) {
            if (this.importMode) {
                this.cap.getParent().announceSurplus(this.cap.getEnergy(), this.cap);
            } else {
                this.pushRF();
                if (ModernConvRatios.CompatMods.BUILDCRAFT.isLoaded()) {
                    this.pushMJ();
                }
                this.cap.getParent().announceCapacity(this.cap.getEnergyCapacity() - this.cap.getEnergy(), this.cap);
            }
        }
    }

    private void pushRF() {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            Object proxy;
            ITeslaConsumer other;
            BlockPos adj = this.func_174877_v().func_177972_a(dir);
            TileEntity te = this.func_145831_w().func_175625_s(adj);
            if (te == null) continue;
            if (ModernConvRatios.CompatMods.TESLA.isLoaded() && te.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, dir.func_176734_d())) {
                other = (ITeslaConsumer)te.getCapability(TeslaCapabilities.CAPABILITY_CONSUMER, dir.func_176734_d());
                proxy = this.getTeslaProxy();
                long taken = other.givePower(((ModernProxyCapabilityTesla)proxy).getStoredPower(), false);
                ((ModernProxyCapabilityTesla)proxy).takePower(taken, false);
                continue;
            }
            if (te.hasCapability(CapabilityEnergy.ENERGY, dir.func_176734_d())) {
                other = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, dir.func_176734_d());
                proxy = this.getForgeEnergyProxy();
                int taken = other.receiveEnergy(((ModernProxyCapabilityFE)proxy).getEnergyStored(), false);
                ((ModernProxyCapabilityFE)proxy).extractEnergy(taken, false);
                continue;
            }
            if (!ModernConvRatios.CompatMods.COFH_RF.isLoaded() || !(te instanceof IEnergyReceiver)) continue;
            other = (IEnergyReceiver)te;
            proxy = this.getForgeEnergyProxy();
            int taken = other.receiveEnergy(dir, ((ModernProxyCapabilityFE)proxy).getEnergyStored(), false);
            ((ModernProxyCapabilityFE)proxy).extractEnergy(taken, false);
        }
    }

    public boolean onWrenchClicked(EntityPlayer p, ItemStack is, IModernWrenchable.MouseButton btn, boolean shift, EnumHand hand) {
        if (btn == IModernWrenchable.MouseButton.RIGHT_CLICK) {
            if (!shift) {
                this.importMode = !this.importMode;
                p.func_145747_a((ITextComponent)new TextComponentString("Import mode:" + this.importMode));
                if (ModernConvRatios.CompatMods.IC2.isLoaded()) {
                    this.removeIC2();
                    this.addIC2();
                }
            } else {
                this.func_145831_w().func_175655_b(this.func_174877_v(), true);
            }
        } else if (btn == IModernWrenchable.MouseButton.LEFT_CLICK) {
            ++this.tier;
            if (this.tier > 4) {
                this.tier = 0;
            }
            if (ModernConvRatios.CompatMods.IC2.isLoaded()) {
                this.removeIC2();
                this.addIC2();
            }
            p.func_145747_a((ITextComponent)new TextComponentString("Tier set to " + this.tier));
        }
        return true;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (ModernConvRatios.CompatMods.TESLA.isLoaded() && this.isTeslaCapability(capability)) {
            return (T)this.getTeslaProxy();
        }
        if (ModernConvRatios.CompatMods.REFSTORAGE.isLoaded() && this.isRefStorageCapability(capability)) {
            return (T)this.getRefStorageNodeProxy();
        }
        if (ModernConvRatios.CompatMods.BUILDCRAFT.isLoaded() && this.isBuildCraftMjCapability(capability)) {
            return (T)this.getBuildCraftMjProxy();
        }
        if (this.isForgeEnergyCapability(capability)) {
            return (T)this.getForgeEnergyProxy();
        }
        if (capability == ModernCapabilities.WRENCHABLE) {
            return (T)((Object)this);
        }
        if (capability == ModernCapabilities.ENERGY) {
            return (T)this.cap;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (ModernConvRatios.CompatMods.TESLA.isLoaded() && this.isTeslaCapability(capability)) {
            return true;
        }
        if (ModernConvRatios.CompatMods.REFSTORAGE.isLoaded() && this.isRefStorageCapability(capability)) {
            return true;
        }
        if (ModernConvRatios.CompatMods.BUILDCRAFT.isLoaded() && this.isBuildCraftMjCapability(capability)) {
            return true;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        if (capability == ModernCapabilities.WRENCHABLE) {
            return true;
        }
        if (capability == ModernCapabilities.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("machine", ModernCapabilities.STORAGE_ENERGY.writeNBT(ModernCapabilities.ENERGY, (Object)this.cap, null));
        compound.func_74780_a("tier", (double)this.tier);
        compound.func_74757_a("import", this.importMode);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("tier")) {
            this.tier = compound.func_74762_e("tier");
        }
        if (compound.func_74764_b("import")) {
            this.importMode = compound.func_74767_n("import");
        }
        ModernCapabilities.STORAGE_ENERGY.readNBT(ModernCapabilities.ENERGY, (Object)this.cap, null, (NBTBase)compound.func_74775_l("machine"));
    }

    protected double getMaxIn() {
        return Math.pow(10.0, this.tier);
    }

    protected double getMaxOut() {
        return 3.2 * Math.pow(2.0, this.tier);
    }

    protected ModernProxyCapabilityFE getForgeEnergyProxy() {
        return ModernProxyCapabilityFE.forTile(this.cap);
    }

    private boolean isForgeEnergyCapability(Capability<?> capability) {
        return capability == CapabilityEnergy.ENERGY;
    }

    @Optional.Method(modid="tesla")
    private boolean isTeslaCapability(Capability<?> capability) {
        if (this.importMode) {
            return capability == TeslaCapabilities.CAPABILITY_CONSUMER || capability == TeslaCapabilities.CAPABILITY_HOLDER;
        }
        return capability == TeslaCapabilities.CAPABILITY_PRODUCER || capability == TeslaCapabilities.CAPABILITY_HOLDER;
    }

    @Optional.Method(modid="tesla")
    protected ModernProxyCapabilityTesla getTeslaProxy() {
        return ModernProxyCapabilityTesla.forTile(this.cap);
    }

    @Optional.Method(modid="ic2")
    private void removeIC2() {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        }
    }

    @Optional.Method(modid="ic2")
    private void addIC2() {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
        }
    }

    public void onChunkUnload() {
        if (ModernConvRatios.CompatMods.IC2.isLoaded()) {
            this.removeIC2();
        }
        super.onChunkUnload();
    }

    public void func_145843_s() {
        if (ModernConvRatios.CompatMods.IC2.isLoaded()) {
            this.removeIC2();
        }
        super.func_145843_s();
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return emitter != this && this.cap.canProvideEnergy();
    }

    @Optional.Method(modid="ic2")
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return receiver != this && this.cap.canReceiveEnergy();
    }

    @Optional.Method(modid="ic2")
    public double getOfferedEnergy() {
        return this.cap.removeEnergy(this.cap.getEnergy(), false) * ModernConvRatios.toEU;
    }

    @Optional.Method(modid="ic2")
    public void drawEnergy(double amount) {
        this.cap.removeEnergy(amount / ModernConvRatios.toEU, true);
    }

    @Optional.Method(modid="ic2")
    public int getSourceTier() {
        return this.tier + 1;
    }

    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        return this.cap.addEnergy(this.cap.getEnergyCapacity() - this.cap.getEnergy(), false) * ModernConvRatios.toEU;
    }

    @Optional.Method(modid="ic2")
    public int getSinkTier() {
        return 5;
    }

    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        double coulombVolts = amount / ModernConvRatios.toEU;
        double takenEU = this.cap.addEnergy(coulombVolts, true) * ModernConvRatios.toEU;
        return amount - takenEU;
    }

    @Optional.Method(modid="refinedstorage")
    private boolean isRefStorageCapability(Capability<?> capability) {
        return capability == CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY;
    }

    @Optional.Method(modid="refinedstorage")
    protected ModernProxyRefStorage getRefStorageNodeProxy() {
        return ModernProxyRefStorage.forTile(this, this.cap);
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(EnumFacing from) {
        return Double.valueOf(this.cap.getEnergy() * ModernConvRatios.toRF).intValue();
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(EnumFacing from) {
        return Double.valueOf(this.cap.getEnergyCapacity() * ModernConvRatios.toRF).intValue();
    }

    @Optional.Method(modid="redstoneflux")
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return Double.valueOf(this.cap.addEnergy((double)maxReceive / ModernConvRatios.toRF, !simulate) * ModernConvRatios.toRF).intValue();
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return Double.valueOf(this.cap.removeEnergy((double)maxExtract / ModernConvRatios.toRF, !simulate) * ModernConvRatios.toRF).intValue();
    }

    @Optional.Method(modid="buildcraftlib")
    private boolean isBuildCraftMjCapability(Capability<?> cap) {
        return MjAPI.CAP_CONNECTOR.equals(cap) || MjAPI.CAP_RECEIVER.equals(cap) || MjAPI.CAP_READABLE.equals(cap) || MjAPI.CAP_PASSIVE_PROVIDER.equals(cap);
    }

    @Optional.Method(modid="buildcraftlib")
    protected ModernProxyCapabilityMJ getBuildCraftMjProxy() {
        return ModernProxyCapabilityMJ.forTile(this.cap);
    }

    @Optional.Method(modid="buildcraftlib")
    private void pushMJ() {
        ModernProxyCapabilityMJ prov = this.getBuildCraftMjProxy();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(side));
            if (te == null || !te.hasCapability(MjAPI.CAP_RECEIVER, side.func_176734_d())) continue;
            IMjReceiver rec = (IMjReceiver)te.getCapability(MjAPI.CAP_RECEIVER, side.func_176734_d());
            long avail = prov.extractPower(0L, rec.getPowerRequested(), true);
            long remain = rec.receivePower(avail, false);
            prov.extractPower(avail -= remain, avail, false);
        }
    }
}

