/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.materials.Material;
import lucraft.mods.lucraftcore.module.Module;
import lucraft.mods.lucraftcore.network.AbstractClientMessageHandler;
import lucraft.mods.lucraftcore.network.AbstractServerMessageHandler;
import lucraft.mods.lucraftcore.network.LCPacketDispatcher;
import lucraft.mods.lucraftcore.util.abilitybar.AbilityBarPos;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Config(modid="lucraftcore")
public class LCConfig {
    public static Modules modules = new Modules();
    public static Materials materials = new Materials();
    public static Superpowers superpowers = new Superpowers();
    public static SizeChanging sizeChanging = new SizeChanging();
    public static Infinity infinity = new Infinity();
    public static AdvancedCombat ac = new AdvancedCombat();
    @Config.RequiresMcRestart
    public static boolean updateChecker = true;
    public static AbilityBarPos abilityBar = AbilityBarPos.LEFT;
    public static boolean abilityBarScrolling = true;
    @Config.RequiresMcRestart
    @Config.Comment(value={"When enabled the limit of the armor attribute (which is 30 by default) increases to 1024"})
    public static boolean increaseArmorLimit = true;
    @Config.RequiresMcRestart
    public static boolean overrideLocateCommand = true;

    public static class MessageSendModuleSettings
    implements IMessage {
        public String modules = modules.moduleSettingsToString();

        public void fromBytes(ByteBuf buf) {
            this.modules = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.modules);
        }

        public static class Handler
        extends AbstractServerMessageHandler<MessageSendModuleSettings> {
            @Override
            public IMessage handleServerMessage(EntityPlayer player, MessageSendModuleSettings message, MessageContext ctx) {
                LucraftCore.proxy.getThreadFromContext(ctx).func_152344_a(() -> {
                    if (message.modules.equalsIgnoreCase(LCConfig.modules.moduleSettingsToString())) {
                        MessageSyncConfig message1 = new MessageSyncConfig();
                        message1.disabledAbilities = LCConfig.superpowers.disabledAbilities;
                        message1.nameChangeEffect = LCConfig.superpowers.nameChangeEffect;
                        LCPacketDispatcher.sendTo(message1, (EntityPlayerMP)player);
                    } else {
                        String s = LCConfig.modules.moduleSettingsToString();
                        TextComponentTranslation text = new TextComponentTranslation("lucraftcore.info.modulesettingswrong", new Object[0]);
                        text.func_150258_a("\n");
                        for (String module : s.split(",")) {
                            TextComponentString t = new TextComponentString(module.replace(":", ": ") + "\n");
                            text.func_150257_a((ITextComponent)t);
                        }
                        ((EntityPlayerMP)player).field_71135_a.func_194028_b((ITextComponent)text);
                    }
                });
                return null;
            }
        }
    }

    public static class MessageSyncConfig
    implements IMessage {
        public String[] disabledAbilities;
        public boolean nameChangeEffect;

        public void fromBytes(ByteBuf buf) {
            int i;
            NBTTagCompound nbt = ByteBufUtils.readTag((ByteBuf)buf);
            ArrayList<String> list = new ArrayList<String>();
            NBTTagList nbttaglist = nbt.func_150295_c("DisabledAbilities", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                list.add(((NBTTagString)nbttaglist.func_179238_g(i)).func_150285_a_());
            }
            this.disabledAbilities = new String[list.size()];
            for (i = 0; i < list.size(); ++i) {
                this.disabledAbilities[i] = (String)list.get(i);
            }
            this.nameChangeEffect = nbt.func_74767_n("NameChange");
        }

        public void toBytes(ByteBuf buf) {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.disabledAbilities.length; ++i) {
                nbttaglist.func_74742_a((NBTBase)new NBTTagString(this.disabledAbilities[i]));
            }
            nbt.func_74782_a("DisabledAbilities", (NBTBase)nbttaglist);
            nbt.func_74757_a("NameChange", this.nameChangeEffect);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt);
        }

        public static class Handler
        extends AbstractClientMessageHandler<MessageSyncConfig> {
            @Override
            public IMessage handleClientMessage(EntityPlayer player, MessageSyncConfig message, MessageContext ctx) {
                LucraftCore.proxy.getThreadFromContext(ctx).func_152344_a(() -> {
                    LCConfig.superpowers.disabledAbilities = message.disabledAbilities;
                    ClientConfig.nameChangeEffect = message.nameChangeEffect;
                });
                return null;
            }
        }
    }

    public static class ClientConfig {
        public static boolean nameChangeEffect;
    }

    @Mod.EventBusSubscriber(modid="lucraftcore")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("lucraftcore")) {
                ConfigManager.sync((String)"lucraftcore", (Config.Type)Config.Type.INSTANCE);
            }
        }

        @SubscribeEvent
        public static void onJoinWorld(EntityJoinWorldEvent event) {
            if (event.getEntity() instanceof EntityPlayer && event.getEntity().field_70170_p.field_72995_K) {
                LCPacketDispatcher.sendToServer(new MessageSendModuleSettings());
            }
        }
    }

    public static class AdvancedCombat {
        public String[] disabledGrabEntities = new String[]{"modid:mobname"};
    }

    public static class Infinity {
        @Config.Comment(value={"This allows the Infinity Gauntlet to be made in an anvil"})
        public boolean anvilCrafting = true;
        @Config.RequiresMcRestart
        @Config.Comment(value={"If enabled you can make the Infinity Gauntlet in a Tinkers Construct smeltery or ThermalExpansion Fluid Transposer"})
        public boolean modCrafting = true;
        @Config.Comment(value={"If enabled the anvil crafting for the Infinity Gauntlet will get disabled if Tinkers Construct/ThermalExpansion is installed"})
        public boolean disableAnvilWithMods = true;
        @Config.RequiresMcRestart
        @Config.Comment(value={"If enabled you will be able to find Infinity Gauntlet Casts in villages"})
        public boolean gauntletCastGeneration = true;
    }

    public static class SizeChanging {
        @Config.RequiresWorldRestart
        public String[] entityBlackList = new String[]{"modid:example_entity"};
        public boolean changeShadowSizes = true;

        public static boolean isEntityBlacklisted(EntityLivingBase entity) {
            EntityEntry entry = null;
            for (EntityEntry entries : ForgeRegistries.ENTITIES) {
                if (entries.getEntityClass() != entity.getClass()) continue;
                entry = entries;
                break;
            }
            if (entry == null) {
                return false;
            }
            for (String s : LCConfig.sizeChanging.entityBlackList) {
                if (!s.equalsIgnoreCase(entry.getRegistryName().toString())) continue;
                return true;
            }
            return false;
        }
    }

    public static class Superpowers {
        @Config.RequiresWorldRestart
        public String[] disabledAbilities = new String[]{"modid:example_ability"};
        @Config.Comment(value={"If enabled, server owners can specify superpower players can choose when they first join the server"})
        public boolean startSuperpowersEnabled = false;
        public String[] startSuperpowers = new String[]{"modid:example_superpower"};
        @Config.RequiresWorldRestart
        public boolean nameChangeEffect = true;
    }

    public static class OreSettings {
        @Config.RangeInt(min=0)
        public int maxVeinSize;
        @Config.RangeInt(min=0)
        public int minVeinSize;
        @Config.RangeInt(min=0)
        public int chance;
        @Config.RangeInt(min=0)
        public int minY;
        @Config.RangeInt(min=0)
        public int maxY;

        public OreSettings(Material m) {
            this(m.getMinVeinSize(), m.getMaxVeinSize(), m.getChance(), m.getMinY(), m.getMaxY());
        }

        public OreSettings(int minVeinSize, int maxVeinSize, int chance, int minY, int maxY) {
            this.minVeinSize = minVeinSize;
            this.maxVeinSize = maxVeinSize;
            this.chance = chance;
            this.minY = minY;
            this.maxY = maxY;
        }
    }

    public static class Materials {
        @Config.Comment(value={"Values: minimun vein size, maximum vein size, chance, min Y, max Y"})
        public Map<String, int[]> ore_settings = new HashMap<String, int[]>();
        @Config.RangeInt(min=0, max=20)
        public int meteorite_chance = 3;
        @Config.Comment(value={"If enabled you will get a radiation effect when you carry uranium items or if you are near uranium stuff"})
        public boolean radiation = true;

        public Materials() {
            Material.init();
            for (Material m : Material.getMaterials()) {
                if (!m.generateOre()) continue;
                int[] array = new int[]{m.getMinVeinSize(), m.getMaxVeinSize(), m.getChance(), m.getMinY(), m.getMaxY()};
                this.ore_settings.put(m.getResourceName(), array);
            }
        }
    }

    public static class Modules {
        @Config.RequiresMcRestart
        public boolean materials = true;
        @Config.RequiresMcRestart
        public boolean superpowers = true;
        @Config.RequiresMcRestart
        public boolean extended_inventory = true;
        @Config.RequiresMcRestart
        public boolean size_changing = true;
        @Config.RequiresMcRestart
        public boolean karma = true;
        @Config.RequiresMcRestart
        public boolean infinity = true;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Requires superpower module"})
        public boolean advanced_combat = true;

        public static String moduleSettingsToString() {
            Iterator it = LucraftCore.MODULES.iterator();
            String s = "";
            while (it.hasNext()) {
                Module m = (Module)it.next();
                s = s + m.getName() + ":" + m.isEnabled() + ",";
            }
            return s;
        }
    }
}

