/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import lucraft.mods.lucraftcore.LucraftCore;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="lucraftcore")
public class SupporterHandler {
    private static final String SUPPORTER_FILE = "https://drive.google.com/uc?export=download&id=19iN_yzXWHhn5SfM5GJ-Q1ST5bOtFe8fE";
    private static RegistryNamespaced<UUID, SupporterData> REGISTRY = new RegistryNamespaced();
    private static boolean CHECK = false;

    public static void load() {
        try {
            JsonObject json = SupporterHandler.readJsonFromUrl(SUPPORTER_FILE);
            JsonArray array = JsonUtils.func_151214_t((JsonObject)json, (String)"supporters");
            for (int i = 0; i < array.size(); ++i) {
                JsonObject obj = array.get(i).getAsJsonObject();
                UUID uuid = UUID.fromString(JsonUtils.func_151200_h((JsonObject)obj, (String)"uuid"));
                String name = JsonUtils.func_151200_h((JsonObject)obj, (String)"name");
                NBTTagCompound nbt = JsonToNBT.func_180713_a((String)obj.toString());
                SupporterData data = new SupporterData(uuid, name, JsonUtils.func_151209_a((JsonObject)obj, (String)"access", (boolean)false), nbt);
                REGISTRY.func_177775_a(i, (Object)uuid, (Object)data);
            }
            LucraftCore.LOGGER.info("Successfully read supporter information file!");
        }
        catch (Exception e) {
            LucraftCore.LOGGER.error("Was not able to read supporter information file!");
            e.printStackTrace();
            SupporterHandler.addDefaultData();
            LucraftCore.LOGGER.error("Loaded default supporter data!");
        }
    }

    private static void addDefaultData() {
        REGISTRY.func_177775_a(0, (Object)UUID.fromString("0669d99d-b34d-40fc-a4d8-c7ee963cc842"), (Object)new SupporterData(UUID.fromString("0669d99d-b34d-40fc-a4d8-c7ee963cc842"), "TheLucraft", true, new NBTTagCompound()));
        REGISTRY.func_177775_a(1, (Object)UUID.fromString("70e36bc3-f6d5-406b-924c-46d5c5f52101"), (Object)new SupporterData(UUID.fromString("70e36bc3-f6d5-406b-924c-46d5c5f52101"), "Neon", true, new NBTTagCompound()));
        REGISTRY.func_177775_a(2, (Object)UUID.fromString("3fa3dc7d-3de2-4ba1-a0ca-adc57bf0827d"), (Object)new SupporterData(UUID.fromString("3fa3dc7d-3de2-4ba1-a0ca-adc57bf0827d"), "Sheriff", true, new NBTTagCompound()));
        REGISTRY.func_177775_a(3, (Object)UUID.fromString("fa396f29-9e23-479b-93a5-43e0780f1453"), (Object)new SupporterData(UUID.fromString("fa396f29-9e23-479b-93a5-43e0780f1453"), "Nictogen", true, new NBTTagCompound()));
        REGISTRY.func_177775_a(4, (Object)UUID.fromString("7400ab2f-0980-453a-a945-0bafe6cba8cc"), (Object)new SupporterData(UUID.fromString("7400ab2f-0980-453a-a945-0bafe6cba8cc"), "Spyeedy", true, new NBTTagCompound()));
        REGISTRY.func_177775_a(5, (Object)UUID.fromString("13b07ab0-663e-456d-98fa-debdb8a3777b"), (Object)new SupporterData(UUID.fromString("13b07ab0-663e-456d-98fa-debdb8a3777b"), "HydroSimp", true, new NBTTagCompound()));
        REGISTRY.func_177775_a(6, (Object)UUID.fromString("bc8b891e-5c25-4c9f-ae61-cdfb270f1cc1"), (Object)new SupporterData(UUID.fromString("bc8b891e-5c25-4c9f-ae61-cdfb270f1cc1"), "SubPai", true, new NBTTagCompound()));
        REGISTRY.func_177775_a(7, (Object)UUID.fromString("ab572785-66d7-4f5f-b9d4-2a3a68fb9d1a"), (Object)new SupporterData(UUID.fromString("ab572785-66d7-4f5f-b9d4-2a3a68fb9d1a"), "Honeyluck", true, new NBTTagCompound()));
    }

    public static void enableSupporterCheck() {
        CHECK = true;
        LucraftCore.LOGGER.info("The supporter check has been enabled!");
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onWorldJoin(EntityJoinWorldEvent e) {
        if (CHECK && e.getEntity() == Minecraft.func_71410_x().field_71439_g && (SupporterHandler.getSupporterData((EntityPlayer)Minecraft.func_71410_x().field_71439_g) == null || !SupporterHandler.getSupporterData((EntityPlayer)Minecraft.func_71410_x().field_71439_g).modAccess)) {
            LucraftCore.LOGGER.error("You are not allowed to play this version of the mod!");
            int n = 5 / 0;
        }
    }

    public static SupporterData getSupporterData(EntityPlayer player) {
        if (REGISTRY.func_148741_d((Object)player.func_146103_bH().getId())) {
            return (SupporterData)REGISTRY.func_82594_a((Object)player.func_146103_bH().getId());
        }
        return null;
    }

    public static SupporterData getSupporterData(UUID uuid) {
        return (SupporterData)REGISTRY.func_82594_a((Object)uuid);
    }

    public static List<UUID> getUUIDs() {
        return ImmutableList.copyOf((Collection)REGISTRY.func_148742_b());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonObject readJsonFromUrl(String url) throws IOException {
        try (InputStream is = new URL(url).openStream();){
            JsonObject json;
            BufferedReader rd = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            JsonObject jsonObject = json = new JsonParser().parse((Reader)rd).getAsJsonObject();
            return jsonObject;
        }
    }

    public static class SupporterData {
        protected UUID owner;
        protected String name;
        protected boolean modAccess;
        protected NBTTagCompound nbt;

        public SupporterData(UUID owner, String name, boolean modAccess, NBTTagCompound nbt) {
            this.owner = owner;
            this.name = name;
            this.modAccess = modAccess;
            this.nbt = nbt;
        }

        public UUID getOwner() {
            return this.owner;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasModAccess() {
            return this.modAccess;
        }

        public NBTTagCompound getNbt() {
            return this.nbt;
        }
    }
}

