/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.karma.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.karma.capabilities.CapabilityKarma;
import lucraft.mods.lucraftcore.karma.gui.GuiKarma;
import lucraft.mods.lucraftcore.network.AbstractClientMessageHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSyncKarma
implements IMessage {
    public UUID playerUUID;
    public NBTTagCompound nbt;
    public boolean openGui;

    public MessageSyncKarma() {
    }

    public MessageSyncKarma(EntityPlayer player) {
        this.playerUUID = player.getPersistentID();
        this.nbt = (NBTTagCompound)CapabilityKarma.KARMA_CAP.getStorage().writeNBT(CapabilityKarma.KARMA_CAP, player.getCapability(CapabilityKarma.KARMA_CAP, null), null);
        this.openGui = false;
    }

    public MessageSyncKarma(EntityPlayer player, boolean openGui) {
        this(player);
        this.openGui = openGui;
    }

    public void fromBytes(ByteBuf buf) {
        this.playerUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.nbt = ByteBufUtils.readTag((ByteBuf)buf);
        this.openGui = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerUUID.toString());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbt);
        buf.writeBoolean(this.openGui);
    }

    public static class Handler
    extends AbstractClientMessageHandler<MessageSyncKarma> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, final MessageSyncKarma message, final MessageContext ctx) {
            LucraftCore.proxy.getThreadFromContext(ctx).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayer en;
                    if (message != null && ctx != null && (en = LucraftCore.proxy.getPlayerEntity((MessageContext)ctx).field_70170_p.func_152378_a(message.playerUUID)) != null) {
                        CapabilityKarma.KARMA_CAP.getStorage().readNBT(CapabilityKarma.KARMA_CAP, en.getCapability(CapabilityKarma.KARMA_CAP, null), null, (NBTBase)message.nbt);
                        if (message.openGui) {
                            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiKarma());
                        }
                    }
                }
            });
            return null;
        }
    }
}

