/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.materials.blocks;

import java.util.HashMap;
import java.util.Map;
import lucraft.mods.lucraftcore.materials.Material;
import lucraft.mods.lucraftcore.materials.ModuleMaterials;
import lucraft.mods.lucraftcore.materials.blocks.BlockLCMaterial;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MaterialsBlocks {
    public static Map<Material, BlockLCMaterial> ORES = new HashMap<Material, BlockLCMaterial>();
    public static Map<Material, BlockLCMaterial> BLOCKS = new HashMap<Material, BlockLCMaterial>();

    @SubscribeEvent
    public void onRegisterBlocks(RegistryEvent.Register<Block> e) {
        for (Material m : Material.getMaterials()) {
            if (m.autoGenerateComponent(Material.MaterialComponent.ORE)) {
                BlockLCMaterial oreBlock = new BlockLCMaterial(m, Material.MaterialComponent.ORE);
                ORES.put(m, oreBlock);
                e.getRegistry().register((IForgeRegistryEntry)oreBlock);
                ModuleMaterials.chiselsAndBitsBlocks.add(oreBlock.func_176223_P());
            }
            if (!m.autoGenerateComponent(Material.MaterialComponent.BLOCK)) continue;
            BlockLCMaterial blockBlock = new BlockLCMaterial(m, Material.MaterialComponent.BLOCK);
            BLOCKS.put(m, blockBlock);
            e.getRegistry().register((IForgeRegistryEntry)blockBlock);
            ModuleMaterials.chiselsAndBitsBlocks.add(blockBlock.func_176223_P());
        }
    }

    @SubscribeEvent
    public void onRegisterItems(RegistryEvent.Register<Item> e) {
        for (BlockLCMaterial blocks : ORES.values()) {
            e.getRegistry().register(new ItemBlock((Block)blocks).setRegistryName(blocks.getRegistryName()));
        }
        for (BlockLCMaterial blocks : BLOCKS.values()) {
            e.getRegistry().register(new ItemBlock((Block)blocks).setRegistryName(blocks.getRegistryName()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRegisterModels(ModelRegistryEvent e) {
        for (BlockLCMaterial blocks : ORES.values()) {
            ModelLoader.setCustomStateMapper((Block)blocks, (IStateMapper)new LCBlockMapper(blocks));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)blocks), (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("lucraftcore", "ore"), "type=" + blocks.field_149764_J.getResourceName()));
        }
        for (BlockLCMaterial blocks : BLOCKS.values()) {
            ModelLoader.setCustomStateMapper((Block)blocks, (IStateMapper)new LCBlockMapper(blocks));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)blocks), (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("lucraftcore", "block"), "type=" + blocks.field_149764_J.getResourceName()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class LCBlockMapper
    extends StateMapperBase {
        public BlockLCMaterial block;

        public LCBlockMapper(BlockLCMaterial block) {
            this.block = block;
        }

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            return new ModelResourceLocation(new ResourceLocation("lucraftcore", this.block.component.getName()), "type=" + this.block.field_149764_J.getResourceName());
        }
    }
}

