/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.materials.integration;

import java.util.ArrayList;
import java.util.List;
import lucraft.mods.lucraftcore.materials.Material;
import lucraft.mods.lucraftcore.materials.integration.TraitSuperHeavy;
import lucraft.mods.lucraftcore.util.helper.StringHelper;
import net.minecraft.block.Block;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.traits.ITrait;

public class MaterialsTiConIntegration {
    public static final ITrait TRAIT_SUPER_HEAVY = new TraitSuperHeavy("super_heavy", TextFormatting.GRAY);
    public static final List<LCMaterial> MATERIALS = new ArrayList<LCMaterial>();

    public static void preInit() {
        MaterialsTiConIntegration.registerMaterial(Material.NICKEL);
        MaterialsTiConIntegration.registerMaterial(Material.PALLADIUM);
        MaterialsTiConIntegration.registerMaterial(Material.TITANIUM);
        MaterialsTiConIntegration.registerMaterial(Material.VIBRANIUM);
        MaterialsTiConIntegration.registerMaterial(Material.OSMIUM);
        MaterialsTiConIntegration.registerMaterial(Material.IRIDIUM);
        MaterialsTiConIntegration.registerMaterial(Material.DWARF_STAR_ALLOY);
        MaterialsTiConIntegration.registerMaterial(Material.GOLD_TITANIUM_ALLOY);
        MaterialsTiConIntegration.registerMaterial(Material.INTERTIUM);
        MaterialsTiConIntegration.registerMaterial(Material.ADAMANTIUM);
        MaterialsTiConIntegration.registerMaterial(Material.URU);
        TinkerRegistry.addTrait((ITrait)TRAIT_SUPER_HEAVY);
    }

    public static void postInit() {
        for (LCMaterial m : MATERIALS) {
            for (ITrait traits : m.material.getTiConTraits()) {
                m.addTrait(traits);
            }
        }
        MaterialsTiConIntegration.registerAlloy("adamantium*432", "steel*288", "vibranium*144");
        MaterialsTiConIntegration.registerAlloy("intertium*432", "iron*288", "osmium*144");
        MaterialsTiConIntegration.registerAlloy("goldtitaniumalloy*432", "titanium*288", "gold*144");
    }

    public static void registerMaterial(Material lcMaterial) {
        LCMaterial m = new LCMaterial(lcMaterial);
        m.addItemIngot(lcMaterial.getOreDictionaryName(Material.MaterialComponent.INGOT));
        m.setRepresentativeItem(lcMaterial.getItemStack(Material.MaterialComponent.INGOT));
        m.setCastable(true);
        MATERIALS.add(m);
        LCMaterialIntegration integration = new LCMaterialIntegration(m, FluidRegistry.getFluid((String)m.getIdentifier().toLowerCase()), lcMaterial.getOreDictionaryName(Material.MaterialComponent.INGOT).replace("ingot", ""));
        TinkerRegistry.integrate((MaterialIntegration)integration).toolforge();
        for (IMaterialStats stats : lcMaterial.getTiConMaterialStats()) {
            TinkerRegistry.addMaterialStats((slimeknights.tconstruct.library.materials.Material)m, (IMaterialStats)stats);
        }
    }

    public static void registerAlloy(String out, String ... in) {
        FluidStack sOut = MaterialsTiConIntegration.getFluidLoaded(out);
        ArrayList<FluidStack> sIns = new ArrayList<FluidStack>();
        for (String s : in) {
            sIns.add(MaterialsTiConIntegration.getFluidLoaded(s));
        }
        if (sOut != null && !sIns.contains(null)) {
            TinkerRegistry.registerAlloy((FluidStack)sOut, (FluidStack[])sIns.toArray(new FluidStack[sIns.size()]));
        }
    }

    public static FluidStack getFluidLoaded(String fluid) {
        String[] result = fluid.split("\\*");
        if (result.length == 2 && FluidRegistry.getFluid((String)result[0]) != null) {
            return new FluidStack(FluidRegistry.getFluid((String)result[0]), Integer.parseInt(result[1]));
        }
        return null;
    }

    public static class LCMaterialIntegration
    extends MaterialIntegration {
        public boolean preInit = false;

        public LCMaterialIntegration(slimeknights.tconstruct.library.materials.Material material, Fluid fluid, String oreSuffix) {
            super(material, fluid, oreSuffix);
        }

        public void registerFluidModel() {
        }

        public void registerFluidBlock(IForgeRegistry<Block> registry) {
        }

        public void integrate() {
            if (this.fluid == null && this.material instanceof LCMaterial) {
                this.fluid = FluidRegistry.getFluid((String)((LCMaterial)this.material).material.getIdentifier().toLowerCase());
                this.material.setFluid(this.fluid);
            }
            super.integrate();
        }
    }

    public static class LCMaterial
    extends slimeknights.tconstruct.library.materials.Material {
        public Material material;

        public LCMaterial(Material material) {
            super(material.getIdentifier().toLowerCase(), material.getColor());
            this.material = material;
            if (FMLCommonHandler.instance().getSide().isClient()) {
                this.setRenderInfo(material.getTiConMaterialRenderInfo());
            }
        }

        public String getLocalizedName() {
            return StringHelper.translateToLocal(this.material.getUnlocalizedName());
        }

        public String getTextColor() {
            return super.getTextColor();
        }
    }
}

