/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers;

import java.io.File;
import java.util.Map;
import lucraft.mods.lucraftcore.LCConfig;
import lucraft.mods.lucraftcore.module.Module;
import lucraft.mods.lucraftcore.network.LCPacketDispatcher;
import lucraft.mods.lucraftcore.superpowers.PermissionAbilityHandler;
import lucraft.mods.lucraftcore.superpowers.SuperpowerHandler;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.AbilityContainerItem;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.AbilityContainerSuitSet;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.AbilityContainerSuperpower;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.IAbilityProvider;
import lucraft.mods.lucraftcore.superpowers.abilitybar.SuperpowerAbilityBarProvider;
import lucraft.mods.lucraftcore.superpowers.capabilities.CapabilitySuperpower;
import lucraft.mods.lucraftcore.superpowers.capabilities.ISuperpowerCapability;
import lucraft.mods.lucraftcore.superpowers.commands.CommandSuperpower;
import lucraft.mods.lucraftcore.superpowers.commands.CommandSuperpowerXP;
import lucraft.mods.lucraftcore.superpowers.effects.EffectTrail;
import lucraft.mods.lucraftcore.superpowers.entities.EntityEnergyBlast;
import lucraft.mods.lucraftcore.superpowers.items.SuperpowerItems;
import lucraft.mods.lucraftcore.superpowers.network.MessageAbilityKey;
import lucraft.mods.lucraftcore.superpowers.network.MessageChooseSuperpower;
import lucraft.mods.lucraftcore.superpowers.network.MessageChooseSuperpowerGui;
import lucraft.mods.lucraftcore.superpowers.network.MessageSyncAbilityContainer;
import lucraft.mods.lucraftcore.superpowers.network.MessageSyncJsonSuitSet;
import lucraft.mods.lucraftcore.superpowers.network.MessageSyncJsonSuperpower;
import lucraft.mods.lucraftcore.superpowers.network.MessageSyncSuperpower;
import lucraft.mods.lucraftcore.superpowers.network.MessageToggleAbilityVisibility;
import lucraft.mods.lucraftcore.superpowers.render.RenderEntityEnergyBlast;
import lucraft.mods.lucraftcore.superpowers.render.RenderEntityTrail;
import lucraft.mods.lucraftcore.superpowers.render.SuperpowerRenderLayer;
import lucraft.mods.lucraftcore.superpowers.render.SuperpowerRenderer;
import lucraft.mods.lucraftcore.superpowers.suitsets.RegisterSuitSetEvent;
import lucraft.mods.lucraftcore.superpowers.suitsets.SuitSet;
import lucraft.mods.lucraftcore.util.abilitybar.AbilityBarHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.command.ICommand;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModuleSuperpowers
extends Module {
    public static final ModuleSuperpowers INSTANCE = new ModuleSuperpowers();
    public SuperpowerItems ITEMS = new SuperpowerItems();

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        CapabilityManager.INSTANCE.register(ISuperpowerCapability.class, (Capability.IStorage)new CapabilitySuperpower.CapabilitySuperpowerStorage(), CapabilitySuperpower.class);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this.ITEMS);
        MinecraftForge.EVENT_BUS.register((Object)new CapabilitySuperpower.CapabilitySuperpowerEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PermissionAbilityHandler());
        MinecraftForge.EVENT_BUS.post((Event)new RegisterSuitSetEvent(SuitSet.REGISTRY));
        Ability.registerSupplier(Ability.EnumAbilityContext.SUPERPOWER, e -> SuperpowerHandler.getSuperpower(e), (e, c) -> new AbilityContainerSuperpower(e));
        Ability.registerSupplier(Ability.EnumAbilityContext.SUIT, e -> SuitSet.getSuitSet(e), AbilityContainerSuitSet::new);
        Ability.registerSupplier(Ability.EnumAbilityContext.MAIN_HAND, e -> e.func_184614_ca().func_77973_b() instanceof IAbilityProvider ? (IAbilityProvider)e.func_184614_ca().func_77973_b() : null, (e, c) -> new AbilityContainerItem(e, c, EntityEquipmentSlot.MAINHAND));
        Ability.registerSupplier(Ability.EnumAbilityContext.OFF_HAND, e -> e.func_184592_cb().func_77973_b() instanceof IAbilityProvider ? (IAbilityProvider)e.func_184592_cb().func_77973_b() : null, (e, c) -> new AbilityContainerItem(e, c, EntityEquipmentSlot.OFFHAND));
    }

    @Override
    public void init(FMLInitializationEvent event) {
        LCPacketDispatcher.registerMessage(MessageSyncSuperpower.Handler.class, MessageSyncSuperpower.class, Side.CLIENT, 40);
        LCPacketDispatcher.registerMessage(MessageAbilityKey.Handler.class, MessageAbilityKey.class, Side.SERVER, 41);
        LCPacketDispatcher.registerMessage(MessageToggleAbilityVisibility.Handler.class, MessageToggleAbilityVisibility.class, Side.SERVER, 42);
        LCPacketDispatcher.registerMessage(MessageSyncAbilityContainer.Handler.class, MessageSyncAbilityContainer.class, Side.CLIENT, 43);
        LCPacketDispatcher.registerMessage(MessageChooseSuperpowerGui.Handler.class, MessageChooseSuperpowerGui.class, Side.CLIENT, 44);
        LCPacketDispatcher.registerMessage(MessageChooseSuperpower.Handler.class, MessageChooseSuperpower.class, Side.SERVER, 45);
        LCPacketDispatcher.registerMessage(MessageSyncJsonSuperpower.Handler.class, MessageSyncJsonSuperpower.class, Side.CLIENT, 46);
        LCPacketDispatcher.registerMessage(MessageSyncJsonSuitSet.Handler.class, MessageSyncJsonSuitSet.class, Side.CLIENT, 47);
        this.ITEMS.loadSuperpowerInjection();
        PermissionAbilityHandler.init();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
    }

    @SubscribeEvent
    public void onRegisterEntities(RegistryEvent.Register<EntityEntry> e) {
        e.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().entity(EntityEnergyBlast.class).id(new ResourceLocation("lucraftcore", "energy_blast"), 0).name("energy_blast").tracker(64, 1, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EffectTrail.EntityTrail.class, RenderEntityTrail::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityEnergyBlast.class, RenderEntityEnergyBlast::new);
        AbilityBarHandler.registerProvider(new SuperpowerAbilityBarProvider());
        MinecraftForge.EVENT_BUS.register((Object)new SuperpowerRenderer());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        RenderPlayer render = (RenderPlayer)skinMap.get("default");
        render.func_177094_a((LayerRenderer)new SuperpowerRenderLayer(render));
        render = (RenderPlayer)skinMap.get("slim");
        render.func_177094_a((LayerRenderer)new SuperpowerRenderLayer(render));
        Ability.generateHtmlFile(new File("addonpacks/abilities.html"));
    }

    @Override
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandSuperpower());
        event.registerServerCommand((ICommand)new CommandSuperpowerXP());
    }

    @Override
    public String getName() {
        return "Superpowers";
    }

    @Override
    public boolean isEnabled() {
        return LCConfig.modules.superpowers;
    }
}

