/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers;

import java.util.HashMap;
import java.util.Map;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityEntry;
import lucraft.mods.lucraftcore.superpowers.events.AbilityKeyEvent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

public class PermissionAbilityHandler {
    public static Map<ResourceLocation, String> PERMS = new HashMap<ResourceLocation, String>();

    public static void init() {
        for (AbilityEntry entry : Ability.ABILITY_REGISTRY.getValuesCollection()) {
            String perm = "ability." + entry.getRegistryName().func_110624_b() + "." + entry.getRegistryName().func_110623_a();
            PermissionAPI.registerNode((String)perm, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)("Ability '" + entry.getRegistryName().toString() + "'"));
            PERMS.put(entry.getRegistryName(), perm);
        }
    }

    @SubscribeEvent
    public void onAbility(AbilityKeyEvent.Server e) {
        String perm = PERMS.get(e.ability.getAbilityEntry().getRegistryName());
        if (e.entity instanceof EntityPlayerMP && !PermissionAPI.hasPermission((EntityPlayer)((EntityPlayer)e.entity), (String)perm)) {
            e.setCanceled(true);
            ((EntityPlayerMP)e.entity).func_146105_b((ITextComponent)new TextComponentTranslation("lucraftcore.info.no_perm_ability", new Object[0]), true);
        }
    }
}

