/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.abilities;

import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.EnumSync;
import lucraft.mods.lucraftcore.util.triggers.LCCriteriaTriggers;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;

public abstract class AbilityAction
extends Ability {
    public AbilityAction(EntityLivingBase entity) {
        super(entity);
        this.setCooldown(this.getMaxCooldown());
    }

    @Override
    public void onUpdate() {
        if (this.isUnlocked()) {
            if (this.isEnabled()) {
                if (this.ticks == 0) {
                    this.firstTick();
                }
                ++this.ticks;
                this.updateTick();
            } else {
                if (this.ticks != 0) {
                    this.lastTick();
                    this.ticks = 0;
                }
                if (this.hasCooldown()) {
                    if (this.getCooldown() > 0) {
                        this.setCooldown(this.getCooldown() - 1);
                    } else {
                        this.setEnabled(true);
                    }
                }
            }
        } else if (this.ticks != 0) {
            this.lastTick();
            this.ticks = 0;
        }
        if (this.dataManager.sync != null) {
            this.sync = this.sync.add(this.dataManager.sync);
            this.dataManager.sync = EnumSync.NONE;
        }
    }

    @Override
    public void onKeyPressed() {
        if (this.isUnlocked()) {
            if (this.hasCooldown()) {
                if (this.getCooldown() == 0 && this.action()) {
                    this.setEnabled(false);
                    this.setCooldown(this.getMaxCooldown());
                    if (this.entity instanceof EntityPlayerMP) {
                        LCCriteriaTriggers.EXECUTE_ABILITY.trigger((EntityPlayerMP)this.entity, this.getAbilityEntry());
                    }
                    for (Ability ability2 : (Ability[])AbilityAction.getAbilities(this.entity).stream().filter(ability -> ability.getParentAbility() == this).toArray(Ability[]::new)) {
                        ability2.onKeyPressed();
                    }
                }
            } else {
                this.action();
                for (Ability ability3 : (Ability[])AbilityAction.getAbilities(this.entity).stream().filter(ability -> ability.getParentAbility() == this).toArray(Ability[]::new)) {
                    ability3.onKeyPressed();
                }
                if (this.entity instanceof EntityPlayerMP) {
                    LCCriteriaTriggers.EXECUTE_ABILITY.trigger((EntityPlayerMP)this.entity, this.getAbilityEntry());
                }
            }
        }
    }

    @Override
    public void onKeyReleased() {
    }

    @Override
    public Ability.AbilityType getAbilityType() {
        return Ability.AbilityType.ACTION;
    }

    @Override
    public abstract boolean action();
}

