/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.abilities;

import java.util.UUID;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityConstant;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityData;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataFloat;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataInteger;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataUUID;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.EnumSync;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.util.text.TextFormatting;

public abstract class AbilityAttributeModifier
extends AbilityConstant {
    public static final AbilityData<Float> AMOUNT = new AbilityDataFloat("amount").disableSaving().setSyncType(EnumSync.SELF).enableSetting("amount", "The amount for the giving attribute modifier");
    public static final AbilityData<Integer> OPERATION = new AbilityDataInteger("operation").disableSaving().setSyncType(EnumSync.SELF).enableSetting("operation", "The operation for the giving attribute modifier (More: https://minecraft.gamepedia.com/Attribute#Operations)");
    public static final AbilityData<UUID> UUID = new AbilityDataUUID("uuid").disableSaving().setSyncType(EnumSync.SELF).enableSetting("uuid", "Sets the unique identifier for this attribute modifier");
    public static final AbilityData<Float> MULTIPLIER = new AbilityDataFloat("multiplier").setSyncType(EnumSync.SELF);

    public AbilityAttributeModifier(EntityLivingBase entity) {
        super(entity);
    }

    @Override
    public void registerData() {
        super.registerData();
        this.dataManager.register(AMOUNT, Float.valueOf(1.0f));
        this.dataManager.register(OPERATION, 0);
        this.dataManager.register(UUID, java.util.UUID.fromString("0669d99d-b34d-40fc-a4d8-c7ee963cc842"));
        this.dataManager.register(MULTIPLIER, Float.valueOf(1.0f));
    }

    @Override
    public String getDisplayDescription() {
        return super.getDisplayDescription() + "\n \n" + TextFormatting.BLUE + (this.getOperation() == 0 ? "+" : "*") + this.getAmount();
    }

    public abstract IAttribute getAttribute();

    public UUID getModifierUUID() {
        return this.dataManager.get(UUID);
    }

    public float getAmount() {
        return this.dataManager.get(AMOUNT).floatValue() * this.dataManager.get(MULTIPLIER).floatValue();
    }

    public int getOperation() {
        return this.dataManager.get(OPERATION);
    }

    @Override
    public void updateTick() {
        if (this.entity.func_110140_aT().func_111146_a().stream().noneMatch(iAttributeInstance -> iAttributeInstance.func_111123_a() == this.getAttribute())) {
            this.entity.func_110140_aT().func_111150_b(this.getAttribute()).func_111128_a(this.getAttribute().func_111110_b());
        }
        if (this.entity.func_110140_aT().func_111151_a(this.getAttribute()).func_111127_a(this.getModifierUUID()) != null && (this.entity.func_110148_a(this.getAttribute()).func_111127_a(this.getModifierUUID()).func_111164_d() != (double)this.getAmount() || this.entity.func_110148_a(this.getAttribute()).func_111127_a(this.getModifierUUID()).func_111169_c() != this.getOperation())) {
            this.entity.func_110140_aT().func_111151_a(this.getAttribute()).func_188479_b(this.getModifierUUID());
        }
        if (this.entity.func_110140_aT().func_111151_a(this.getAttribute()).func_111127_a(this.getModifierUUID()) == null) {
            AttributeModifier modifier = new AttributeModifier(this.getModifierUUID(), this.getUnlocalizedName(), (double)this.getAmount(), this.getOperation()).func_111168_a(false);
            this.entity.func_110140_aT().func_111151_a(this.getAttribute()).func_111121_a(modifier);
        }
    }

    @Override
    public void lastTick() {
        if (this.entity.func_110140_aT().func_111151_a(this.getAttribute()).func_111127_a(this.getModifierUUID()) != null) {
            this.entity.func_110140_aT().func_111151_a(this.getAttribute()).func_188479_b(this.getModifierUUID());
        }
    }
}

