/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.abilities;

import java.awt.Color;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityAction;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityData;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataColor;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataFloat;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.EnumSync;
import lucraft.mods.lucraftcore.superpowers.entities.EntityEnergyBlast;
import lucraft.mods.lucraftcore.util.helper.LCRenderHelper;
import lucraft.mods.lucraftcore.util.helper.PlayerHelper;
import lucraft.mods.lucraftcore.util.sounds.LCSoundEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AbilityEnergyBlast
extends AbilityAction {
    public static final AbilityData<Float> DAMAGE = new AbilityDataFloat("damage").disableSaving().setSyncType(EnumSync.SELF).enableSetting("damage", "The amount of damage that the energy blast entity will cause");
    public static final AbilityData<Color> COLOR = new AbilityDataColor("color").disableSaving().enableSetting("color", "Sets the color for the energy blast");

    public AbilityEnergyBlast(EntityLivingBase entity) {
        super(entity);
    }

    @Override
    public void registerData() {
        super.registerData();
        this.dataManager.register(DAMAGE, Float.valueOf(3.0f));
        this.dataManager.register(COLOR, Color.RED);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawIcon(Minecraft mc, Gui gui, int x, int y) {
        Color color = this.dataManager.get(COLOR);
        GlStateManager.func_179124_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
        LCRenderHelper.drawIcon(mc, gui, x, y, 0, 15);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        LCRenderHelper.drawIcon(mc, gui, x, y, 0, 14);
    }

    @Override
    public boolean action() {
        if (!this.entity.field_70170_p.field_72995_K) {
            EntityEnergyBlast entity = new EntityEnergyBlast(this.entity.field_70170_p, this.entity, this.dataManager.get(DAMAGE).floatValue(), this.dataManager.get(COLOR));
            entity.func_184538_a((Entity)this.entity, this.entity.field_70125_A, this.entity.field_70177_z, 0.0f, 1.5f, 1.0f);
            this.entity.field_70170_p.func_72838_d((Entity)entity);
            PlayerHelper.playSoundToAll(this.entity.field_70170_p, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, 50.0, LCSoundEvents.ENERGY_BLAST, SoundCategory.PLAYERS);
        }
        return true;
    }
}

