/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.abilities;

import java.util.Arrays;
import java.util.Random;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityToggle;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityData;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataInteger;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataPotion;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.EnumSync;
import lucraft.mods.lucraftcore.util.helper.StringHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AbilityPotionPunch
extends AbilityToggle {
    public static AbilityData<Potion> POTION = new AbilityDataPotion("potion").disableSaving().setSyncType(EnumSync.SELF).enableSetting("potion", "Sets the actual potion");
    public static AbilityData<Integer> AMPLIFIER = new AbilityDataInteger("amplifier").disableSaving().setSyncType(EnumSync.NONE).enableSetting("amplifier", "Sets the amplifier for the potion effect");
    public static AbilityData<Integer> DURATION = new AbilityDataInteger("duration").disableSaving().setSyncType(EnumSync.NONE).enableSetting("duration", "Sets the duration for the potion effect");

    public AbilityPotionPunch(EntityLivingBase entity) {
        super(entity);
    }

    @Override
    public void registerData() {
        super.registerData();
        this.dataManager.register(POTION, MobEffects.field_76436_u);
        this.dataManager.register(AMPLIFIER, 0);
        this.dataManager.register(DURATION, 20);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawIcon(Minecraft mc, Gui gui, int x, int y) {
        ItemStack stack = new ItemStack((Item)Items.field_151068_bn);
        stack = PotionUtils.func_185184_a((ItemStack)stack, Arrays.asList(new PotionEffect(this.dataManager.get(POTION), 0, 20)));
        float zLevel = Minecraft.func_71410_x().func_175599_af().field_77023_b;
        Minecraft.func_71410_x().func_175599_af().field_77023_b = -100.5f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        Minecraft.func_71410_x().func_175599_af().func_175042_a(stack, 0, 0);
        GlStateManager.func_179121_F();
        Minecraft.func_71410_x().func_175599_af().field_77023_b = zLevel;
    }

    @Override
    public String getDisplayDescription() {
        return super.getDisplayDescription() + "\n \n" + TextFormatting.BLUE + StringHelper.translateToLocal(this.dataManager.get(POTION).func_76393_a());
    }

    @Override
    public void updateTick() {
        this.spawnPotionParticles(1);
    }

    private void spawnPotionParticles(int particleCount) {
        int i = this.dataManager.get(POTION).func_76401_j();
        Random rand = new Random();
        if (i != -1 && particleCount > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i >> 0 & 0xFF) / 255.0;
            for (int j = 0; j < particleCount; ++j) {
                this.entity.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.entity.field_70165_t + (rand.nextDouble() - 0.5) * (double)this.entity.field_70130_N, this.entity.field_70163_u + rand.nextDouble() * (double)this.entity.field_70131_O, this.entity.field_70161_v + (rand.nextDouble() - 0.5) * (double)this.entity.field_70130_N, d0, d1, d2, new int[0]);
            }
        }
    }

    @Override
    public void onHurt(LivingHurtEvent e) {
        if (this.isEnabled()) {
            e.getEntityLiving().func_70690_d(new PotionEffect(this.dataManager.get(POTION), this.dataManager.get(DURATION).intValue(), this.dataManager.get(AMPLIFIER).intValue()));
        }
    }
}

