/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.abilities.data;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityData;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;

public class AbilityDataIcon
extends AbilityData<Icon> {
    public AbilityDataIcon(String key) {
        super(key);
    }

    @Override
    public Icon parseValue(JsonObject jsonObject, Icon defaultValue) {
        if (!JsonUtils.func_151204_g((JsonObject)jsonObject, (String)this.jsonKey)) {
            return defaultValue;
        }
        JsonObject object = JsonUtils.func_152754_s((JsonObject)jsonObject, (String)this.jsonKey);
        String type = JsonUtils.func_151200_h((JsonObject)object, (String)"type");
        if (type.equalsIgnoreCase("item")) {
            ItemStack stack = CraftingHelper.getItemStack((JsonObject)object, (JsonContext)new JsonContext("null"));
            return new Icon(stack);
        }
        if (type.equalsIgnoreCase("texture")) {
            ResourceLocation resourceLocation = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)object, (String)"texture"));
            return new Icon(resourceLocation);
        }
        if (type.equalsIgnoreCase("internal")) {
            return new Icon(true);
        }
        throw new JsonSyntaxException("Icon type must be either 'icon' or 'texture'!");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, Icon value) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Type", value.texture != null ? "Texture" : (!value.stack.func_190926_b() ? "Item" : "Internal"));
        if (value.texture != null) {
            tag.func_74778_a("Texture", value.texture.toString());
        } else if (!value.stack.func_190926_b()) {
            tag.func_74782_a("Item", (NBTBase)value.stack.serializeNBT());
        }
        nbt.func_74782_a(this.key, (NBTBase)tag);
    }

    @Override
    public Icon readFromNBT(NBTTagCompound nbt, Icon defaultValue) {
        NBTTagCompound tag = nbt.func_74775_l(this.key);
        if (tag.func_74779_i("Type").equalsIgnoreCase("Texture")) {
            return new Icon(new ResourceLocation(tag.func_74779_i("Texture")));
        }
        if (tag.func_74779_i("Type").equalsIgnoreCase("Item")) {
            return new Icon(new ItemStack(tag.func_74775_l("Item")));
        }
        if (tag.func_74779_i("Type").equalsIgnoreCase("Internal")) {
            return new Icon(true);
        }
        return defaultValue;
    }

    @Override
    public String getDisplay(Icon value) {
        if (value.texture != null) {
            return "{ \"type\": \"texture\", \"texture\": \"" + value.texture.toString() + "\" }";
        }
        if (!value.stack.func_190926_b()) {
            return "{ \"type\": \"item\", \"item\": { \"item\": " + ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)value.stack.func_77973_b())).toString() + "\" } }";
        }
        if (value.internal) {
            return "{ \"type\": \"internal\" }";
        }
        return super.getDisplay(value);
    }

    public static class Icon {
        public ItemStack stack = ItemStack.field_190927_a;
        public ResourceLocation texture;
        public boolean internal;

        public Icon(ItemStack stack) {
            this.stack = stack;
        }

        public Icon(ResourceLocation texture) {
            this.texture = texture;
        }

        public Icon(boolean internal) {
            this.internal = internal;
        }
    }
}

