/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.capabilities;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lucraft.mods.lucraftcore.LCConfig;
import lucraft.mods.lucraftcore.network.LCPacketDispatcher;
import lucraft.mods.lucraftcore.superpowers.Superpower;
import lucraft.mods.lucraftcore.superpowers.SuperpowerHandler;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.AbilityContainer;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.AbilitySupplier;
import lucraft.mods.lucraftcore.superpowers.capabilities.CapabilitySuperpowerProvider;
import lucraft.mods.lucraftcore.superpowers.capabilities.ISuperpowerCapability;
import lucraft.mods.lucraftcore.superpowers.effects.EffectTrail;
import lucraft.mods.lucraftcore.superpowers.events.AbilityKeyEvent;
import lucraft.mods.lucraftcore.superpowers.network.MessageChooseSuperpowerGui;
import lucraft.mods.lucraftcore.superpowers.network.MessageSyncSuperpower;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CapabilitySuperpower
implements ISuperpowerCapability {
    @CapabilityInject(value=ISuperpowerCapability.class)
    public static final Capability<ISuperpowerCapability> SUPERPOWER_CAP = null;
    public final EntityLivingBase entity;
    public Superpower superpower;
    public Map<Ability.EnumAbilityContext, AbilityContainer> containerMap;
    public NBTTagCompound nbt;
    public boolean hasPlayedBefore = false;
    public LinkedList<Entity> trailEntities = new LinkedList();

    public CapabilitySuperpower(EntityLivingBase entity) {
        this.entity = entity;
        this.containerMap = new HashMap<Ability.EnumAbilityContext, AbilityContainer>();
        this.nbt = new NBTTagCompound();
        for (Ability.EnumAbilityContext context : Ability.EnumAbilityContext.values()) {
            AbilitySupplier supplier = Ability.getAbilitySupplier(context);
            if (supplier == null) continue;
            this.containerMap.put(context, supplier.containerFactory.create(entity, context));
        }
    }

    @Override
    public void setSuperpower(Superpower superpower, boolean update) {
        if (this.superpower != superpower) {
            this.superpower = superpower;
            if (update) {
                this.syncToAll();
            }
        }
    }

    @Override
    public void setSuperpower(Superpower superpower) {
        this.setSuperpower(superpower, true);
    }

    @Override
    public Superpower getSuperpower() {
        return this.superpower;
    }

    @Override
    public AbilityContainer getAbilityContainer(Ability.EnumAbilityContext context) {
        return this.containerMap.get((Object)context);
    }

    @Override
    public NBTTagCompound getData() {
        return this.nbt;
    }

    @Override
    public boolean hasPlayedBefore() {
        return this.hasPlayedBefore;
    }

    @Override
    public void setHasPlayedBefore(boolean played) {
        this.hasPlayedBefore = played;
    }

    @Override
    public void onUpdate() {
        for (AbilityContainer abilityContainer : this.containerMap.values()) {
            if (abilityContainer == null) continue;
            abilityContainer.onUpdate();
        }
        if (!this.hasPlayedBefore() && LCConfig.superpowers.startSuperpowersEnabled && this.entity.field_70173_aa == 100 && this.entity instanceof EntityPlayerMP) {
            LCPacketDispatcher.sendTo(new MessageChooseSuperpowerGui(LCConfig.superpowers.startSuperpowers), (EntityPlayerMP)this.entity);
        }
    }

    @Override
    public EntityLivingBase getEntity() {
        return this.entity;
    }

    @Override
    public NBTTagCompound writeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.superpower != null) {
            nbt.func_74778_a("Superpower", this.superpower.getRegistryName().toString());
        }
        for (AbilityContainer value : this.containerMap.values()) {
            value.save();
        }
        nbt.func_74782_a("Data", (NBTBase)this.nbt);
        nbt.func_74757_a("HasPlayedBefore", this.hasPlayedBefore);
        return nbt;
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        this.superpower = (Superpower)SuperpowerHandler.SUPERPOWER_REGISTRY.getValue(new ResourceLocation(nbt.func_74779_i("Superpower")));
        this.nbt = nbt.func_74775_l("Data");
        this.hasPlayedBefore = nbt.func_74767_n("HasPlayedBefore");
        for (AbilityContainer value : this.containerMap.values()) {
            value.load();
        }
    }

    @Override
    public void syncToPlayer() {
        if (this.entity instanceof EntityPlayerMP) {
            this.syncToPlayer((EntityPlayer)this.entity);
        }
    }

    @Override
    public void syncToPlayer(EntityPlayer receiver) {
        if (receiver instanceof EntityPlayerMP) {
            for (AbilityContainer container : this.containerMap.values()) {
                container.save();
            }
            LCPacketDispatcher.sendTo(new MessageSyncSuperpower(this.entity), (EntityPlayerMP)receiver);
        }
    }

    @Override
    public void syncToAll() {
        this.syncToPlayer();
        if (this.entity.field_70170_p instanceof WorldServer) {
            for (AbilityContainer container : this.containerMap.values()) {
                container.save();
            }
            for (EntityPlayer players : ((WorldServer)this.entity.field_70170_p).func_73039_n().getTrackingPlayers((Entity)this.entity)) {
                if (!(players instanceof EntityPlayerMP)) continue;
                LCPacketDispatcher.sendTo(new MessageSyncSuperpower(this.entity), (EntityPlayerMP)players);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public LinkedList<EffectTrail.EntityTrail> getTrailEntities() {
        LinkedList<EffectTrail.EntityTrail> list = new LinkedList<EffectTrail.EntityTrail>();
        for (Entity en : this.trailEntities) {
            if (!(en instanceof EffectTrail.EntityTrail)) continue;
            list.add((EffectTrail.EntityTrail)en);
        }
        return list;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addTrailEntity(Entity entity) {
        this.trailEntities.add(entity);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void removeTrailEntity(Entity entity) {
        this.trailEntities.remove(entity);
    }

    public static class CapabilitySuperpowerStorage
    implements Capability.IStorage<ISuperpowerCapability> {
        public NBTBase writeNBT(Capability<ISuperpowerCapability> capability, ISuperpowerCapability instance, EnumFacing side) {
            return instance.writeNBT();
        }

        public void readNBT(Capability<ISuperpowerCapability> capability, ISuperpowerCapability instance, EnumFacing side, NBTBase nbt) {
            instance.readNBT((NBTTagCompound)nbt);
        }
    }

    public static class CapabilitySuperpowerEventHandler {
        @SubscribeEvent
        public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
            if (!(evt.getObject() instanceof EntityLivingBase)) {
                return;
            }
            evt.addCapability(new ResourceLocation("lucraftcore", "superpower_capability"), (ICapabilityProvider)new CapabilitySuperpowerProvider(new CapabilitySuperpower((EntityLivingBase)evt.getObject())));
        }

        @SubscribeEvent
        public void onPlayerStartTracking(PlayerEvent.StartTracking e) {
            if (e.getTarget().hasCapability(SUPERPOWER_CAP, null)) {
                ((ISuperpowerCapability)e.getTarget().getCapability(SUPERPOWER_CAP, null)).syncToPlayer(e.getEntityPlayer());
            }
        }

        @SubscribeEvent
        public void onEntityJoinWorld(EntityJoinWorldEvent e) {
            if (e.getEntity() instanceof EntityLivingBase) {
                EntityLivingBase entity = (EntityLivingBase)e.getEntity();
                SuperpowerHandler.syncToAll(entity);
            }
        }

        @SubscribeEvent
        public void onPlayerClone(PlayerEvent.Clone e) {
            NBTTagCompound compound = (NBTTagCompound)SUPERPOWER_CAP.getStorage().writeNBT(SUPERPOWER_CAP, e.getOriginal().getCapability(SUPERPOWER_CAP, null), null);
            SUPERPOWER_CAP.getStorage().readNBT(SUPERPOWER_CAP, e.getEntityPlayer().getCapability(SUPERPOWER_CAP, null), null, (NBTBase)compound);
        }

        @SubscribeEvent
        public void onUpdate(LivingEvent.LivingUpdateEvent e) {
            ((ISuperpowerCapability)e.getEntityLiving().getCapability(SUPERPOWER_CAP, null)).onUpdate();
            if (e.getEntityLiving().field_70170_p.field_72995_K) {
                return;
            }
            if (!(e.getEntityLiving() instanceof EntityPlayer)) {
                Ability a;
                List actionAbilities;
                for (Ability ability2 : Ability.getAbilities(e.getEntityLiving())) {
                    if (!ability2.isUnlocked() || ability2.getAbilityType() != Ability.AbilityType.TOGGLE || ability2.isEnabled() || ability2.isCoolingdown() || MinecraftForge.EVENT_BUS.post((Event)new AbilityKeyEvent.Server(ability2, e.getEntityLiving(), true))) continue;
                    ability2.onKeyPressed();
                }
                if (e.getEntity().field_70173_aa % 20 == 0 && (actionAbilities = Ability.getAbilities(e.getEntityLiving()).stream().filter(ability -> ability.isUnlocked() && !ability.isCoolingdown() && ability.getAbilityType() == Ability.AbilityType.ACTION).collect(Collectors.toList())).size() > 0 && !MinecraftForge.EVENT_BUS.post((Event)new AbilityKeyEvent.Server(a = (Ability)actionAbilities.get(e.getEntity().field_70170_p.field_73012_v.nextInt(actionAbilities.size())), e.getEntityLiving(), true))) {
                    a.onKeyPressed();
                }
            }
        }

        @SubscribeEvent
        public void onLivingAttackEvent(LivingAttackEvent e) {
            for (Ability ab : Ability.getAbilities(e.getEntityLiving())) {
                if (!ab.isUnlocked()) continue;
                ab.onAttacked(e);
            }
        }

        @SubscribeEvent
        public void onLivingHurtEvent(LivingHurtEvent e) {
            for (Ability ab : Ability.getAbilities(e.getEntityLiving())) {
                if (!ab.isUnlocked()) continue;
                ab.onEntityHurt(e);
            }
            if (e.getSource() != null && e.getSource().func_76364_f() != null && e.getSource().func_76364_f() instanceof EntityLivingBase) {
                EntityLivingBase entity = (EntityLivingBase)e.getSource().func_76364_f();
                for (Ability ab : Ability.getAbilities(entity)) {
                    if (!ab.isUnlocked()) continue;
                    ab.onHurt(e);
                }
            }
        }

        @SubscribeEvent
        public void onAttackEntityEvent(AttackEntityEvent e) {
            for (Ability ab : Ability.getAbilities(e.getEntityLiving())) {
                if (!ab.isUnlocked()) continue;
                ab.onAttackEntity(e);
            }
        }

        @SubscribeEvent
        public void onBreakSpeed(PlayerEvent.BreakSpeed e) {
            if (e.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)e.getEntityLiving();
                for (Ability ab : Ability.getAbilities((EntityLivingBase)player)) {
                    if (!ab.isUnlocked()) continue;
                    ab.onBreakSpeed(e);
                }
            }
        }
    }
}

