/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.suitsets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.suitsets.SuitSet;
import lucraft.mods.lucraftcore.util.helper.PlayerHelper;
import lucraft.mods.lucraftcore.util.helper.StringHelper;
import lucraft.mods.lucraftcore.util.items.ExtendedTooltip;
import lucraft.mods.lucraftcore.util.items.OpenableArmor;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSuitSetArmor
extends ItemArmor
implements OpenableArmor.IOpenableArmor,
ExtendedTooltip.IExtendedItemToolTip {
    public SuitSet suitSet;

    public ItemSuitSetArmor(SuitSet suitSet, EntityEquipmentSlot armorSlot) {
        super(suitSet.getArmorMaterial(armorSlot), 0, armorSlot);
        if (suitSet.showInCreativeTab()) {
            this.func_77637_a(suitSet.getCreativeTab());
        } else {
            this.func_77637_a(null);
        }
        this.suitSet = suitSet;
        this.func_77655_b(suitSet.getUnlocalizedName() + "_" + this.getArmorSlotName(armorSlot).toLowerCase());
    }

    public ItemArmor.ArmorMaterial func_82812_d() {
        return this.suitSet.getArmorMaterial(this.field_77881_a);
    }

    public CreativeTabs func_77640_w() {
        if (this.suitSet.showInCreativeTab()) {
            return this.suitSet.getCreativeTab();
        }
        return null;
    }

    public SuitSet getSuitSet() {
        return this.suitSet;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        if (this.getSuitSet().hasExtraDescription(stack)) {
            tooltip.addAll(this.getSuitSet().getExtraDescription(stack));
        }
    }

    public String func_77653_i(ItemStack stack) {
        return this.getSuitSet().getDisplayNameForItem((Item)this, stack, this.field_77881_a, super.func_77653_i(stack));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return this.getSuitSet().getArmorTexturePath(stack, entity, slot, false, entity instanceof EntityPlayer ? PlayerHelper.hasSmallArms((EntityPlayer)entity) : false, this.isArmorOpen(entity, stack));
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ModelBiped armorModel = null;
        if (!itemStack.func_190926_b()) {
            boolean smallArms = false;
            if (entityLiving instanceof EntityPlayer) {
                smallArms = PlayerHelper.hasSmallArms((EntityPlayer)entityLiving);
            }
            if ((armorModel = this.getSuitSet().getArmorModel(this.getSuitSet(), itemStack, (Entity)entityLiving, armorSlot, false, smallArms, this.isArmorOpen((Entity)entityLiving, itemStack))) != null) {
                armorModel.func_178686_a((ModelBase)_default);
                return armorModel;
            }
        }
        return super.getArmorModel(entityLiving, itemStack, armorSlot, _default);
    }

    public String getArmorSlotName(EntityEquipmentSlot slot) {
        switch (slot) {
            case HEAD: {
                return "Helmet";
            }
            case CHEST: {
                return "Chestplate";
            }
            case LEGS: {
                return "Legs";
            }
            case FEET: {
                return "Boots";
            }
        }
        return "";
    }

    @Override
    public boolean canBeOpened(Entity entity, ItemStack stack) {
        return this.suitSet.canOpenArmor(this.field_77881_a);
    }

    @Override
    public void setArmorOpen(Entity player, ItemStack stack, boolean open) {
        if (this.getSuitSet().canOpenArmor(this.field_77881_a)) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (stack.func_77942_o()) {
                nbt = stack.func_77978_p();
            }
            nbt.func_74757_a("IsOpen", open);
            this.onArmorToggled(player, stack, nbt.func_74767_n("IsOpen"));
            stack.func_77982_d(nbt);
        }
    }

    @Override
    public boolean isArmorOpen(Entity entity, ItemStack stack) {
        if (this.getSuitSet().canOpenArmor(this.field_77881_a) && stack.func_77942_o()) {
            return stack.func_77978_p().func_74767_n("IsOpen");
        }
        return false;
    }

    @Override
    public void onArmorToggled(Entity entity, ItemStack stack, boolean open) {
        this.getSuitSet().onArmorToggled(entity, stack, this.field_77881_a, open);
    }

    @Override
    public boolean shouldShiftTooltipAppear(ItemStack stack, EntityPlayer player) {
        return false;
    }

    @Override
    public List<String> getShiftToolTip(ItemStack stack, EntityPlayer player) {
        return null;
    }

    @Override
    public boolean shouldCtrlTooltipAppear(ItemStack stack, EntityPlayer player) {
        return true;
    }

    @Override
    public List<String> getCtrlToolTip(ItemStack stack, EntityPlayer player) {
        ArrayList<String> list = new ArrayList<String>();
        Collection abilities = this.getSuitSet().addDefaultAbilities((EntityLivingBase)player, new Ability.AbilityMap(), Ability.EnumAbilityContext.SUIT).values();
        if (abilities.size() > 0) {
            list.add(TextFormatting.RED + StringHelper.translateToLocal("lucraftcore.info.abilities") + TextFormatting.DARK_RED + ":");
            for (Ability ability : abilities) {
                list.add(TextFormatting.RED + "- " + TextFormatting.GRAY + ability.getDisplayName());
            }
        }
        return list;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.suitSet.getIsRepairable(toRepair, repair);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        this.getSuitSet().onArmorTick(world, player, itemStack);
    }
}

