/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.util.entity.vehicle;

import lucraft.mods.lucraftcore.util.entity.vehicle.EntityVehicle;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class EntityLandVehicle
extends EntityVehicle {
    public float additionalYaw;
    public float prevAdditionalYaw;
    public float frontWheelRotation;
    public float prevFrontWheelRotation;
    public float rearWheelRotation;
    public float prevRearWheelRotation;

    public EntityLandVehicle(World worldIn) {
        super(worldIn);
    }

    public EntityLandVehicle(World worldIn, double posX, double posY, double posZ) {
        super(worldIn, posX, posY, posZ);
        this.func_70107_b(posX, posY, posZ);
    }

    @Override
    public void updateVehicle() {
        this.prevAdditionalYaw = this.additionalYaw;
        this.prevFrontWheelRotation = this.frontWheelRotation;
        this.prevRearWheelRotation = this.rearWheelRotation;
        this.updateWheels();
    }

    @Override
    public void updateVehicleMotion() {
        float f1 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) / 20.0f;
        float f2 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) / 20.0f;
        this.vehicleMotionX = -this.currentSpeed * f1;
        this.field_70181_x -= 0.08;
        this.vehicleMotionZ = this.currentSpeed * f2;
    }

    public void updateWheels() {
        float speedPercent = this.getNormalSpeed();
        EntityVehicle.AccelerationDirection acceleration = this.getAcceleration();
        if (this.func_184179_bs() != null && acceleration == EntityVehicle.AccelerationDirection.FORWARD) {
            this.rearWheelRotation = (float)((double)this.rearWheelRotation - 68.0 * (1.0 - (double)speedPercent));
        }
        this.frontWheelRotation -= 68.0f * speedPercent;
        this.rearWheelRotation -= 68.0f * speedPercent;
    }

    @Override
    public void createParticles() {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)(this.field_70163_u - 0.2)), z = MathHelper.func_76128_c((double)this.field_70161_v));
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        if (state.func_185904_a() != Material.field_151579_a && state.func_185904_a().func_76229_l() && this.getAcceleration() == EntityVehicle.AccelerationDirection.FORWARD) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, -this.field_70159_w * 4.0, 1.5, -this.field_70179_y * 4.0, new int[]{Block.func_176210_f((IBlockState)state)});
        }
        if (this.shouldShowEngineSmoke() && this.field_70173_aa % 2 == 0) {
            Vec3d smokePosition = this.getEngineSmokePosition().func_178785_b(-(this.field_70177_z - this.additionalYaw) * ((float)Math.PI / 180));
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + smokePosition.field_72450_a, this.field_70163_u + smokePosition.field_72448_b, this.field_70161_v + smokePosition.field_72449_c, -this.field_70159_w, 0.0, -this.field_70179_y, new int[0]);
        }
    }

    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        if (this.func_184179_bs() == null) {
            this.field_70177_z -= this.additionalYaw;
            this.additionalYaw = 0.0f;
        }
    }
}

