/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.util.entity.vehicle;

import javax.annotation.Nullable;
import lucraft.mods.lucraftcore.network.LCPacketDispatcher;
import lucraft.mods.lucraftcore.util.network.MessageAccelerating;
import lucraft.mods.lucraftcore.util.network.MessageTurn;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityVehicle
extends Entity {
    private static final DataParameter<Float> CURRENT_SPEED = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> MAX_SPEED = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ACCELERATION_SPEED = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> TURN_DIRECTION = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TURN_SENSITIVITY = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MAX_TURN_ANGLE = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ACCELERATION_DIRECTION = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE_TAKEN = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187193_c);
    public float prevCurrentSpeed;
    public float currentSpeed;
    public float speedMultiplier;
    public float accelerationMultiplier;
    public int turnAngle;
    public int prevTurnAngle;
    public float deltaYaw;
    public float wheelAngle;
    public float prevWheelAngle;
    public float vehicleMotionX;
    public float vehicleMotionY;
    public float vehicleMotionZ;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    @SideOnly(value=Side.CLIENT)
    public ItemStack body;
    @SideOnly(value=Side.CLIENT)
    public ItemStack wheel;

    public EntityVehicle(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70138_W = 1.0f;
    }

    public EntityVehicle(World worldIn, double posX, double posY, double posZ) {
        this(worldIn);
        this.func_70107_b(posX, posY, posZ);
    }

    public void func_184174_b(boolean dropWhenDead) {
        super.func_184174_b(dropWhenDead);
        if (dropWhenDead && !this.body.func_190926_b()) {
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.body));
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(CURRENT_SPEED, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(MAX_SPEED, (Object)Float.valueOf(10.0f));
        this.field_70180_af.func_187214_a(ACCELERATION_SPEED, (Object)Float.valueOf(0.5f));
        this.field_70180_af.func_187214_a(TURN_DIRECTION, (Object)TurnDirection.FORWARD.ordinal());
        this.field_70180_af.func_187214_a(TURN_SENSITIVITY, (Object)10);
        this.field_70180_af.func_187214_a(MAX_TURN_ANGLE, (Object)45);
        this.field_70180_af.func_187214_a(ACCELERATION_DIRECTION, (Object)AccelerationDirection.NONE.ordinal());
        this.field_70180_af.func_187214_a(TIME_SINCE_HIT, (Object)0);
        this.field_70180_af.func_187214_a(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
        if (this.field_70170_p.field_72995_K) {
            this.onClientInit();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientInit() {
    }

    public void func_70071_h_() {
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        super.func_70071_h_();
        this.tickLerp();
        this.prevCurrentSpeed = this.currentSpeed;
        this.prevTurnAngle = this.turnAngle;
        this.prevWheelAngle = this.wheelAngle;
        if (this.field_70170_p.field_72995_K) {
            this.onClientUpdate();
        }
        if (this.func_184179_bs() != null) {
            this.createParticles();
        }
        this.updateSpeed();
        this.updateTurning();
        this.updateVehicle();
        this.setSpeed(this.currentSpeed);
        this.field_70177_z -= this.deltaYaw;
        this.updateVehicleMotion();
        this.func_70091_d(MoverType.SELF, this.field_70159_w + (double)this.vehicleMotionX, this.field_70181_x + (double)this.vehicleMotionY, this.field_70179_y + (double)this.vehicleMotionZ);
        if (this.field_70122_E) {
            this.field_70159_w *= 0.8;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.8;
        } else {
            this.field_70159_w *= 0.98;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.98;
        }
        this.speedMultiplier = (float)((double)this.speedMultiplier * 0.85);
        this.func_145775_I();
    }

    public void updateVehicle() {
    }

    public abstract void updateVehicleMotion();

    private void tickLerp() {
        if (this.lerpSteps > 0 && !this.func_184186_bw()) {
            double d0 = this.field_70165_t + (this.lerpX - this.field_70165_t) / (double)this.lerpSteps;
            double d1 = this.field_70163_u + (this.lerpY - this.field_70163_u) / (double)this.lerpSteps;
            double d2 = this.field_70161_v + (this.lerpZ - this.field_70161_v) / (double)this.lerpSteps;
            double d3 = MathHelper.func_76138_g((double)(this.lerpYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.lerpSteps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpPitch - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    private void updateSpeed() {
        this.currentSpeed = this.getSpeed();
        AccelerationDirection acceleration = this.getAcceleration();
        if (this.func_184179_bs() != null) {
            if (acceleration == AccelerationDirection.FORWARD) {
                this.currentSpeed += this.getAccelerationSpeed() * this.getAccelerationMultiplier();
                if (this.currentSpeed > this.getMaxSpeed()) {
                    this.currentSpeed = this.getMaxSpeed();
                }
            } else if (acceleration == AccelerationDirection.REVERSE) {
                this.currentSpeed -= this.getAccelerationSpeed() * this.getAccelerationMultiplier();
                if (this.currentSpeed < -4.0f) {
                    this.currentSpeed = -4.0f;
                }
            } else {
                this.currentSpeed = (float)((double)this.currentSpeed * 0.9);
            }
        } else {
            this.currentSpeed = (float)((double)this.currentSpeed * 0.5);
        }
        this.currentSpeed += this.currentSpeed * this.speedMultiplier;
    }

    private void updateTurning() {
        TurnDirection direction = this.getTurnDirection();
        if (this.func_184179_bs() != null && direction != TurnDirection.FORWARD) {
            this.turnAngle += direction.dir * this.getTurnSensitivity();
            if (Math.abs(this.turnAngle) > this.getMaxTurnAngle()) {
                this.turnAngle = this.getMaxTurnAngle() * direction.dir;
            }
        } else {
            this.turnAngle = (int)((double)this.turnAngle * 0.75);
        }
        this.wheelAngle = (float)this.turnAngle * Math.max(0.25f, 1.0f - Math.abs(this.currentSpeed / 30.0f));
        this.deltaYaw = this.wheelAngle * (this.currentSpeed / 30.0f) / 2.0f;
    }

    public void createParticles() {
        if (this.shouldShowEngineSmoke() && this.field_70173_aa % 2 == 0) {
            Vec3d smokePosition = this.getEngineSmokePosition().func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + smokePosition.field_72450_a, this.field_70163_u + smokePosition.field_72448_b, this.field_70161_v + smokePosition.field_72449_c, -this.field_70159_w, 0.0, -this.field_70179_y, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientUpdate() {
        EntityLivingBase entity = (EntityLivingBase)this.func_184179_bs();
        if (entity != null && entity.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            AccelerationDirection acceleration = AccelerationDirection.fromEntity(entity);
            if (this.getAcceleration() != acceleration) {
                this.setAcceleration(acceleration);
                LCPacketDispatcher.sendToServer(new MessageAccelerating(acceleration));
            }
            TurnDirection direction = TurnDirection.FORWARD;
            if (entity.field_70702_br < 0.0f) {
                direction = TurnDirection.RIGHT;
            } else if (entity.field_70702_br > 0.0f) {
                direction = TurnDirection.LEFT;
            }
            if (this.getTurnDirection() != direction) {
                this.setTurnDirection(direction);
                LCPacketDispatcher.sendToServer(new MessageTurn(direction));
            }
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && !player.func_70093_af()) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            if (source instanceof EntityDamageSourceIndirect && source.func_76346_g() != null && this.func_184196_w(source.func_76346_g())) {
                return false;
            }
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            boolean bl = flag = source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.getDamageTaken() > 40.0f) {
                if (flag || this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                    // empty if block
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    public abstract double func_70042_X();

    protected boolean func_184228_n(Entity entityIn) {
        return true;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_150297_b("maxSpeed", 5)) {
            this.setMaxSpeed(compound.func_74760_g("maxSpeed"));
        }
        if (compound.func_150297_b("accelerationSpeed", 5)) {
            this.setAccelerationSpeed(compound.func_74760_g("accelerationSpeed"));
        }
        if (compound.func_150297_b("turnSensitivity", 3)) {
            this.setTurnSensitivity(compound.func_74762_e("turnSensitivity"));
        }
        if (compound.func_150297_b("maxTurnAngle", 3)) {
            this.setMaxTurnAngle(compound.func_74762_e("maxTurnAngle"));
        }
        if (compound.func_150297_b("stepHeight", 5)) {
            this.field_70138_W = compound.func_74760_g("stepHeight");
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74776_a("maxSpeed", this.getMaxSpeed());
        compound.func_74776_a("accelerationSpeed", this.getAccelerationSpeed());
        compound.func_74768_a("turnSensitivity", this.getTurnSensitivity());
        compound.func_74768_a("maxTurnAngle", this.getMaxTurnAngle());
        compound.func_74776_a("stepHeight", this.field_70138_W);
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        passenger.field_70177_z -= this.deltaYaw;
        passenger.func_70034_d(passenger.field_70177_z);
        this.applyYawToEntity(passenger);
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-120.0f, (float)120.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    public boolean isMoving() {
        return this.currentSpeed != 0.0f;
    }

    public void setMaxSpeed(float maxSpeed) {
        this.field_70180_af.func_187227_b(MAX_SPEED, (Object)Float.valueOf(maxSpeed));
    }

    public float getMaxSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(MAX_SPEED)).floatValue();
    }

    public void setSpeed(float speed) {
        this.field_70180_af.func_187227_b(CURRENT_SPEED, (Object)Float.valueOf(speed));
    }

    public float getSpeed() {
        return this.currentSpeed;
    }

    public float getNormalSpeed() {
        return this.currentSpeed / this.getMaxSpeed();
    }

    public float getAccelerationSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(ACCELERATION_SPEED)).floatValue();
    }

    public void setAccelerationSpeed(float speed) {
        this.field_70180_af.func_187227_b(ACCELERATION_SPEED, (Object)Float.valueOf(speed));
    }

    public double getKilometersPreHour() {
        return Math.sqrt(Math.pow(this.field_70165_t - this.field_70169_q, 2.0) + Math.pow(this.field_70161_v - this.field_70166_s, 2.0)) * 20.0;
    }

    public void setTurnDirection(TurnDirection turnDirection) {
        this.field_70180_af.func_187227_b(TURN_DIRECTION, (Object)turnDirection.ordinal());
    }

    public TurnDirection getTurnDirection() {
        return TurnDirection.values()[(Integer)this.field_70180_af.func_187225_a(TURN_DIRECTION)];
    }

    public void setAcceleration(AccelerationDirection direction) {
        this.field_70180_af.func_187227_b(ACCELERATION_DIRECTION, (Object)direction.ordinal());
    }

    public AccelerationDirection getAcceleration() {
        return AccelerationDirection.values()[(Integer)this.field_70180_af.func_187225_a(ACCELERATION_DIRECTION)];
    }

    public void setAccelerationMultiplier(float boop) {
        this.accelerationMultiplier = boop;
    }

    public float getAccelerationMultiplier() {
        return this.accelerationMultiplier;
    }

    public void setTurnSensitivity(int sensitivity) {
        this.field_70180_af.func_187227_b(TURN_SENSITIVITY, (Object)sensitivity);
    }

    public int getTurnSensitivity() {
        return (Integer)this.field_70180_af.func_187225_a(TURN_SENSITIVITY);
    }

    public void setMaxTurnAngle(int turnAngle) {
        this.field_70180_af.func_187227_b(MAX_TURN_ANGLE, (Object)turnAngle);
    }

    public int getMaxTurnAngle() {
        return (Integer)this.field_70180_af.func_187225_a(MAX_TURN_ANGLE);
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT);
    }

    public void setDamageTaken(float damageTaken) {
        this.field_70180_af.func_187227_b(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE_TAKEN)).floatValue();
    }

    public Vec3d getEngineSmokePosition() {
        return new Vec3d(0.0, 0.0, 0.0);
    }

    public boolean shouldShowEngineSmoke() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = 10;
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184186_bw() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.field_70165_t = this.lerpX;
            this.field_70163_u = this.lerpY;
            this.field_70161_v = this.lerpZ;
            this.field_70177_z = (float)this.lerpYaw;
            this.field_70125_A = (float)this.lerpPitch;
        }
    }

    public static enum AccelerationDirection {
        FORWARD,
        NONE,
        REVERSE;


        public static AccelerationDirection fromEntity(EntityLivingBase entity) {
            if (entity.field_191988_bg > 0.0f) {
                return FORWARD;
            }
            if (entity.field_191988_bg < 0.0f) {
                return REVERSE;
            }
            return NONE;
        }
    }

    public static enum TurnDirection {
        LEFT(1),
        FORWARD(0),
        RIGHT(-1);

        final int dir;

        private TurnDirection(int dir) {
            this.dir = dir;
        }

        public int getDir() {
            return this.dir;
        }
    }
}

