/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.util.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lucraft.mods.lucraftcore.superpowers.ModuleSuperpowers;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityStrength;
import lucraft.mods.lucraftcore.superpowers.suitsets.SuitSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class LCEntityHelper {
    public static boolean isInFrontOfEntity(Entity entity, Entity target) {
        Vec3d vec3d = target.func_174791_d();
        Vec3d vec3d1 = entity.func_70676_i(1.0f);
        Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)).func_72432_b();
        vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
        return vec3d2.func_72430_b(vec3d1) < 0.0;
    }

    public static Entity getEntityByUUID(World world, UUID uuid) {
        for (Entity entity : world.field_72996_f) {
            if (!entity.getPersistentID().equals(uuid)) continue;
            return entity;
        }
        return null;
    }

    public static Entity entityDropItem(EntityLivingBase entity, ItemStack stack, float offsetY, boolean removeFromInv) {
        if (stack.func_190926_b()) {
            return null;
        }
        if (removeFromInv) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    if (player.field_71071_by.func_70301_a(i) != stack) continue;
                    player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                    break;
                }
            } else {
                for (EntityPlayer slots : EntityEquipmentSlot.values()) {
                    if (entity.func_184582_a((EntityEquipmentSlot)slots) != stack) continue;
                    entity.func_184201_a((EntityEquipmentSlot)slots, ItemStack.field_190927_a);
                    break;
                }
            }
        }
        EntityItem entityitem = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u + (double)offsetY, entity.field_70161_v, stack);
        entityitem.func_174869_p();
        if (stack.func_77973_b().hasCustomEntity(stack)) {
            Entity entityNew = stack.func_77973_b().createEntity(entity.field_70170_p, (Entity)entityitem, stack);
            entity.field_70170_p.func_72838_d(entityNew);
            return entityNew;
        }
        entity.field_70170_p.func_72838_d((Entity)entityitem);
        return entityitem;
    }

    public static List<ItemStack> setSuitOfPlayer(EntityLivingBase entity, SuitSet suit) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (suit.getHelmet() != null) {
            if (!entity.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b()) {
                list.add(entity.func_184582_a(EntityEquipmentSlot.HEAD));
            }
            entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(suit.getHelmet()));
        }
        if (suit.getChestplate() != null) {
            if (!entity.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b()) {
                list.add(entity.func_184582_a(EntityEquipmentSlot.CHEST));
            }
            entity.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(suit.getChestplate()));
        }
        if (suit.getLegs() != null) {
            if (!entity.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b()) {
                list.add(entity.func_184582_a(EntityEquipmentSlot.LEGS));
            }
            entity.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(suit.getLegs()));
        }
        if (suit.getBoots() != null) {
            if (!entity.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b()) {
                list.add(entity.func_184582_a(EntityEquipmentSlot.FEET));
            }
            entity.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(suit.getBoots()));
        }
        return list;
    }

    public static ItemStack getItemStackInHandSide(EntityLivingBase entity, EnumHandSide side) {
        if (side == EnumHandSide.RIGHT) {
            return entity.func_184591_cq() == EnumHandSide.RIGHT ? entity.func_184614_ca() : entity.func_184592_cb();
        }
        return entity.func_184591_cq() == EnumHandSide.LEFT ? entity.func_184614_ca() : entity.func_184592_cb();
    }

    public static boolean hasNoArmor(EntityLivingBase entity) {
        return entity.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && entity.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() && entity.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b() && entity.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b();
    }

    public static double horizontalDistance(Entity entity1, Entity entity2) {
        float f = (float)(entity1.field_70165_t - entity2.field_70165_t);
        float f1 = (float)(entity1.field_70161_v - entity2.field_70161_v);
        return MathHelper.func_76129_c((float)(f * f + f1 * f1));
    }

    public static double verticalDistance(Entity entity1, Entity entity2) {
        return entity2.field_70163_u - entity1.field_70163_u;
    }

    public static double getStrength(EntityLivingBase entity) {
        double d = 2.0;
        if (ModuleSuperpowers.INSTANCE.isEnabled()) {
            List<AbilityStrength> list = Ability.getAbilitiesFromClass(Ability.getAbilities(entity), AbilityStrength.class);
            list.sort((a1, a2) -> a1.getOperation() > a2.getOperation() ? 1 : (a1.getOperation() < a2.getOperation() ? -1 : 0));
            double multiplicate = 0.0;
            for (AbilityStrength strength : list) {
                if (strength.getOperation() == 0) {
                    d += (double)strength.getAmount();
                    continue;
                }
                if (strength.getOperation() != 1) continue;
                multiplicate += (double)strength.getAmount();
            }
            d *= 1.0 + multiplicate;
            for (AbilityStrength strength : list) {
                if (strength.getOperation() != 2) continue;
                d *= (double)(1.0f + strength.getAmount());
            }
        }
        return d;
    }

    public static boolean isStrongEnough(EntityLivingBase entity, double weight) {
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_() || !ModuleSuperpowers.INSTANCE.isEnabled()) {
            return true;
        }
        return LCEntityHelper.getStrength(entity) >= weight;
    }
}

