/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.util.helper;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="lucraftcore", value={Side.CLIENT})
public class LCRenderHelper {
    public static Minecraft mc = Minecraft.func_71410_x();
    public static final ResourceLocation utils = new ResourceLocation("lucraftcore", "textures/gui/utils.png");
    public static ResourceLocation iconTex = new ResourceLocation("lucraftcore", "textures/gui/icons.png");
    public static float renderTick;
    private static float lastBrightnessX;
    private static float lastBrightnessY;

    @SubscribeEvent
    public static void renderTick(TickEvent.RenderTickEvent e) {
        renderTick = e.renderTickTime;
    }

    public static void drawIcon(Minecraft mc, Gui gui, int x, int y, int row, int column) {
        mc.field_71446_o.func_110577_a(iconTex);
        gui.func_73729_b(x, y, column * 16, row * 16, 16, 16);
    }

    public static void drawIcon(Minecraft mc, int x, int y, int row, int column) {
        LCRenderHelper.drawIcon(mc, (Gui)mc.field_71456_v, x, y, row, column);
    }

    public static void drawStringWithOutline(String string, int posX, int posY, int fontColor, int outlineColor) {
        LCRenderHelper.mc.field_71466_p.func_78276_b(string, posX + 1, posY, outlineColor);
        LCRenderHelper.mc.field_71466_p.func_78276_b(string, posX - 1, posY, outlineColor);
        LCRenderHelper.mc.field_71466_p.func_78276_b(string, posX, posY + 1, outlineColor);
        LCRenderHelper.mc.field_71466_p.func_78276_b(string, posX, posY - 1, outlineColor);
        LCRenderHelper.mc.field_71466_p.func_78276_b(string, posX, posY, fontColor);
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldrenderer.func_181662_b((double)right, (double)top, 300.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        worldrenderer.func_181662_b((double)left, (double)top, 300.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        worldrenderer.func_181662_b((double)left, (double)bottom, 300.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        worldrenderer.func_181662_b((double)right, (double)bottom, 300.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, Vec3i color1, float alpha1, Vec3i color2, float alpha2) {
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldrenderer.func_181662_b((double)right, (double)top, 300.0).func_181666_a((float)color1.func_177958_n(), (float)color1.func_177956_o(), (float)color1.func_177952_p(), alpha1).func_181675_d();
        worldrenderer.func_181662_b((double)left, (double)top, 300.0).func_181666_a((float)color1.func_177958_n(), (float)color1.func_177956_o(), (float)color1.func_177952_p(), alpha1).func_181675_d();
        worldrenderer.func_181662_b((double)left, (double)bottom, 300.0).func_181666_a((float)color2.func_177958_n(), (float)color2.func_177956_o(), (float)color2.func_177952_p(), alpha2).func_181675_d();
        worldrenderer.func_181662_b((double)right, (double)bottom, 300.0).func_181666_a((float)color2.func_177958_n(), (float)color2.func_177956_o(), (float)color2.func_177952_p(), alpha2).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawRect(int left, int top, int right, int bottom, float red, float green, float blue, float alpha) {
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b((double)left, (double)bottom, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)right, (double)bottom, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)right, (double)top, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawEnergyBar(Gui gui, IEnergyStorage container, Minecraft mc, int x, int y) {
        mc.field_71446_o.func_110577_a(utils);
        int progress = (int)((float)container.getEnergyStored() / (float)container.getMaxEnergyStored() * 42.0f);
        gui.func_73729_b(x, y, 0, 0, 14, 42);
        gui.func_73729_b(x, y + 42 - progress, 14, 42 - progress, 14, progress);
    }

    public static void drawEnergyBar(Gui gui, IEnergyStorage container, Minecraft mc, int x, int y, int mouseX, int mouseY) {
        boolean hovered;
        LCRenderHelper.drawEnergyBar(gui, container, mc, x, y);
        boolean bl = hovered = mouseX >= x && mouseY >= y && mouseX < x + 14 && mouseY < y + 42;
        if (hovered) {
            LCRenderHelper.drawStringList(Arrays.asList(container.getEnergyStored() + "/" + container.getMaxEnergyStored() + " RF"), mouseX + 10, mouseY, true);
        }
    }

    public static void drawStringList(List<String> list, int posX, int posY, boolean drawBackground) {
        LCRenderHelper.drawStringList(list, posX, posY, 10, drawBackground);
    }

    public static void drawStringList(List<String> list, int posX, int posY, int differencePerLine, boolean drawBackground) {
        int i;
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        int longestString = 0;
        for (i = 0; i < list.size(); ++i) {
            if (longestString >= LCRenderHelper.mc.field_71466_p.func_78256_a(list.get(i))) continue;
            longestString = LCRenderHelper.mc.field_71466_p.func_78256_a(list.get(i));
        }
        if (drawBackground) {
            int color1 = -267386864;
            int color2 = 0x505000FF;
            int color3 = (color2 & 0xFEFEFE) >> 1 | color2 & 0xFF000000;
            LCRenderHelper.drawGradientRect(posX - 3, posY - 3, posX + longestString + 3, posY + list.size() * differencePerLine + 3, color1, color1);
            LCRenderHelper.drawGradientRect(posX - 4, posY - 4, posX + longestString + 4, posY - 3, color2, color2);
            LCRenderHelper.drawGradientRect(posX - 4, posY - 3, posX + -3, posY + list.size() * differencePerLine + 3, color2, color3);
            LCRenderHelper.drawGradientRect(posX + 3 + longestString, posY - 3, posX + 4 + longestString, posY + list.size() * differencePerLine + 3, color2, color3);
            LCRenderHelper.drawGradientRect(posX - 4, posY + list.size() * differencePerLine + 3, posX + longestString + 4, posY + list.size() * differencePerLine + 4, color3, color3);
        }
        for (i = 0; i < list.size(); ++i) {
            LCRenderHelper.mc.field_71466_p.func_175063_a(list.get(i), (float)posX, (float)(posY + i * differencePerLine), -1);
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
        GlStateManager.func_179091_B();
    }

    public static void drawFireBar(Gui gui, float process, Minecraft mc, int x, int y) {
        mc.field_71446_o.func_110577_a(utils);
        int i = (int)(process * 14.0f);
        gui.func_73729_b(x + 1, y, 0, 42, 13, 14);
        gui.func_73729_b(x, y + 14 - i, 13, 56 - i, 14, i);
    }

    public static void renderFire(Minecraft mc, String texture) {
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        TextureAtlasSprite sprite = mc.func_147117_R().getTextureExtry(texture);
        GlStateManager.func_179094_E();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(1.0, 0.0, 1.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(1.0, 1.0, 1.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, 1.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(1.0, 0.0, 1.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(1.0, 1.0, 1.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(0.0, 1.0, 1.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, 1.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(0.0, 1.0, 1.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(1.0, 1.0, 1.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(0.0, 1.0, 1.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(1.0, 1.0, 1.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(0.0, 1.0, 1.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(1.0, 1.0, 1.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(0.0, 1.0, 1.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(1.0, 1.0, 1.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(0.0, 1.0, 1.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    public static void setLightmapTextureCoords(float x, float y) {
        lastBrightnessX = OpenGlHelper.lastBrightnessX;
        lastBrightnessY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)x, (float)y);
    }

    public static void restoreLightmapTextureCoords() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
    }

    public static void setupRenderLightning() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)32772);
        GlStateManager.func_179092_a((int)516, (float)0.003921569f);
        LCRenderHelper.setLightmapTextureCoords(240.0f, 240.0f);
    }

    public static void finishRenderLightning() {
        LCRenderHelper.restoreLightmapTextureCoords();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public static void drawLine(Vec3d start, Vec3d end, float lineWidth, float innerLineWidth, Color color, float alpha) {
        if (start == null || end == null) {
            return;
        }
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder wr = tes.func_178180_c();
        if (lineWidth > 0.0f) {
            GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)alpha);
            GlStateManager.func_187441_d((float)lineWidth);
            wr.func_181668_a(3, DefaultVertexFormats.field_181705_e);
            wr.func_181662_b(start.field_72450_a, start.field_72448_b, start.field_72449_c).func_181675_d();
            wr.func_181662_b(end.field_72450_a, end.field_72448_b, end.field_72449_c).func_181675_d();
            tes.func_78381_a();
        }
        if (innerLineWidth > 0.0f) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)MathHelper.func_76131_a((float)(alpha - 0.2f), (float)0.0f, (float)1.0f));
            GlStateManager.func_187441_d((float)innerLineWidth);
            wr.func_181668_a(3, DefaultVertexFormats.field_181705_e);
            wr.func_181662_b(start.field_72450_a, start.field_72448_b, start.field_72449_c).func_181675_d();
            wr.func_181662_b(end.field_72450_a, end.field_72448_b, end.field_72449_c).func_181675_d();
            tes.func_78381_a();
        }
    }

    public static void drawGlowingLine(Vec3d start, Vec3d end, float thickness, Color color) {
        LCRenderHelper.drawGlowingLine(start, end, thickness, color, 1.0f);
    }

    public static void drawGlowingLine(Vec3d start, Vec3d end, float thickness, Color color, float alpha) {
        if (start == null || end == null) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bb = tessellator.func_178180_c();
        int smoothFactor = Minecraft.func_71410_x().field_71474_y.field_74348_k;
        int layers = 10 + smoothFactor * 20;
        GlStateManager.func_179094_E();
        start = start.func_186678_a(-1.0);
        end = end.func_186678_a(-1.0);
        GlStateManager.func_179137_b((double)(-start.field_72450_a), (double)(-start.field_72448_b), (double)(-start.field_72449_c));
        start = end.func_178788_d(start);
        end = end.func_178788_d(end);
        double x = end.field_72450_a - start.field_72450_a;
        double y = end.field_72448_b - start.field_72448_b;
        double z = end.field_72449_c - start.field_72449_c;
        double diff = MathHelper.func_76133_a((double)(x * x + z * z));
        float yaw = (float)(Math.atan2(z, x) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(y, diff) * 180.0 / Math.PI));
        GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        for (int layer = 0; layer <= layers; ++layer) {
            if (layer < layers) {
                GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)(1.0f / (float)layers / 2.0f));
                GlStateManager.func_179132_a((boolean)false);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                GlStateManager.func_179132_a((boolean)true);
            }
            double size = (double)thickness + (layer < layers ? (double)layer * (1.25 / (double)layers) : 0.0);
            double d = (layer < layers ? 1.0 - (double)layer * (1.0 / (double)layers) : 0.0) * 0.1;
            double width = 0.0625 * size;
            double height = 0.0625 * size;
            double length = start.func_72438_d(end) + d;
            bb.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            bb.func_181662_b(-width, height, length).func_181675_d();
            bb.func_181662_b(width, height, length).func_181675_d();
            bb.func_181662_b(width, height, -d).func_181675_d();
            bb.func_181662_b(-width, height, -d).func_181675_d();
            bb.func_181662_b(width, -height, -d).func_181675_d();
            bb.func_181662_b(width, -height, length).func_181675_d();
            bb.func_181662_b(-width, -height, length).func_181675_d();
            bb.func_181662_b(-width, -height, -d).func_181675_d();
            bb.func_181662_b(-width, -height, -d).func_181675_d();
            bb.func_181662_b(-width, -height, length).func_181675_d();
            bb.func_181662_b(-width, height, length).func_181675_d();
            bb.func_181662_b(-width, height, -d).func_181675_d();
            bb.func_181662_b(width, height, length).func_181675_d();
            bb.func_181662_b(width, -height, length).func_181675_d();
            bb.func_181662_b(width, -height, -d).func_181675_d();
            bb.func_181662_b(width, height, -d).func_181675_d();
            bb.func_181662_b(width, -height, length).func_181675_d();
            bb.func_181662_b(width, height, length).func_181675_d();
            bb.func_181662_b(-width, height, length).func_181675_d();
            bb.func_181662_b(-width, -height, length).func_181675_d();
            bb.func_181662_b(width, -height, -d).func_181675_d();
            bb.func_181662_b(width, height, -d).func_181675_d();
            bb.func_181662_b(-width, height, -d).func_181675_d();
            bb.func_181662_b(-width, -height, -d).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179121_F();
    }

    public static void drawCuboidLine(Vec3d start, Vec3d end, float thickness, Color color, float alpha) {
        if (start == null || end == null) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bb = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        start = start.func_186678_a(-1.0);
        end = end.func_186678_a(-1.0);
        GlStateManager.func_179137_b((double)(-start.field_72450_a), (double)(-start.field_72448_b), (double)(-start.field_72449_c));
        start = end.func_178788_d(start);
        end = end.func_178788_d(end);
        double x = end.field_72450_a - start.field_72450_a;
        double y = end.field_72448_b - start.field_72448_b;
        double z = end.field_72449_c - start.field_72449_c;
        double diff = MathHelper.func_76133_a((double)(x * x + z * z));
        float yaw = (float)(Math.atan2(z, x) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(y, diff) * 180.0 / Math.PI));
        GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)alpha);
        double size = thickness;
        double d = 0.0;
        double width = 0.0625 * size;
        double height = 0.0625 * size;
        double length = start.func_72438_d(end) + d;
        bb.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bb.func_181662_b(-width, height, length).func_181675_d();
        bb.func_181662_b(width, height, length).func_181675_d();
        bb.func_181662_b(width, height, -d).func_181675_d();
        bb.func_181662_b(-width, height, -d).func_181675_d();
        bb.func_181662_b(width, -height, -d).func_181675_d();
        bb.func_181662_b(width, -height, length).func_181675_d();
        bb.func_181662_b(-width, -height, length).func_181675_d();
        bb.func_181662_b(-width, -height, -d).func_181675_d();
        bb.func_181662_b(-width, -height, -d).func_181675_d();
        bb.func_181662_b(-width, -height, length).func_181675_d();
        bb.func_181662_b(-width, height, length).func_181675_d();
        bb.func_181662_b(-width, height, -d).func_181675_d();
        bb.func_181662_b(width, height, length).func_181675_d();
        bb.func_181662_b(width, -height, length).func_181675_d();
        bb.func_181662_b(width, -height, -d).func_181675_d();
        bb.func_181662_b(width, height, -d).func_181675_d();
        bb.func_181662_b(width, -height, length).func_181675_d();
        bb.func_181662_b(width, height, length).func_181675_d();
        bb.func_181662_b(-width, height, length).func_181675_d();
        bb.func_181662_b(-width, -height, length).func_181675_d();
        bb.func_181662_b(width, -height, -d).func_181675_d();
        bb.func_181662_b(width, height, -d).func_181675_d();
        bb.func_181662_b(-width, height, -d).func_181675_d();
        bb.func_181662_b(-width, -height, -d).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    public static void drawLightnings(float thickness, Color color, List<Vec3d[]> fragments) {
        LCRenderHelper.setupRenderLightning();
        for (Vec3d[] v : fragments) {
            LCRenderHelper.drawGlowingLine(v[0], v[1], thickness, color);
        }
        LCRenderHelper.finishRenderLightning();
    }

    public static List<Vec3d[]> getRandomLightningCoords(Vec3d start, Vec3d end, Random rand) {
        ArrayList<Vec3d> parts = new ArrayList<Vec3d>();
        int fragments = 3 + rand.nextInt(3);
        Vec3d vec = end.func_178788_d(start).func_186678_a(1.0 / (double)fragments);
        parts.add(start);
        for (int i = 0; i < fragments; ++i) {
            Vec3d v = vec.func_186678_a((double)i);
            parts.add(start.func_72441_c(v.field_72450_a + (double)(rand.nextFloat() - 0.5f) / 1.5, v.field_72448_b + (double)(rand.nextFloat() - 0.5f) / 1.5, v.field_72449_c + (double)(rand.nextFloat() - 0.5f) / 1.5));
        }
        parts.add(end);
        ArrayList<Vec3d[]> coords = new ArrayList<Vec3d[]>();
        for (int i = 0; i < parts.size(); ++i) {
            if (i >= parts.size() - 1) continue;
            coords.add(new Vec3d[]{(Vec3d)parts.get(i), (Vec3d)parts.get(i + 1)});
        }
        return coords;
    }

    public static void drawRandomLightningCoordsInAABB(float thickness, Color color, AxisAlignedBB box, Random rand) {
        int lightningAmount = 3 + rand.nextInt(4);
        for (int i = 0; i < lightningAmount; ++i) {
            Vec3d start = new Vec3d(box.field_72340_a + rand.nextDouble() * (box.field_72336_d - box.field_72340_a), box.field_72338_b + rand.nextDouble() * (box.field_72337_e - box.field_72338_b), box.field_72339_c + rand.nextDouble() * (box.field_72334_f - box.field_72339_c));
            Vec3d end = new Vec3d(box.field_72340_a + rand.nextDouble() * (box.field_72336_d - box.field_72340_a), box.field_72338_b + rand.nextDouble() * (box.field_72337_e - box.field_72338_b), box.field_72339_c + rand.nextDouble() * (box.field_72334_f - box.field_72339_c));
            while (start.func_72438_d(end) > (double)0.2f) {
                end = new Vec3d(box.field_72340_a + rand.nextDouble() * (box.field_72336_d - box.field_72340_a), box.field_72338_b + rand.nextDouble() * (box.field_72337_e - box.field_72338_b), box.field_72339_c + rand.nextDouble() * (box.field_72334_f - box.field_72339_c));
            }
            LCRenderHelper.drawGlowingLine(start, end, thickness, color);
        }
    }

    public static double interpolateValue(double start, double end, double pct) {
        return start + (end - start) * pct;
    }

    public static void renderTiledFluid(int x, int y, int width, float depth, FluidTank fluidStack) {
        if (fluidStack != null && fluidStack.getFluid() != null && fluidStack.getFluid().getFluid() != null) {
            float fluidTankHeight = 60.0f;
            float o = fluidTankHeight / (float)fluidStack.getCapacity();
            int h = Math.round(o * (float)fluidStack.getFluidAmount());
            int x2 = x;
            int y2 = (int)((float)y + fluidTankHeight - (float)h);
            TextureAtlasSprite fluidSprite = mc.func_147117_R().func_110572_b(fluidStack.getFluid().getFluid().getStill(fluidStack.getFluid()).toString());
            LCRenderHelper.setColorRGBA(fluidStack.getFluid().getFluid().getColor(fluidStack.getFluid()));
            LCRenderHelper.renderTiledTextureAtlas(x2, y2, width, h, depth, fluidSprite);
        }
    }

    public static void renderTiledTextureAtlas(int x, int y, int width, int height, float depth, TextureAtlasSprite sprite) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bb = tessellator.func_178180_c();
        bb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        LCRenderHelper.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        LCRenderHelper.putTiledTextureQuads(bb, x, y, width, height, depth, sprite);
        tessellator.func_78381_a();
    }

    public static void putTiledTextureQuads(BufferBuilder renderer, int x, int y, int width, int height, float depth, TextureAtlasSprite sprite) {
        float u1 = sprite.func_94209_e();
        float v1 = sprite.func_94206_g();
        do {
            int renderHeight = Math.min(sprite.func_94216_b(), height);
            height -= renderHeight;
            float v2 = sprite.func_94207_b((double)(16.0f * (float)renderHeight / (float)sprite.func_94216_b()));
            int x2 = x;
            int width2 = width;
            do {
                int renderWidth = Math.min(sprite.func_94211_a(), width2);
                width2 -= renderWidth;
                float u2 = sprite.func_94214_a((double)(16.0f * (float)renderWidth / (float)sprite.func_94211_a()));
                renderer.func_181662_b((double)x2, (double)y, (double)depth).func_187315_a((double)u1, (double)v1).func_181675_d();
                renderer.func_181662_b((double)x2, (double)(y + renderHeight), (double)depth).func_187315_a((double)u1, (double)v2).func_181675_d();
                renderer.func_181662_b((double)(x2 + renderWidth), (double)(y + renderHeight), (double)depth).func_187315_a((double)u2, (double)v2).func_181675_d();
                renderer.func_181662_b((double)(x2 + renderWidth), (double)y, (double)depth).func_187315_a((double)u2, (double)v1).func_181675_d();
                x2 += renderWidth;
            } while (width2 > 0);
            y += renderHeight;
        } while (height > 0);
    }

    public static void setColorRGBA(int color) {
        float a = (float)LCRenderHelper.alpha(color) / 255.0f;
        float r = (float)LCRenderHelper.red(color) / 255.0f;
        float g = (float)LCRenderHelper.green(color) / 255.0f;
        float b = (float)LCRenderHelper.blue(color) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
    }

    public static int alpha(int c) {
        return c >> 24 & 0xFF;
    }

    public static int red(int c) {
        return c >> 16 & 0xFF;
    }

    public static int green(int c) {
        return c >> 8 & 0xFF;
    }

    public static int blue(int c) {
        return c & 0xFF;
    }

    public static void animX(BufferedImage image, int startX, int startY, int endX, int endY, float progress) {
        for (int x = Math.min(startX, endX); x < Math.max(startX, endX); ++x) {
            for (int y = Math.min(startY, endY); y < Math.max(startY, endY); ++y) {
                boolean v;
                int i = image.getRGB(x, y);
                if (i == 0) continue;
                boolean bl = startX < endX ? (float)y < (float)startX + progress * (float)(endX - startX) : (v = (float)y >= (float)startX + progress * (float)(endX - startX));
                if (v) continue;
                image.setRGB(x, y, 0);
            }
        }
    }

    public static void animY(BufferedImage image, int startX, int startY, int endX, int endY, float progress) {
        LCRenderHelper.animY(image, startX, startY, endX, endY, progress, false);
    }

    public static void animY(BufferedImage image, int startX, int startY, int endX, int endY, float progress, boolean trans) {
        for (int x = Math.min(startX, endX); x < Math.max(startX, endX); ++x) {
            for (int y = Math.min(startY, endY); y < Math.max(startY, endY); ++y) {
                int i = image.getRGB(x, y);
                if (i != 0 && Integer.toHexString(i).length() > 2) {
                    boolean v;
                    boolean bl = startY < endY ? (float)y < (float)startY + progress * (float)(endY - startY) : (v = (float)y >= (float)startY + progress * (float)(endY - startY));
                    if (!v) {
                        image.setRGB(x, y, 0);
                    }
                }
                if (!trans || y != (int)((float)startY + progress * (float)(endY - startY))) continue;
                Random rand = new Random();
                String red = Integer.toHexString(191 + rand.nextInt(64));
                String green = Integer.toHexString(rand.nextInt(34));
                String blue = Integer.toHexString(153 + rand.nextInt(57));
                image.setRGB(x, y, (int)Long.parseLong("ff" + red + green + blue, 16));
            }
        }
    }

    public static void setOpacity(BufferedImage image, int startX, int startY, int endX, int endY, float opacity) {
        for (int x = Math.min(startX, endX); x < Math.max(startX, endX); ++x) {
            for (int y = Math.min(startY, endY); y < Math.max(startY, endY); ++y) {
                int i = image.getRGB(x, y);
                if (i == 0) continue;
                if (opacity == 0.0f) {
                    image.setRGB(x, y, 0);
                    continue;
                }
                if (Integer.toHexString(i).length() < 2) continue;
                String rgb = Integer.toHexString(i).substring(2);
                String newRgb = Integer.toHexString((int)(opacity * 255.0f)) + rgb;
                image.setRGB(x, y, (int)Long.parseLong(newRgb, 16));
            }
        }
    }

    static {
        lastBrightnessX = OpenGlHelper.lastBrightnessX;
        lastBrightnessY = OpenGlHelper.lastBrightnessY;
    }
}

