/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.util.helper.mods;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class ThermalExpansionHelper {
    static final String MOD_ID = "thermalexpansion";
    static final String ENERGY = "energy";
    static final String FLUID_NAME = "fluidName";
    static final String INPUT = "input";
    static final String OUTPUT = "output";
    static final String PRIMARY_INPUT = "primaryInput";
    static final String SECONDARY_INPUT = "secondaryInput";
    static final String PRIMARY_OUTPUT = "primaryOutput";
    static final String SECONDARY_OUTPUT = "secondaryOutput";
    static final String SECONDARY_CHANCE = "secondaryChance";

    public static void addFurnaceRecipe(int energy, ItemStack input, ItemStack output) {
        if (input.func_190926_b() || output.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"AddFurnaceRecipe", (NBTTagCompound)toSend);
    }

    public static void removeFurnaceRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"RemoveFurnaceRecipe", (NBTTagCompound)toSend);
    }

    public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput) {
        ThermalExpansionHelper.addPulverizerRecipe(energy, input, primaryOutput, ItemStack.field_190927_a, 0);
    }

    public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
        ThermalExpansionHelper.addPulverizerRecipe(energy, input, primaryOutput, secondaryOutput, 100);
    }

    public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (input.func_190926_b() || primaryOutput.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(PRIMARY_OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        primaryOutput.func_77955_b(toSend.func_74775_l(PRIMARY_OUTPUT));
        if (!secondaryOutput.func_190926_b()) {
            toSend.func_74782_a(SECONDARY_OUTPUT, (NBTBase)new NBTTagCompound());
            secondaryOutput.func_77955_b(toSend.func_74775_l(SECONDARY_OUTPUT));
            toSend.func_74768_a(SECONDARY_CHANCE, secondaryChance);
        }
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"AddPulverizerRecipe", (NBTTagCompound)toSend);
    }

    public static void removePulverizerRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"RemovePulverizerRecipe", (NBTTagCompound)toSend);
    }

    public static void addSawmillRecipe(int energy, ItemStack input, ItemStack primaryOutput) {
        ThermalExpansionHelper.addSawmillRecipe(energy, input, primaryOutput, ItemStack.field_190927_a, 0);
    }

    public static void addSawmillRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
        ThermalExpansionHelper.addSawmillRecipe(energy, input, primaryOutput, secondaryOutput, 100);
    }

    public static void addSawmillRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (input.func_190926_b() || primaryOutput.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(PRIMARY_OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        primaryOutput.func_77955_b(toSend.func_74775_l(PRIMARY_OUTPUT));
        if (!secondaryOutput.func_190926_b()) {
            toSend.func_74782_a(SECONDARY_OUTPUT, (NBTBase)new NBTTagCompound());
            secondaryOutput.func_77955_b(toSend.func_74775_l(SECONDARY_OUTPUT));
            toSend.func_74768_a(SECONDARY_CHANCE, secondaryChance);
        }
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"AddSawmillRecipe", (NBTTagCompound)toSend);
    }

    public static void removeSawmillRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"RemoveSawmillRecipe", (NBTTagCompound)toSend);
    }

    public static void addSmelterRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput) {
        ThermalExpansionHelper.addSmelterRecipe(energy, primaryInput, secondaryInput, primaryOutput, ItemStack.field_190927_a, 0);
    }

    public static void addSmelterRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput) {
        ThermalExpansionHelper.addSmelterRecipe(energy, primaryInput, secondaryInput, primaryOutput, secondaryOutput, 100);
    }

    public static void addSmelterRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (primaryInput.func_190926_b() || secondaryInput.func_190926_b() || primaryOutput.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(PRIMARY_INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(SECONDARY_INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(PRIMARY_OUTPUT, (NBTBase)new NBTTagCompound());
        primaryInput.func_77955_b(toSend.func_74775_l(PRIMARY_INPUT));
        secondaryInput.func_77955_b(toSend.func_74775_l(SECONDARY_INPUT));
        primaryOutput.func_77955_b(toSend.func_74775_l(PRIMARY_OUTPUT));
        if (!secondaryOutput.func_190926_b()) {
            toSend.func_74782_a(SECONDARY_OUTPUT, (NBTBase)new NBTTagCompound());
            secondaryOutput.func_77955_b(toSend.func_74775_l(SECONDARY_OUTPUT));
            toSend.func_74768_a(SECONDARY_CHANCE, secondaryChance);
        }
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"AddSmelterRecipe", (NBTTagCompound)toSend);
    }

    public static void removeSmelterRecipe(ItemStack primaryInput, ItemStack secondaryInput) {
        if (primaryInput.func_190926_b() || secondaryInput.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(PRIMARY_INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(SECONDARY_INPUT, (NBTBase)new NBTTagCompound());
        primaryInput.func_77955_b(toSend.func_74775_l(PRIMARY_INPUT));
        secondaryInput.func_77955_b(toSend.func_74775_l(SECONDARY_INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"RemoveSmelterRecipe", (NBTTagCompound)toSend);
    }

    public static void addInsolatorRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput) {
        ThermalExpansionHelper.addInsolatorRecipe(energy, primaryInput, secondaryInput, primaryOutput, ItemStack.field_190927_a, 0);
    }

    public static void addInsolatorRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput) {
        ThermalExpansionHelper.addInsolatorRecipe(energy, primaryInput, secondaryInput, primaryOutput, secondaryOutput, 100);
    }

    public static void addInsolatorRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (primaryInput.func_190926_b() || secondaryInput.func_190926_b() || primaryOutput.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(PRIMARY_INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(SECONDARY_INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(PRIMARY_OUTPUT, (NBTBase)new NBTTagCompound());
        primaryInput.func_77955_b(toSend.func_74775_l(PRIMARY_INPUT));
        secondaryInput.func_77955_b(toSend.func_74775_l(SECONDARY_INPUT));
        primaryOutput.func_77955_b(toSend.func_74775_l(PRIMARY_OUTPUT));
        if (!secondaryOutput.func_190926_b()) {
            toSend.func_74782_a(SECONDARY_OUTPUT, (NBTBase)new NBTTagCompound());
            secondaryOutput.func_77955_b(toSend.func_74775_l(SECONDARY_OUTPUT));
            toSend.func_74768_a(SECONDARY_CHANCE, secondaryChance);
        }
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"AddInsolatorRecipe", (NBTTagCompound)toSend);
    }

    public static void removeInsolatorRecipe(ItemStack primaryInput, ItemStack secondaryInput) {
        if (primaryInput.func_190926_b() || secondaryInput.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(PRIMARY_INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(SECONDARY_INPUT, (NBTBase)new NBTTagCompound());
        primaryInput.func_77955_b(toSend.func_74775_l(PRIMARY_INPUT));
        secondaryInput.func_77955_b(toSend.func_74775_l(SECONDARY_INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"RemoveInsolatorRecipe", (NBTTagCompound)toSend);
    }

    public static void addCompactorPressRecipe(int energy, ItemStack input, ItemStack output) {
        if (input.func_190926_b() || output.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"AddCompactorPressRecipe", (NBTTagCompound)toSend);
    }

    public static void addCompactorStorageRecipe(int energy, ItemStack input, ItemStack output) {
        if (input.func_190926_b() || output.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"AddCompactorStorageRecipe", (NBTTagCompound)toSend);
    }

    public static void addCompactorMintRecipe(int energy, ItemStack input, ItemStack output) {
        if (input.func_190926_b() || output.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"AddCompactorMintRecipe", (NBTTagCompound)toSend);
    }

    public static void removeCompactorPressRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"RemoveCompactorPressRecipe", (NBTTagCompound)toSend);
    }

    public static void removeCompactorStorageRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"RemoveCompactorStorageRecipe", (NBTTagCompound)toSend);
    }

    public static void removeCompactorMintRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"RemoveCompactorMintRecipe", (NBTTagCompound)toSend);
    }

    public static void addCrucibleRecipe(int energy, ItemStack input, FluidStack output) {
        if (input.func_190926_b() || output == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.writeToNBT(toSend.func_74775_l(OUTPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"AddCrucibleRecipe", (NBTTagCompound)toSend);
    }

    public static void removeCrucibleRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"RemoveCrucibleRecipe", (NBTTagCompound)toSend);
    }

    public static void addRefineryRecipe(int energy, FluidStack input, FluidStack output, ItemStack outputItem) {
        if (input == null || output == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        if (!outputItem.func_190926_b()) {
            toSend.func_74782_a(SECONDARY_OUTPUT, (NBTBase)new NBTTagCompound());
            outputItem.func_77955_b(toSend.func_74775_l(SECONDARY_OUTPUT));
        }
        input.writeToNBT(toSend.func_74775_l(INPUT));
        output.writeToNBT(toSend.func_74775_l(OUTPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"AddRefineryRecipe", (NBTTagCompound)toSend);
    }

    public static void removeRefineryRecipe(FluidStack input) {
        if (input == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.writeToNBT(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"RemoveRefineryRecipe", (NBTTagCompound)toSend);
    }

    public static void addTransposerFill(int energy, ItemStack input, ItemStack output, FluidStack fluid, boolean reversible) {
        if (input.func_190926_b() || output.func_190926_b() || fluid == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("fluid", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        toSend.func_74757_a("reversible", reversible);
        fluid.writeToNBT(toSend.func_74775_l("fluid"));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"AddTransposerFillRecipe", (NBTTagCompound)toSend);
    }

    public static void addTransposerExtract(int energy, ItemStack input, ItemStack output, FluidStack fluid, int chance, boolean reversible) {
        if (input.func_190926_b() || output.func_190926_b() || fluid == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("fluid", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        toSend.func_74757_a("reversible", reversible);
        toSend.func_74768_a("chance", chance);
        fluid.writeToNBT(toSend.func_74775_l("fluid"));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"AddTransposerExtractRecipe", (NBTTagCompound)toSend);
    }

    public static void removeTransposerFill(ItemStack input, FluidStack fluid) {
        if (input.func_190926_b() || fluid == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("fluid", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        fluid.writeToNBT(toSend.func_74775_l("fluid"));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"RemoveTransposerFillRecipe", (NBTTagCompound)toSend);
    }

    public static void removeTransposerExtract(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"RemoveTransposerExtractRecipe", (NBTTagCompound)toSend);
    }

    public static void addChargerRecipe(int energy, ItemStack input, ItemStack output) {
        if (input.func_190926_b() || output.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"AddChargerRecipe", (NBTTagCompound)toSend);
    }

    public static void removeChargerRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"RemoveChargerRecipe", (NBTTagCompound)toSend);
    }

    public static void addMagmaticFuel(String fluidName, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74778_a(FLUID_NAME, fluidName);
        toSend.func_74768_a(ENERGY, energy);
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"MagmaticFuel", (NBTTagCompound)toSend);
    }

    public static void addCompressionFuel(String fluidName, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74778_a(FLUID_NAME, fluidName);
        toSend.func_74768_a(ENERGY, energy);
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"CompressionFuel", (NBTTagCompound)toSend);
    }

    public static void addReactantFuel(String fluidName, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74778_a(FLUID_NAME, fluidName);
        toSend.func_74768_a(ENERGY, energy);
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"ReactantFuel", (NBTTagCompound)toSend);
    }

    public static void addCoolant(String fluidName, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74778_a(FLUID_NAME, fluidName);
        toSend.func_74768_a(ENERGY, energy);
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"Coolant", (NBTTagCompound)toSend);
    }
}

