/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.util.items;

import cofh.redstoneflux.api.IEnergyContainerItem;
import java.util.List;
import lucraft.mods.lucraftcore.util.energy.EnergyStorageItem;
import lucraft.mods.lucraftcore.util.energy.EnergyUtil;
import lucraft.mods.lucraftcore.util.items.ItemBase;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyContainerItem", modid="redstoneflux", striprefs=true)
public class ItemBaseEnergyStorage
extends ItemBase
implements IEnergyContainerItem {
    public int capacity;

    public ItemBaseEnergyStorage(String name, int capacity) {
        super(name);
        this.func_77625_d(1);
        this.capacity = capacity;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new EnergyItemCapabilityProvider(stack, this.capacity);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            tooltip.add(EnergyUtil.getFormattedEnergy((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)));
        }
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (!stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return 1.0;
        }
        double damage = 1.0 - (double)((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored() / (double)((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).getMaxEnergyStored();
        return damage;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack empty = new ItemStack((Item)this);
        ItemStack full = new ItemStack((Item)this);
        ((IEnergyStorage)full.getCapability(CapabilityEnergy.ENERGY, null)).receiveEnergy(((IEnergyStorage)full.getCapability(CapabilityEnergy.ENERGY, null)).getMaxEnergyStored(), false);
        items.add((Object)empty);
        items.add((Object)full);
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return ((IEnergyStorage)container.getCapability(CapabilityEnergy.ENERGY, null)).receiveEnergy(maxReceive, simulate);
        }
        return 0;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return ((IEnergyStorage)container.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(maxExtract, simulate);
        }
        return 0;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return ((IEnergyStorage)container.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored();
        }
        return 0;
    }

    public int getMaxEnergyStored(ItemStack container) {
        if (container.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return ((IEnergyStorage)container.getCapability(CapabilityEnergy.ENERGY, null)).getMaxEnergyStored();
        }
        return 0;
    }

    public static class EnergyItemCapabilityProvider<NBTBase>
    implements ICapabilityProvider {
        final ItemStack stack;
        final IEnergyStorage energyCap;

        public EnergyItemCapabilityProvider(ItemStack stack, int capacity) {
            this.stack = stack;
            this.energyCap = new EnergyStorageItem(stack, capacity);
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CapabilityEnergy.ENERGY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(capability == CapabilityEnergy.ENERGY ? CapabilityEnergy.ENERGY.cast((Object)this.energyCap) : null);
        }
    }
}

