/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.util.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeFactoryRecolor
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        Item original;
        String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        Item item = original = ForgeRegistries.ITEMS.containsKey(new ResourceLocation(JsonUtils.func_151200_h((JsonObject)json, (String)"original"))) ? (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JsonUtils.func_151200_h((JsonObject)json, (String)"original"))) : null;
        if (original == null) {
            throw new JsonParseException("Item '" + JsonUtils.func_151200_h((JsonObject)json, (String)"original") + "' does not exist!");
        }
        NonNullList ings = NonNullList.func_191196_a();
        for (JsonElement ele : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
            ings.add((Object)CraftingHelper.getIngredient((JsonElement)ele, (JsonContext)context));
        }
        if (ings.isEmpty()) {
            throw new JsonParseException("No ingredients for 'alternate' recipe");
        }
        if (ings.size() > 8) {
            throw new JsonParseException("Too many ingredients for 'alternate' recipe");
        }
        ItemStack itemstack = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
        return new RecipeRecolor(group, itemstack, original, (NonNullList<Ingredient>)ings);
    }

    public static class RecipeRecolor
    extends IForgeRegistryEntry.Impl<IRecipe>
    implements IRecipe {
        protected String group;
        public final ItemStack result;
        public final Item original;
        public final NonNullList<Ingredient> ingredientList;
        private final boolean isSimple;

        public RecipeRecolor(String group, ItemStack result, Item original, NonNullList<Ingredient> ingredientList) {
            this.group = group;
            this.result = result;
            this.original = original;
            this.ingredientList = ingredientList;
            boolean simple = true;
            for (Ingredient i : ingredientList) {
                simple &= i.isSimple();
            }
            this.isSimple = simple;
        }

        public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
            ArrayList<Ingredient> required = new ArrayList<Ingredient>((Collection<Ingredient>)this.ingredientList);
            boolean foundOriginal = false;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack slot = inv.func_70301_a(i);
                if (slot.func_190926_b()) continue;
                boolean inRecipe = false;
                Iterator<Ingredient> iterator = required.iterator();
                if (!foundOriginal && slot.func_77973_b() == this.original) {
                    foundOriginal = true;
                    continue;
                }
                while (iterator.hasNext()) {
                    Ingredient next = iterator.next();
                    if (!next.apply(slot)) continue;
                    inRecipe = true;
                    iterator.remove();
                    break;
                }
                if (inRecipe) continue;
                return false;
            }
            return required.isEmpty() && foundOriginal;
        }

        public ItemStack func_77572_b(InventoryCrafting inv) {
            for (int i = 0; i < inv.func_174923_h(); ++i) {
                for (int j = 0; j < inv.func_174922_i(); ++j) {
                    ItemStack itemstack = inv.func_70463_b(j, i);
                    if (this.original != itemstack.func_77973_b()) continue;
                    ItemStack stack = new ItemStack(this.result.func_77973_b());
                    stack.func_77982_d(itemstack.func_77978_p());
                    stack.func_77964_b(itemstack.func_77952_i());
                    return stack;
                }
            }
            return ItemStack.field_190927_a;
        }

        public boolean func_194133_a(int width, int height) {
            return width * height >= this.ingredientList.size() + 1;
        }

        public String func_193358_e() {
            return this.group;
        }

        public boolean func_192399_d() {
            return true;
        }

        public ItemStack func_77571_b() {
            return ItemStack.field_190927_a;
        }
    }
}

