/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.utilities.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lucraft.mods.lucraftcore.utilities.items.ItemInstruction;
import lucraft.mods.lucraftcore.utilities.recipes.InstructionRecipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntityConstructionTable
extends TileEntity
implements ITickable,
IInventory {
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private String customName;
    public int selectedRecipe = -1;

    public void func_73660_a() {
        if (this.func_70301_a(0).func_190926_b() && this.selectedRecipe >= 0 || this.selectedRecipe >= this.getInstructionRecipes().size()) {
            this.setSelectedRecipe(-1);
        }
    }

    public void onLoad() {
        super.onLoad();
    }

    public void setSelectedRecipe(int i) {
        this.selectedRecipe = i;
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
        this.func_70296_d();
    }

    public List<InstructionRecipe> getInstructionRecipes() {
        if (this.func_70301_a(0).func_190926_b()) {
            return new ArrayList<InstructionRecipe>();
        }
        InstructionRecipe[] recipes = ItemInstruction.getInstructionRecipes(this.func_70301_a(0));
        return recipes == null ? new ArrayList() : Arrays.asList(recipes);
    }

    public boolean hasPlayerThisItem(InventoryPlayer inv, ItemStack stack) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack s = inv.func_70301_a(i);
            if (!this.areItemsEqual(stack, s)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPlayerAllRequiredItems(InventoryPlayer inv, InstructionRecipe recipe) {
        boolean flag = true;
        for (ItemStack stack : recipe.getRequirements()) {
            if (this.hasPlayerThisItem(inv, stack)) continue;
            flag = false;
        }
        return flag;
    }

    public boolean areItemsEqual(ItemStack needed, ItemStack stack) {
        return needed.func_77973_b() == stack.func_77973_b() && stack.func_190916_E() >= needed.func_190916_E() && stack.func_77952_i() == needed.func_77952_i();
    }

    public void craftItem(InventoryPlayer inv) {
        InstructionRecipe recipe;
        if (this.selectedRecipe >= 0 && this.selectedRecipe < this.getInstructionRecipes().size() && this.hasPlayerAllRequiredItems(inv, recipe = this.getInstructionRecipes().get(this.selectedRecipe))) {
            block0: for (ItemStack stack : recipe.getRequirements()) {
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack s = inv.func_70301_a(i);
                    if (s.func_190926_b() || !this.areItemsEqual(stack, s)) continue;
                    s.func_190918_g(stack.func_190916_E());
                    if (s.func_190916_E() <= 0) {
                        s = ItemStack.field_190927_a;
                    }
                    inv.func_70299_a(i, s);
                    inv.func_70296_d();
                    continue block0;
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
        this.selectedRecipe = compound.func_74762_e("SelectedRecipe");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        compound.func_74768_a("SelectedRecipe", this.selectedRecipe);
        return super.func_189515_b(compound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, tag);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        this.func_189515_b(nbt);
        return nbt;
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 ? stack.func_77973_b() instanceof ItemInstruction : false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "tile.construction_table.name";
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.customName) : new TextComponentTranslation("tile.construction_table.name", new Object[0]);
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomInventoryName(String name) {
        this.customName = name;
    }
}

