/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.utilities.jei;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.addonpacks.AddonPackReadEvent;
import lucraft.mods.lucraftcore.network.LCPacketDispatcher;
import lucraft.mods.lucraftcore.utilities.network.MessageClearJEIInfo;
import lucraft.mods.lucraftcore.utilities.network.MessageSyncJEIInfo;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.apache.commons.io.FilenameUtils;

@Mod.EventBusSubscriber(modid="lucraftcore")
public class JEIInfoReader {
    private static Map<ResourceLocation, JsonObject> data = new HashMap<ResourceLocation, JsonObject>();
    private static Map<ResourceLocation, JEIInfo> INFO = new HashMap<ResourceLocation, JEIInfo>();
    private static Map<ResourceLocation, JEIInfo> OVERRIDEN = new HashMap<ResourceLocation, JEIInfo>();

    @SubscribeEvent
    public static void onReadInfo(AddonPackReadEvent e) {
        if (Loader.isModLoaded((String)"jei") && e.getDirectory().equals("jei_info") && FilenameUtils.getExtension((String)e.getFileName()).equalsIgnoreCase("json")) {
            try {
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(e.getInputStream(), StandardCharsets.UTF_8));
                JsonObject jsonobject = new JsonParser().parse((Reader)bufferedreader).getAsJsonObject();
                data.put(e.getResourceLocation(), jsonobject);
            }
            catch (Exception e2) {
                LucraftCore.LOGGER.error("Wasn't able to read JEI info '" + e.getFileName() + "' in addon pack '" + e.getPackFile().getName() + "': " + e2.getMessage());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        if (!e.player.field_70170_p.field_72995_K && e.player instanceof EntityPlayerMP) {
            LCPacketDispatcher.sendTo(new MessageClearJEIInfo(), (EntityPlayerMP)e.player);
            for (ResourceLocation loc : INFO.keySet()) {
                JEIInfo info = INFO.get(loc);
                LCPacketDispatcher.sendTo(new MessageSyncJEIInfo(loc, info), (EntityPlayerMP)e.player);
            }
        }
    }

    public static Map<ResourceLocation, JEIInfo> getInfo() {
        return OVERRIDEN;
    }

    public static void register(ResourceLocation loc, JEIInfo info) {
        INFO.put(loc, info);
        OVERRIDEN.put(loc, info);
    }

    public static void loadRecipes() {
        if (!Loader.isModLoaded((String)"jei")) {
            return;
        }
        for (ResourceLocation loc : data.keySet()) {
            JsonObject jsonobject = data.get(loc);
            INFO.put(loc, JEIInfo.deserialize(jsonobject));
            OVERRIDEN.put(loc, JEIInfo.deserialize(jsonobject));
        }
        data.clear();
    }

    public static class JEIInfo {
        protected ItemStack[] itemStacks;
        protected ITextComponent text;

        public JEIInfo(ITextComponent text, ItemStack ... itemStacks) {
            this.itemStacks = itemStacks;
            this.text = text;
        }

        public ItemStack[] getItemStacks() {
            return this.itemStacks;
        }

        public ITextComponent getText() {
            return this.text;
        }

        public static JEIInfo deserialize(JsonObject json) {
            JsonArray array = JsonUtils.func_151214_t((JsonObject)json, (String)"items");
            ItemStack[] stacks = new ItemStack[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                JsonObject object = array.get(i).getAsJsonObject();
                stacks[i] = JEIInfo.deserializeItemStack(object);
            }
            ITextComponent text = ITextComponent.Serializer.func_150699_a((String)JsonUtils.func_152754_s((JsonObject)json, (String)"text").toString());
            return new JEIInfo(text, stacks);
        }

        private static ItemStack deserializeItemStack(JsonObject object) {
            if (!object.has("item")) {
                throw new JsonSyntaxException("Unsupported item, add 'item' key");
            }
            Item item = JsonUtils.func_188180_i((JsonObject)object, (String)"item");
            int i = JsonUtils.func_151208_a((JsonObject)object, (String)"data", (int)0);
            ItemStack ret = new ItemStack(item, JsonUtils.func_151208_a((JsonObject)object, (String)"amount", (int)1), i);
            ret.func_77982_d(net.minecraftforge.common.util.JsonUtils.readNBT((JsonObject)object, (String)"nbt"));
            return ret;
        }
    }
}

