/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.utilities.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import lucraft.mods.lucraftcore.LCConfig;
import lucraft.mods.lucraftcore.infinity.ModuleInfinity;
import lucraft.mods.lucraftcore.util.helper.ItemHelper;
import lucraft.mods.lucraftcore.util.recipe.RecipeFactoryRecolor;
import lucraft.mods.lucraftcore.utilities.blocks.UtilitiesBlocks;
import lucraft.mods.lucraftcore.utilities.container.ContainerExtractor;
import lucraft.mods.lucraftcore.utilities.gui.GuiBoiler;
import lucraft.mods.lucraftcore.utilities.gui.GuiExtractor;
import lucraft.mods.lucraftcore.utilities.jei.JEIInfoReader;
import lucraft.mods.lucraftcore.utilities.jei.LCAnvilRecipe;
import lucraft.mods.lucraftcore.utilities.jei.boiler.BoilerRecipeCategory;
import lucraft.mods.lucraftcore.utilities.jei.boiler.BoilerRecipeWrapper;
import lucraft.mods.lucraftcore.utilities.jei.crafting.RecolorRecipeWrapper;
import lucraft.mods.lucraftcore.utilities.jei.extractor.ExtractorRecipeCategory;
import lucraft.mods.lucraftcore.utilities.jei.extractor.ExtractorRecipeWrapper;
import lucraft.mods.lucraftcore.utilities.jei.extractor.ExtractorTransferInfo;
import lucraft.mods.lucraftcore.utilities.jei.instruction.InstructionRecipeCategory;
import lucraft.mods.lucraftcore.utilities.jei.instruction.InstructionRecipeWrapper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.Loader;

@JEIPlugin
public class LCJEIPlugin
implements IModPlugin {
    public static final ResourceLocation TEXTURE = new ResourceLocation("lucraftcore", "textures/gui/jei.png");
    public static final String EXTRACTOR = "lucraftcore.extractor";
    public static final String INSTRUCTION = "lucraftcore.instruction";
    public static final String BOILER = "lucraftcore.boiler";
    public static IGuiHelper guiHelper;

    public void register(IModRegistry reg) {
        IRecipeTransferRegistry recipeTransferRegistry = reg.getRecipeTransferRegistry();
        reg.handleRecipes(RecipeFactoryRecolor.RecipeRecolor.class, recipe -> new RecolorRecipeWrapper(reg.getJeiHelpers(), (RecipeFactoryRecolor.RecipeRecolor)((Object)recipe)), "minecraft.crafting");
        reg.addRecipes(ExtractorRecipeWrapper.getRecipes(), EXTRACTOR);
        reg.addRecipeClickArea(GuiExtractor.class, 4, 4, 168, 11, new String[]{EXTRACTOR});
        reg.addRecipeCatalyst((Object)new ItemStack(UtilitiesBlocks.EXTRACTOR), new String[]{EXTRACTOR});
        recipeTransferRegistry.addRecipeTransferHandler(ContainerExtractor.class, EXTRACTOR, 0, 1, 6, 36);
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new ExtractorTransferInfo());
        reg.addRecipes(InstructionRecipeWrapper.getRecipes(), INSTRUCTION);
        reg.addRecipeCatalyst((Object)new ItemStack(UtilitiesBlocks.CONSTRUCTION_TABLE), new String[]{INSTRUCTION});
        reg.addRecipes(BoilerRecipeWrapper.getRecipes(reg.getJeiHelpers()), BOILER);
        reg.addRecipeClickArea(GuiBoiler.class, 106, 44, 28, 23, new String[]{BOILER});
        reg.addRecipeCatalyst((Object)new ItemStack(UtilitiesBlocks.BOILER), new String[]{BOILER});
        for (JEIInfoReader.JEIInfo i : JEIInfoReader.getInfo().values()) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (ItemStack s : i.getItemStacks()) {
                items.add(s);
            }
            String s = i.text instanceof TextComponentTranslation ? ((TextComponentTranslation)i.text).func_150268_i() : i.text.func_150254_d();
            reg.addIngredientInfo(items, ItemStack.class, new String[]{s});
        }
        if (ModuleInfinity.INSTANCE.isEnabled()) {
            Predicate<LCAnvilRecipe> predicate = recipe -> {
                if ((Loader.isModLoaded((String)"tconstruct") || Loader.isModLoaded((String)"thermalexpansion")) && LCConfig.infinity.disableAnvilWithMods) {
                    return false;
                }
                return LCConfig.infinity.anvilCrafting;
            };
            reg.addRecipes(Arrays.asList(new LCAnvilRecipe(new ItemStack(ModuleInfinity.INFINITY_GAUNTLET_CAST), (List<ItemStack>)ItemHelper.getOres("plateGoldTitaniumAlloy", 6), Arrays.asList(new ItemStack(ModuleInfinity.INFINITY_GAUNTLET))).setPredicate(predicate)), "minecraft.anvil");
        }
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        guiHelper = reg.getJeiHelpers().getGuiHelper();
        reg.addRecipeCategories(new IRecipeCategory[]{new ExtractorRecipeCategory(guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new InstructionRecipeCategory(guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new BoilerRecipeCategory(guiHelper)});
    }
}

