/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.utilities.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.addonpacks.AddonPackReadEvent;
import lucraft.mods.lucraftcore.utilities.recipes.InstructionRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.FilenameUtils;

@Mod.EventBusSubscriber(modid="lucraftcore")
public class AddonPackInstructionRecipeReader {
    public static Map<ResourceLocation, JsonObject> recipes = new HashMap<ResourceLocation, JsonObject>();

    @SubscribeEvent
    public static void onRead(AddonPackReadEvent e) {
        if (e.getDirectory().equals("instructionrecipes") && FilenameUtils.getExtension((String)e.getFileName()).equalsIgnoreCase("json")) {
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(e.getInputStream(), StandardCharsets.UTF_8));
            JsonObject jsonobject = new JsonParser().parse((Reader)bufferedreader).getAsJsonObject();
            recipes.put(e.getResourceLocation(), jsonobject);
        }
    }

    public static void loadRecipes() {
        for (ResourceLocation loc : recipes.keySet()) {
            InstructionRecipe recipe = null;
            try {
                JsonObject jsonobject = recipes.get(loc);
                ItemStack output = AddonPackInstructionRecipeReader.deserializeItemStack(JsonUtils.func_152754_s((JsonObject)jsonobject, (String)"output"));
                ArrayList<ItemStack> requirements = new ArrayList<ItemStack>();
                JsonArray array = JsonUtils.func_151214_t((JsonObject)jsonobject, (String)"requirements");
                for (int i = 0; i < array.size(); ++i) {
                    JsonObject obj = array.get(i).getAsJsonObject();
                    requirements.add(AddonPackInstructionRecipeReader.deserializeItemStack(obj));
                }
                recipe = new InstructionRecipe(output, requirements.toArray(new ItemStack[requirements.size()])).setRegistryName(loc);
            }
            catch (JsonParseException e) {
                LucraftCore.LOGGER.error("Error in instruction recipe '" + loc.toString() + "': " + e.getMessage());
            }
            if (recipe == null) continue;
            InstructionRecipe.registerInstructionRecipe(recipe);
        }
        recipes.clear();
    }

    private static ItemStack deserializeItemStack(JsonObject object) throws JsonParseException {
        if (!object.has("item")) {
            throw new JsonSyntaxException("Unsupported icon type, currently only items are supported (add 'item' key)");
        }
        Item item = JsonUtils.func_188180_i((JsonObject)object, (String)"item");
        int i = JsonUtils.func_151208_a((JsonObject)object, (String)"data", (int)0);
        ItemStack ret = new ItemStack(item, JsonUtils.func_151208_a((JsonObject)object, (String)"amount", (int)1), i);
        ret.func_77982_d(net.minecraftforge.common.util.JsonUtils.readNBT((JsonObject)object, (String)"nbt"));
        return ret;
    }
}

