/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.block;

import com.mike_caron.mikesmodslib.Mod;
import com.mike_caron.mikesmodslib.network.IGuiUpdater;
import com.mike_caron.mikesmodslib.network.MessageUpdateGui;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class ContainerBase
extends Container
implements IGuiUpdater {
    private Runnable onGuiUpdate;
    private IInventory playerInventory;
    protected boolean changed = false;
    protected boolean ownSlotUpdates = true;

    public void func_75142_b() {
        this.changed = false;
        if (this.ownSlotUpdates) {
            for (int i = 0; i < this.field_75151_b.size(); ++i) {
                ItemStack knownStack;
                ItemStack invStack = ((Slot)this.field_75151_b.get(i)).func_75211_c();
                if (ItemStack.func_77989_b((ItemStack)invStack, (ItemStack)(knownStack = (ItemStack)this.field_75153_a.get(i))) && invStack.func_190916_E() == knownStack.func_190916_E()) continue;
                this.field_75153_a.set(i, (Object)invStack);
                this.changed = true;
            }
        } else {
            super.func_75142_b();
        }
    }

    public ContainerBase(IInventory player) {
        this.playerInventory = player;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    protected void init() {
        this.addOwnSlots();
        this.addPlayerSlots(this.playerInventory);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void setGuiListener(Runnable onUpdate) {
        this.onGuiUpdate = onUpdate;
    }

    protected int playerInventoryX() {
        return 11;
    }

    protected int playerInventoryY() {
        return 71;
    }

    protected void addPlayerSlots(IInventory playerInventory) {
        int px = this.playerInventoryX();
        int py = this.playerInventoryY();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = px + col * 18;
                int y = row * 18 + py;
                this.func_75146_a(new Slot(playerInventory, (row + 1) * 9 + col, x, y));
            }
        }
        for (int col = 0; col < 9; ++col) {
            int x = px + col * 18;
            int y = 58 + py;
            this.func_75146_a(new Slot(playerInventory, col, x, y));
        }
    }

    protected void addOwnSlots() {
    }

    protected int numOwnSlots() {
        return 0;
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < this.numOwnSlots() ? !this.func_75135_a(itemstack1, this.numOwnSlots(), this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, this.numOwnSlots(), false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public final NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        this.onWriteNBT(tag);
        return tag;
    }

    protected void onWriteNBT(NBTTagCompound tag) {
        if (this.ownSlotUpdates) {
            NBTTagCompound slots = new NBTTagCompound();
            for (int i = 0; i < this.field_75151_b.size(); ++i) {
                ItemStack itemstack1 = ((Slot)this.field_75151_b.get(i)).func_75211_c();
                if (itemstack1.func_190926_b()) continue;
                NBTTagCompound item = itemstack1.serializeNBT();
                slots.func_74782_a(Integer.toString(i), (NBTBase)item);
            }
            tag.func_74782_a("Slots", (NBTBase)slots);
        }
    }

    protected void onReadNBT(NBTTagCompound tag) {
        if (this.ownSlotUpdates && tag.func_74764_b("Slots")) {
            NBTTagCompound slots = tag.func_74775_l("Slots");
            for (int i = 0; i < this.field_75151_b.size(); ++i) {
                String key = Integer.toString(i);
                if (slots.func_74764_b(key)) {
                    NBTTagCompound nbt = slots.func_74775_l(key);
                    ItemStack stack = new ItemStack(nbt);
                    if (ItemStack.func_77989_b((ItemStack)stack, (ItemStack)((Slot)this.field_75151_b.get(i)).func_75211_c())) continue;
                    ((Slot)this.field_75151_b.get(i)).func_75215_d(stack);
                    continue;
                }
                if (!((Slot)this.field_75151_b.get(i)).func_75216_d()) continue;
                ((Slot)this.field_75151_b.get(i)).func_75215_d(ItemStack.field_190927_a);
            }
        }
    }

    public final void deserializeNBT(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound != null) {
            this.changed = true;
            this.onReadNBT(nbtTagCompound);
            if (this.changed) {
                this.notifyGuiUpdate();
            }
        }
    }

    protected void notifyGuiUpdate() {
        if (this.onGuiUpdate != null) {
            this.onGuiUpdate.run();
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        this.triggerUpdate(listener);
    }

    protected void triggerUpdate() {
        MessageUpdateGui message = new MessageUpdateGui(this);
        for (IContainerListener listener : this.field_75149_d) {
            if (!(listener instanceof EntityPlayerMP)) continue;
            Mod.networkWrapper.sendTo((IMessage)message, (EntityPlayerMP)listener);
        }
    }

    protected void triggerUpdate(IContainerListener listener) {
        MessageUpdateGui message = new MessageUpdateGui(this);
        if (listener instanceof EntityPlayerMP) {
            Mod.networkWrapper.sendTo((IMessage)message, (EntityPlayerMP)listener);
        }
    }

    public ItemStack getDraggedItem() {
        if (this.playerInventory instanceof InventoryPlayer) {
            return ((InventoryPlayer)this.playerInventory).func_70445_o();
        }
        return ItemStack.field_190927_a;
    }
}

