/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public abstract class CommandBase
implements ICommand {
    private final List<String> aliases = new ArrayList<String>();
    private final Map<String, Tuple<TriAction<MinecraftServer, ICommandSender, String[]>, Boolean>> subCommands = new HashMap<String, Tuple<TriAction<MinecraftServer, ICommandSender, String[]>, Boolean>>();

    public CommandBase() {
        this.aliases.add(this.func_71517_b());
    }

    protected void addAlias(@Nonnull String alias) {
        this.aliases.add(alias);
    }

    protected void addSubCommand(String cmd, TriAction<MinecraftServer, ICommandSender, String[]> action, boolean opOnly) {
        this.subCommands.put(cmd, (Tuple<TriAction<MinecraftServer, ICommandSender, String[]>, Boolean>)new Tuple(action, (Object)opOnly));
    }

    @Nonnull
    public final String func_71518_a(@Nonnull ICommandSender iCommandSender) {
        return "Usage: " + this.func_71517_b() + " " + String.join((CharSequence)" | ", this.subCommands.keySet());
    }

    @Nonnull
    public final List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(@Nullable MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (args.length == 0 || !this.subCommands.containsKey(args[0])) {
            sender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
            return;
        }
        String[] newArgs = (String[])Arrays.stream(args).skip(1L).toArray(String[]::new);
        Tuple<TriAction<MinecraftServer, ICommandSender, String[]>, Boolean> action = this.subCommands.get(args[0]);
        if (server != null && ((Boolean)action.func_76340_b()).booleanValue() && !sender.func_70003_b(2, "")) {
            throw new CommandException("You do not have permission to use that command", new Object[0]);
        }
        ((TriAction)action.func_76341_a()).execute(server, sender, newArgs);
    }

    public boolean func_184882_a(@Nonnull MinecraftServer minecraftServer, @Nonnull ICommandSender iCommandSender) {
        return true;
    }

    @Nonnull
    public List<String> func_184883_a(@Nonnull MinecraftServer minecraftServer, @Nonnull ICommandSender iCommandSender, @Nonnull String[] args, @Nullable BlockPos blockPos) {
        List<String> ret = new ArrayList<String>();
        if (args.length == 1) {
            ret = this.subCommands.keySet().stream().filter(s -> s.startsWith(args[0])).collect(Collectors.toList());
        }
        return ret;
    }

    public boolean func_82358_a(@Nonnull String[] args, int i) {
        return false;
    }

    public int compareTo(@Nonnull ICommand o) {
        return 0;
    }

    public static interface TriAction<X, Y, Z> {
        public void execute(@Nullable X var1, @Nonnull Y var2, @Nonnull Z var3) throws CommandException;
    }
}

