/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.fluid;

import net.minecraft.block.material.Material;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidBase
extends Fluid {
    protected float overlayAlpha = 0.2f;
    protected SoundEvent emptySound = SoundEvents.field_187624_K;
    protected SoundEvent fillSound = SoundEvents.field_187630_M;
    protected Material material = Material.field_151586_h;

    public FluidBase(String fluidName, ResourceLocation still, ResourceLocation flowing) {
        this(fluidName, still, flowing, true);
    }

    public FluidBase(String fluidName, ResourceLocation still, ResourceLocation flowing, boolean autoRegister) {
        super(fluidName, still, flowing);
        this.setGaseous(false);
        if (autoRegister) {
            FluidRegistry.registerFluid((Fluid)this);
            FluidRegistry.addBucketForFluid((Fluid)this);
        }
    }

    public int getColor() {
        return this.color;
    }

    public FluidBase setColor(int parColor) {
        this.color = parColor;
        return this;
    }

    public float getAlpha() {
        return this.overlayAlpha;
    }

    public FluidBase setAlpha(float parOverlayAlpha) {
        this.overlayAlpha = parOverlayAlpha;
        return this;
    }

    public FluidBase setEmptySound(SoundEvent parSound) {
        this.emptySound = parSound;
        return this;
    }

    public SoundEvent getEmptySound() {
        return this.emptySound;
    }

    public FluidBase setFillSound(SoundEvent parSound) {
        this.fillSound = parSound;
        return this;
    }

    public SoundEvent getFillSound() {
        return this.fillSound;
    }

    public FluidBase setMaterial(Material parMaterial) {
        this.material = parMaterial;
        return this;
    }

    public Material getMaterial() {
        return this.material;
    }

    public boolean doesVaporize(FluidStack fluidStack) {
        if (this.block == null) {
            return false;
        }
        return this.block.func_176223_P().func_185904_a() == this.getMaterial();
    }
}

