/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.gui;

import com.mike_caron.mikesmodslib.Mod;
import com.mike_caron.mikesmodslib.gui.GuiControl;
import com.mike_caron.mikesmodslib.gui.GuiLabel;
import com.mike_caron.mikesmodslib.gui.GuiUtil;
import com.mike_caron.mikesmodslib.gui.IGuiGroup;
import java.awt.Color;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

public class GuiBase
extends GuiScreen
implements IGuiGroup {
    protected int guiLeft;
    protected int guiTop;
    protected int xSize;
    protected int ySize;
    protected ResourceLocation background;
    protected final List<GuiControl> controls = new ArrayList<GuiControl>();
    private GuiLabel titleLabel;
    private Color foreColor = GuiUtil.FONT_COLOUR;
    private GuiControl mouseOverControl = null;
    private boolean leftDown = false;
    private boolean rightDown = false;
    private boolean middleDown = false;
    private List<List<GuiControl>> waitingForButton = new ArrayList<List<GuiControl>>();

    public GuiBase(int width, int height, ResourceLocation background) {
        this.xSize = width;
        this.ySize = height;
        this.background = background;
        this.waitingForButton.add(new ArrayList());
        this.waitingForButton.add(new ArrayList());
        this.waitingForButton.add(new ArrayList());
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        super.func_146280_a(mc, width, height);
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        GuiControl newMouseControl = null;
        newMouseControl = this.hitTest(mouseX - this.guiLeft, mouseY - this.guiTop);
        if (this.mouseOverControl != newMouseControl) {
            if (this.mouseOverControl != null) {
                this.mouseOverControl.onMouseExit();
            }
            this.mouseOverControl = newMouseControl;
            if (this.mouseOverControl != null) {
                this.mouseOverControl.onMouseEnter();
            }
        }
        if (this.mouseOverControl != null) {
            int transX = this.mouseOverControl.parent.translateFromScreenX(mouseX) - this.guiLeft - this.mouseOverControl.getX();
            int transY = this.mouseOverControl.parent.translateFromScreenY(mouseY) - this.guiTop - this.mouseOverControl.getY();
            this.mouseOverControl.onMouseOver(transX, transY);
            int dWheel = Mouse.getEventDWheel() / 120;
            if (dWheel != 0) {
                this.mouseOverControl.onMouseWheel(transX, transY, dWheel);
            }
        }
        Stream<GuiControl> allWaiting = this.waitingForButton.stream().map(Collection::stream).reduce(Stream.empty(), Stream::concat).distinct();
        allWaiting.forEach(c -> c.onMouseMove(c.parent.translateFromScreenX(mouseX) - c.getX(), c.parent.translateFromScreenY(mouseY) - c.getY()));
        int button = Mouse.getEventButton();
        if (button >= 0 && button <= 2) {
            boolean newState = Mouse.getEventButtonState();
            if (this.getStateForButton(button) && !newState) {
                this.setStateForButton(button, false);
                for (GuiControl waiting : this.waitingForButton.get(button)) {
                    int transX = waiting.parent.translateFromScreenX(mouseX) - waiting.getX();
                    int transY = waiting.parent.translateFromScreenY(mouseY) - waiting.getY();
                    waiting.onMouseUp(transX, transY, button);
                }
                this.waitingForButton.get(button).clear();
            } else if (!this.getStateForButton(button) && newState) {
                this.setStateForButton(button, true);
                if (this.mouseOverControl != null) {
                    int transX = this.mouseOverControl.parent.translateFromScreenX(mouseX) - this.mouseOverControl.getX();
                    int transY = this.mouseOverControl.parent.translateFromScreenY(mouseY) - this.mouseOverControl.getY();
                    this.mouseOverControl.onMouseDown(transX, transY, button);
                    this.waitingForButton.get(button).add(this.mouseOverControl);
                }
                if (this.mouseOverControl == null || !this.mouseOverControl.canHaveFocus()) {
                    for (GuiControl control : this.controls) {
                        if (!control.hasFocus()) continue;
                        control.setFocused(false);
                        break;
                    }
                }
            }
        }
    }

    private boolean getStateForButton(int button) {
        if (button == 0) {
            return this.leftDown;
        }
        if (button == 1) {
            return this.rightDown;
        }
        if (button == 2) {
            return this.middleDown;
        }
        return false;
    }

    private void setStateForButton(int button, boolean state) {
        if (button == 0) {
            this.leftDown = state;
        }
        if (button == 1) {
            this.rightDown = state;
        }
        if (button == 2) {
            this.middleDown = state;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (GuiControl control : this.controls) {
            control.update();
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        boolean textFocused = false;
        for (GuiControl control : this.controls) {
            if (!control.hasFocus()) continue;
            textFocused = true;
            control.onKeyTyped(typedChar, keyCode);
            if (keyCode != 1) break;
            control.setFocused(false);
            this.controlLostFocus(control);
            break;
        }
        if (!textFocused) {
            if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
                this.field_146297_k.field_71439_g.func_71053_j();
                return;
            }
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public final void func_73866_w_() {
        super.func_73866_w_();
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        for (GuiControl control : this.controls) {
            if (!control.isVisible()) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)control.getX(), (float)control.getY(), (float)0.0f);
            control.preDraw();
            control.draw();
            control.postDraw();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    public void drawGuiContainerBackgroundLayer(int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.background);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.drawGuiContainerBackgroundLayer(mouseX, mouseY);
        this.drawGuiContainerForegroundLayer(mouseX, mouseY);
        this.renderHoveredToolTip((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)(this.field_146297_k.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL), mouseX, mouseY);
    }

    @Override
    public void addControl(GuiControl control) {
        this.controls.add(control);
        control.setParent(this);
        this.sort();
    }

    @Override
    public int translateToScreenX(int x) {
        return this.guiLeft + x;
    }

    @Override
    public int translateToScreenY(int y) {
        return this.guiTop + y;
    }

    @Override
    public int translateFromScreenX(int x) {
        return x - this.guiLeft;
    }

    @Override
    public int translateFromScreenY(int y) {
        return y - this.guiTop;
    }

    @Override
    public void removeControl(GuiControl control) {
        this.controls.remove((Object)control);
    }

    @Override
    public void clearControls() {
        this.controls.clear();
    }

    protected String getTitleKey() {
        return null;
    }

    protected void drawCenteredWrappedString(String message, int x, int y, int wrapWidth) {
        List lines = this.field_146289_q.func_78271_c(message, wrapWidth);
        int height = 10 * lines.size();
        int ty = y - height / 2;
        for (int i = 0; i < lines.size(); ++i) {
            int w = this.field_146289_q.func_78256_a((String)lines.get(i));
            this.field_146289_q.func_78276_b((String)lines.get(i), x - w / 2, ty, GuiUtil.FONT_COLOUR.getRGB());
            ty += 10;
        }
    }

    protected void controlLostFocus(Gui textField) {
    }

    protected void initControls() {
        this.addControls();
    }

    protected void addControls() {
        String key = this.getTitleKey();
        if (key == null) {
            key = "title not set";
        }
        this.titleLabel = GuiUtil.staticLabelFromTranslationKey(6, 6, key, new Object[0]);
        this.addControl(this.titleLabel);
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    protected void onActionPerformed(GuiControl control) {
    }

    protected void renderHoveredToolTip(EntityPlayer player, ITooltipFlag tooltipFlag, int mouseX, int mouseY) {
        int goodY;
        int goodX;
        List<String> toolTip;
        if (this.mouseOverControl != null && (toolTip = this.mouseOverControl.getTooltip(player, tooltipFlag, goodX = this.mouseOverControl.parent.translateFromScreenX(mouseX), goodY = this.mouseOverControl.parent.translateFromScreenY(mouseY))) != null) {
            this.func_146283_a(toolTip, mouseX, mouseY);
        }
    }

    @Override
    public void onMouseEnter() {
    }

    @Override
    public void onMouseExit() {
    }

    @Override
    public void onMouseOver(int mouseX, int mouseY) {
    }

    @Override
    public void onMouseDown(int mouseX, int mouseY, int button) {
    }

    @Override
    public void onMouseUp(int mouseX, int mouseY, int button) {
    }

    @Override
    public void onMouseMove(int mouseX, int mouseY) {
    }

    @Override
    public void onMouseWheel(int mouseX, int mouseY, int deltaWheel) {
    }

    @Override
    @Nullable
    public GuiControl hitTest(int x, int y) {
        for (GuiControl control : this.controls) {
            int transY;
            int transX;
            GuiControl ret;
            if (!control.isVisible() || !control.isEnabled() || (ret = control.hitTest(transX = x - control.getX(), transY = y - control.getY())) == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public void sort() {
        this.controls.sort(Comparator.comparingInt(a -> a.zIndex));
    }

    @Override
    public boolean notifyTakeFocus(GuiControl taker) {
        for (GuiControl control : this.controls) {
            if (control == taker || !control.hasFocus()) continue;
            control.setFocused(false);
        }
        return true;
    }

    protected void func_175282_a(URI url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, url);
        }
        catch (Throwable var4) {
            Throwable throwable = var4.getCause();
            Mod.logger.error("Couldn't open link: {}", (Object)(throwable == null ? "<UNKNOWN>" : throwable.getMessage()));
        }
    }

    @Override
    public Color getForeColor() {
        return this.foreColor;
    }

    @Override
    public void setForeColor(Color color) {
        this.foreColor = color;
    }
}

