/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.gui;

import com.mike_caron.mikesmodslib.gui.ControlEvent;
import com.mike_caron.mikesmodslib.gui.GuiControl;
import com.mike_caron.mikesmodslib.gui.GuiImage;
import com.mike_caron.mikesmodslib.gui.GuiSized;
import com.mike_caron.mikesmodslib.gui.GuiUtil;
import com.mike_caron.mikesmodslib.gui.IGuiGroup;
import java.awt.Color;
import java.util.EventListener;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;

public class GuiButton
extends GuiSized {
    protected int id;
    private String label;
    protected State state;
    private GuiImage image;

    public GuiButton(int id, int x, int y, int width, int height, String label) {
        super(x, y, width, height);
        this.id = id;
        this.label = label;
        this.state = State.NORMAL;
    }

    @Override
    public void setParent(IGuiGroup parent) {
        super.setParent(parent);
        if (this.image != null) {
            this.image.setParent(parent);
        }
    }

    public GuiButton(int id, int x, int y, int width, int height, String label, GuiImage image) {
        super(x, y, width, height);
        this.id = id;
        this.label = label;
        this.state = State.NORMAL;
        this.image = image;
    }

    @Override
    public void onMouseUp(int mouseX, int mouseY, int button) {
        if (!this.enabled) {
            return;
        }
        if (button != 0) {
            return;
        }
        if (GuiUtil.inBoundsThis(mouseX, mouseY, this)) {
            this.state = State.HOVERED;
            this.triggerClicked();
        } else {
            this.state = State.NORMAL;
        }
    }

    @Override
    public void onMouseDown(int mouseX, int mouseY, int button) {
        if (!this.enabled) {
            return;
        }
        if (button != 0) {
            return;
        }
        this.state = State.PRESSED;
        GuiUtil.playSound(SoundEvents.field_187909_gi);
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        Color fore = Color.WHITE;
        if (!this.enabled) {
            fore = Color.LIGHT_GRAY;
            this.state = State.NORMAL;
        }
        int sx = 0;
        if (this.enabled) {
            switch (this.state) {
                case NORMAL: {
                    sx = 16;
                    break;
                }
                case HOVERED: {
                    sx = 32;
                    break;
                }
                case PRESSED: {
                    sx = 48;
                }
            }
        } else {
            sx = 64;
        }
        GuiUtil.bindTexture(GuiUtil.MISC_RESOURCES);
        GuiUtil.setGLColor(Color.WHITE);
        GuiUtil.draw3x3(0, 0, this.width, this.height, sx, 0);
        int imageX = this.width / 2;
        int labelX = this.width / 2;
        int labelWidth = 0;
        if (this.label != null) {
            labelWidth = this.parent.getFontRenderer().func_78256_a(this.label);
            labelX -= labelWidth / 2;
        }
        if (this.image != null) {
            imageX -= this.image.getWidth() / 2;
        }
        if (this.image != null && this.label != null) {
            imageX -= labelWidth / 2 + 2;
            labelX += this.image.getWidth() / 2 + 2;
        }
        if (this.label != null) {
            this.drawShadowedText(this.label, labelX, this.height / 2 - 5, fore, Color.BLACK);
        }
        if (this.image != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)imageX, (float)(this.height / 2 - this.image.getHeight() / 2), (float)0.0f);
            Color col = Color.WHITE;
            if (!this.enabled) {
                col = col.darker();
            }
            GuiUtil.setGLColor(col);
            this.image.draw();
            GlStateManager.func_179121_F();
        }
    }

    private void drawShadowedText(String label, int x, int y, Color fore, Color shadow) {
        this.parent.getFontRenderer().func_78276_b(label, x + 1, y + 1, shadow.getRGB());
        this.parent.getFontRenderer().func_78276_b(label, x, y, fore.getRGB());
    }

    public void setImage(GuiImage img) {
        this.image = img;
        if (this.image != null) {
            this.image.setParent(this.parent);
        }
    }

    @Override
    public void onMouseEnter() {
        if (!this.enabled) {
            return;
        }
        if (this.state == State.NORMAL) {
            this.state = State.HOVERED;
        }
    }

    @Override
    public void onMouseExit() {
        if (this.state == State.HOVERED) {
            this.state = State.NORMAL;
        }
    }

    public void setLabel(@Nonnull String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    private void triggerClicked() {
        if (!this.enabled) {
            return;
        }
        ClickedEvent evt = new ClickedEvent(this, this.id);
        for (EventListener listener : this.listeners) {
            if (!(listener instanceof ClickedListener)) continue;
            ((ClickedListener)listener).clicked(evt);
        }
    }

    public static class ClickedEvent
    extends ControlEvent {
        public final int id;

        public ClickedEvent(GuiControl control, int id) {
            super(control);
            this.id = id;
        }
    }

    public static interface ClickedListener
    extends EventListener {
        public void clicked(ClickedEvent var1);
    }

    protected static enum State {
        NORMAL,
        HOVERED,
        PRESSED;

    }
}

