/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.gui;

import com.mike_caron.mikesmodslib.gui.GuiSized;
import com.mike_caron.mikesmodslib.gui.GuiUtil;
import org.lwjgl.opengl.GL11;

public abstract class GuiClippedSized
extends GuiSized {
    protected int scrollX;
    protected int scrollY;
    protected int marginLeft = 0;
    protected int marginRight = 0;
    protected int marginTop = 0;
    protected int marginBottom = 0;
    private boolean clippingEnabled = false;

    public GuiClippedSized(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    protected void start() {
        this.clippingEnabled = GL11.glIsEnabled((int)3089);
        GL11.glEnable((int)3089);
        this.assertClippingPlane();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(-this.scrollX), (float)(-this.scrollY), (float)0.0f);
    }

    protected void assertClippingPlane() {
        this.setClippingPlane(this.parent.translateToScreenX(this.x) + this.marginLeft, this.parent.translateToScreenY(this.y + this.marginTop) + this.height - this.marginTop - this.marginBottom, this.width - this.marginLeft - this.marginRight, this.height - this.marginTop - this.marginBottom);
    }

    protected void finish() {
        GL11.glPopMatrix();
        if (!this.clippingEnabled) {
            GL11.glDisable((int)3089);
        }
    }

    protected void setClippingPlane(int x, int y, int width, int height) {
        int realX = GuiUtil.getRealX(x);
        int realY = GuiUtil.getRealY(y);
        int realWidth = GuiUtil.getRealWidth(width);
        int realHeight = GuiUtil.getRealHeight(height);
        GL11.glScissor((int)realX, (int)realY, (int)realWidth, (int)realHeight);
    }

    public int getScrollX() {
        return this.scrollX;
    }

    public void setScrollX(int scrollX) {
        this.scrollX = scrollX;
    }

    public int getScrollY() {
        return this.scrollY;
    }

    public void setScrollY(int scrollY) {
        this.scrollY = scrollY;
    }
}

