/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.gui;

import com.mike_caron.mikesmodslib.gui.GuiSized;
import com.mike_caron.mikesmodslib.gui.GuiUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class GuiFluid
extends GuiSized {
    private int capacity;
    private int amount;
    private Fluid fluid;
    private FluidStack fluidStack;
    private boolean gradEnabled = false;
    private Orientation orientation;

    public GuiFluid(int x, int y, int width, int height, Orientation orientation) {
        super(x, y, width, height);
        this.orientation = orientation;
    }

    public GuiFluid(int x, int y, int width, int height) {
        this(x, y, width, height, Orientation.VERTICAL);
    }

    @Override
    @Nullable
    public List<String> getTooltip(EntityPlayer player, ITooltipFlag tooltipFlag, int mouseX, int mouseY) {
        ArrayList<String> items = new ArrayList<String>();
        if (this.fluid != null) {
            items.add(this.fluid.getLocalizedName(null));
            StringBuilder sb = new StringBuilder();
            sb.append(NumberFormat.getIntegerInstance().format(this.amount));
            sb.append("/");
            sb.append(NumberFormat.getIntegerInstance().format(this.capacity));
            sb.append("mb");
            items.add(sb.toString());
        } else {
            items.add(GuiUtil.translate("mikesmodslib.gui.fluid.empty", new Object[0]));
        }
        return items;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public void setFluid(Fluid fluid) {
        this.fluid = fluid;
        this.fluidStack = fluid != null ? new FluidStack(fluid, 1) : null;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public boolean isGradEnabled() {
        return this.gradEnabled;
    }

    public void setGradEnabled(boolean gradEnabled) {
        this.gradEnabled = gradEnabled;
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        int drawWidth = this.width;
        int drawHeight = this.height;
        if (this.orientation == Orientation.VERTICAL) {
            drawHeight = this.getScaled(drawHeight);
        } else if (this.orientation == Orientation.HORIZONTAL) {
            drawWidth = this.getScaled(drawWidth);
        }
        GuiUtil.drawFluid(0, this.height - drawHeight, this.fluidStack, drawWidth, drawHeight);
        if (this.gradEnabled) {
            GuiUtil.bindTexture(GuiUtil.MISC_RESOURCES);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiUtil.drawTiledTexturePart(this.width - 16, 0, 16, this.height, 0, 0, 16, 16, 256, 256);
        }
    }

    private int getScaled(int i) {
        int ret = (int)Math.floor((double)this.amount / (double)this.capacity * (double)i);
        if (ret == 0 && this.amount > 0) {
            return 1;
        }
        return ret;
    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

